/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.MaintenanceWindowExecutionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the information about an execution of a Maintenance Window.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MaintenanceWindowExecution implements StructuredPojo,
        ToCopyableBuilder<MaintenanceWindowExecution.Builder, MaintenanceWindowExecution> {
    private final String windowId;

    private final String windowExecutionId;

    private final String status;

    private final String statusDetails;

    private final Instant startTime;

    private final Instant endTime;

    private MaintenanceWindowExecution(BuilderImpl builder) {
        this.windowId = builder.windowId;
        this.windowExecutionId = builder.windowExecutionId;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    /**
     * <p>
     * The ID of the Maintenance Window.
     * </p>
     * 
     * @return The ID of the Maintenance Window.
     */
    public String windowId() {
        return windowId;
    }

    /**
     * <p>
     * The ID of the Maintenance Window execution.
     * </p>
     * 
     * @return The ID of the Maintenance Window execution.
     */
    public String windowExecutionId() {
        return windowExecutionId;
    }

    /**
     * <p>
     * The status of the execution.
     * </p>
     * 
     * @return The status of the execution.
     * @see MaintenanceWindowExecutionStatus
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The details explaining the Status. Only available for certain status values.
     * </p>
     * 
     * @return The details explaining the Status. Only available for certain status values.
     */
    public String statusDetails() {
        return statusDetails;
    }

    /**
     * <p>
     * The time the execution started.
     * </p>
     * 
     * @return The time the execution started.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time the execution finished.
     * </p>
     * 
     * @return The time the execution finished.
     */
    public Instant endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((windowId() == null) ? 0 : windowId().hashCode());
        hashCode = 31 * hashCode + ((windowExecutionId() == null) ? 0 : windowExecutionId().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((statusDetails() == null) ? 0 : statusDetails().hashCode());
        hashCode = 31 * hashCode + ((startTime() == null) ? 0 : startTime().hashCode());
        hashCode = 31 * hashCode + ((endTime() == null) ? 0 : endTime().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowExecution)) {
            return false;
        }
        MaintenanceWindowExecution other = (MaintenanceWindowExecution) obj;
        if (other.windowId() == null ^ this.windowId() == null) {
            return false;
        }
        if (other.windowId() != null && !other.windowId().equals(this.windowId())) {
            return false;
        }
        if (other.windowExecutionId() == null ^ this.windowExecutionId() == null) {
            return false;
        }
        if (other.windowExecutionId() != null && !other.windowExecutionId().equals(this.windowExecutionId())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.statusDetails() == null ^ this.statusDetails() == null) {
            return false;
        }
        if (other.statusDetails() != null && !other.statusDetails().equals(this.statusDetails())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (windowId() != null) {
            sb.append("WindowId: ").append(windowId()).append(",");
        }
        if (windowExecutionId() != null) {
            sb.append("WindowExecutionId: ").append(windowExecutionId()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (statusDetails() != null) {
            sb.append("StatusDetails: ").append(statusDetails()).append(",");
        }
        if (startTime() != null) {
            sb.append("StartTime: ").append(startTime()).append(",");
        }
        if (endTime() != null) {
            sb.append("EndTime: ").append(endTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MaintenanceWindowExecutionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, MaintenanceWindowExecution> {
        /**
         * <p>
         * The ID of the Maintenance Window.
         * </p>
         * 
         * @param windowId
         *        The ID of the Maintenance Window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowId(String windowId);

        /**
         * <p>
         * The ID of the Maintenance Window execution.
         * </p>
         * 
         * @param windowExecutionId
         *        The ID of the Maintenance Window execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowExecutionId(String windowExecutionId);

        /**
         * <p>
         * The status of the execution.
         * </p>
         * 
         * @param status
         *        The status of the execution.
         * @see MaintenanceWindowExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceWindowExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the execution.
         * </p>
         * 
         * @param status
         *        The status of the execution.
         * @see MaintenanceWindowExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceWindowExecutionStatus
         */
        Builder status(MaintenanceWindowExecutionStatus status);

        /**
         * <p>
         * The details explaining the Status. Only available for certain status values.
         * </p>
         * 
         * @param statusDetails
         *        The details explaining the Status. Only available for certain status values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDetails(String statusDetails);

        /**
         * <p>
         * The time the execution started.
         * </p>
         * 
         * @param startTime
         *        The time the execution started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time the execution finished.
         * </p>
         * 
         * @param endTime
         *        The time the execution finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);
    }

    private static final class BuilderImpl implements Builder {
        private String windowId;

        private String windowExecutionId;

        private String status;

        private String statusDetails;

        private Instant startTime;

        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowExecution model) {
            setWindowId(model.windowId);
            setWindowExecutionId(model.windowExecutionId);
            setStatus(model.status);
            setStatusDetails(model.statusDetails);
            setStartTime(model.startTime);
            setEndTime(model.endTime);
        }

        public final String getWindowId() {
            return windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getWindowExecutionId() {
            return windowExecutionId;
        }

        @Override
        public final Builder windowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
            return this;
        }

        public final void setWindowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MaintenanceWindowExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(MaintenanceWindowExecutionStatus status) {
            this.status(status.toString());
        }

        public final String getStatusDetails() {
            return statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public MaintenanceWindowExecution build() {
            return new MaintenanceWindowExecution(this);
        }
    }
}
