/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.MaintenanceWindowTargetMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The target registered with the Maintenance Window.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MaintenanceWindowTarget implements StructuredPojo,
        ToCopyableBuilder<MaintenanceWindowTarget.Builder, MaintenanceWindowTarget> {
    private final String windowId;

    private final String windowTargetId;

    private final String resourceType;

    private final List<Target> targets;

    private final String ownerInformation;

    private MaintenanceWindowTarget(BuilderImpl builder) {
        this.windowId = builder.windowId;
        this.windowTargetId = builder.windowTargetId;
        this.resourceType = builder.resourceType;
        this.targets = builder.targets;
        this.ownerInformation = builder.ownerInformation;
    }

    /**
     * <p>
     * The Maintenance Window ID where the target is registered.
     * </p>
     * 
     * @return The Maintenance Window ID where the target is registered.
     */
    public String windowId() {
        return windowId;
    }

    /**
     * <p>
     * The ID of the target.
     * </p>
     * 
     * @return The ID of the target.
     */
    public String windowTargetId() {
        return windowTargetId;
    }

    /**
     * <p>
     * The type of target.
     * </p>
     * 
     * @return The type of target.
     * @see MaintenanceWindowResourceType
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The targets (either instances or tags). Instances are specified using
     * Key=instanceids,Values=&lt;instanceid1&gt;,&lt;instanceid2&gt;. Tags are specified using Key=&lt;tag
     * name&gt;,Values=&lt;tag value&gt;.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The targets (either instances or tags). Instances are specified using
     *         Key=instanceids,Values=&lt;instanceid1&gt;,&lt;instanceid2&gt;. Tags are specified using Key=&lt;tag
     *         name&gt;,Values=&lt;tag value&gt;.
     */
    public List<Target> targets() {
        return targets;
    }

    /**
     * <p>
     * User-provided value that will be included in any CloudWatch events raised while running tasks for these targets
     * in this Maintenance Window.
     * </p>
     * 
     * @return User-provided value that will be included in any CloudWatch events raised while running tasks for these
     *         targets in this Maintenance Window.
     */
    public String ownerInformation() {
        return ownerInformation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((windowId() == null) ? 0 : windowId().hashCode());
        hashCode = 31 * hashCode + ((windowTargetId() == null) ? 0 : windowTargetId().hashCode());
        hashCode = 31 * hashCode + ((resourceType() == null) ? 0 : resourceType().hashCode());
        hashCode = 31 * hashCode + ((targets() == null) ? 0 : targets().hashCode());
        hashCode = 31 * hashCode + ((ownerInformation() == null) ? 0 : ownerInformation().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowTarget)) {
            return false;
        }
        MaintenanceWindowTarget other = (MaintenanceWindowTarget) obj;
        if (other.windowId() == null ^ this.windowId() == null) {
            return false;
        }
        if (other.windowId() != null && !other.windowId().equals(this.windowId())) {
            return false;
        }
        if (other.windowTargetId() == null ^ this.windowTargetId() == null) {
            return false;
        }
        if (other.windowTargetId() != null && !other.windowTargetId().equals(this.windowTargetId())) {
            return false;
        }
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.targets() == null ^ this.targets() == null) {
            return false;
        }
        if (other.targets() != null && !other.targets().equals(this.targets())) {
            return false;
        }
        if (other.ownerInformation() == null ^ this.ownerInformation() == null) {
            return false;
        }
        if (other.ownerInformation() != null && !other.ownerInformation().equals(this.ownerInformation())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (windowId() != null) {
            sb.append("WindowId: ").append(windowId()).append(",");
        }
        if (windowTargetId() != null) {
            sb.append("WindowTargetId: ").append(windowTargetId()).append(",");
        }
        if (resourceType() != null) {
            sb.append("ResourceType: ").append(resourceType()).append(",");
        }
        if (targets() != null) {
            sb.append("Targets: ").append(targets()).append(",");
        }
        if (ownerInformation() != null) {
            sb.append("OwnerInformation: ").append(ownerInformation()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MaintenanceWindowTargetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, MaintenanceWindowTarget> {
        /**
         * <p>
         * The Maintenance Window ID where the target is registered.
         * </p>
         * 
         * @param windowId
         *        The Maintenance Window ID where the target is registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowId(String windowId);

        /**
         * <p>
         * The ID of the target.
         * </p>
         * 
         * @param windowTargetId
         *        The ID of the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowTargetId(String windowTargetId);

        /**
         * <p>
         * The type of target.
         * </p>
         * 
         * @param resourceType
         *        The type of target.
         * @see MaintenanceWindowResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceWindowResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of target.
         * </p>
         * 
         * @param resourceType
         *        The type of target.
         * @see MaintenanceWindowResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceWindowResourceType
         */
        Builder resourceType(MaintenanceWindowResourceType resourceType);

        /**
         * <p>
         * The targets (either instances or tags). Instances are specified using
         * Key=instanceids,Values=&lt;instanceid1&gt;,&lt;instanceid2&gt;. Tags are specified using Key=&lt;tag
         * name&gt;,Values=&lt;tag value&gt;.
         * </p>
         * 
         * @param targets
         *        The targets (either instances or tags). Instances are specified using
         *        Key=instanceids,Values=&lt;instanceid1&gt;,&lt;instanceid2&gt;. Tags are specified using Key=&lt;tag
         *        name&gt;,Values=&lt;tag value&gt;.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<Target> targets);

        /**
         * <p>
         * The targets (either instances or tags). Instances are specified using
         * Key=instanceids,Values=&lt;instanceid1&gt;,&lt;instanceid2&gt;. Tags are specified using Key=&lt;tag
         * name&gt;,Values=&lt;tag value&gt;.
         * </p>
         * 
         * @param targets
         *        The targets (either instances or tags). Instances are specified using
         *        Key=instanceids,Values=&lt;instanceid1&gt;,&lt;instanceid2&gt;. Tags are specified using Key=&lt;tag
         *        name&gt;,Values=&lt;tag value&gt;.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Target... targets);

        /**
         * <p>
         * User-provided value that will be included in any CloudWatch events raised while running tasks for these
         * targets in this Maintenance Window.
         * </p>
         * 
         * @param ownerInformation
         *        User-provided value that will be included in any CloudWatch events raised while running tasks for
         *        these targets in this Maintenance Window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerInformation(String ownerInformation);
    }

    private static final class BuilderImpl implements Builder {
        private String windowId;

        private String windowTargetId;

        private String resourceType;

        private List<Target> targets;

        private String ownerInformation;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowTarget model) {
            setWindowId(model.windowId);
            setWindowTargetId(model.windowTargetId);
            setResourceType(model.resourceType);
            setTargets(model.targets);
            setOwnerInformation(model.ownerInformation);
        }

        public final String getWindowId() {
            return windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getWindowTargetId() {
            return windowTargetId;
        }

        @Override
        public final Builder windowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
            return this;
        }

        public final void setWindowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(MaintenanceWindowResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final void setResourceType(MaintenanceWindowResourceType resourceType) {
            this.resourceType(resourceType.toString());
        }

        public final Collection<Target> getTargets() {
            return targets;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        public final void setTargets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
        }

        @SafeVarargs
        public final void setTargets(Target... targets) {
            targets(Arrays.asList(targets));
        }

        public final String getOwnerInformation() {
            return ownerInformation;
        }

        @Override
        public final Builder ownerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
            return this;
        }

        public final void setOwnerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
        }

        @Override
        public MaintenanceWindowTarget build() {
            return new MaintenanceWindowTarget(this);
        }
    }
}
