/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateDocumentDefaultVersionResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<UpdateDocumentDefaultVersionResponse.Builder, UpdateDocumentDefaultVersionResponse> {
    private final DocumentDefaultVersionDescription description;

    private UpdateDocumentDefaultVersionResponse(BuilderImpl builder) {
        this.description = builder.description;
    }

    /**
     * <p>
     * The description of a custom document that you want to set as the default version.
     * </p>
     * 
     * @return The description of a custom document that you want to set as the default version.
     */
    public DocumentDefaultVersionDescription description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDocumentDefaultVersionResponse)) {
            return false;
        }
        UpdateDocumentDefaultVersionResponse other = (UpdateDocumentDefaultVersionResponse) obj;
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateDocumentDefaultVersionResponse> {
        /**
         * <p>
         * The description of a custom document that you want to set as the default version.
         * </p>
         * 
         * @param description
         *        The description of a custom document that you want to set as the default version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(DocumentDefaultVersionDescription description);
    }

    private static final class BuilderImpl implements Builder {
        private DocumentDefaultVersionDescription description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDocumentDefaultVersionResponse model) {
            setDescription(model.description);
        }

        public final DocumentDefaultVersionDescription getDescription() {
            return description;
        }

        @Override
        public final Builder description(DocumentDefaultVersionDescription description) {
            this.description = description;
            return this;
        }

        public final void setDescription(DocumentDefaultVersionDescription description) {
            this.description = description;
        }

        @Override
        public UpdateDocumentDefaultVersionResponse build() {
            return new UpdateDocumentDefaultVersionResponse(this);
        }
    }
}
