/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.ssm.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * GetCommandInvocationResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetCommandInvocationResponseUnmarshaller implements
        Unmarshaller<GetCommandInvocationResponse, JsonUnmarshallerContext> {

    public GetCommandInvocationResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        GetCommandInvocationResponse.Builder getCommandInvocationResponseBuilder = GetCommandInvocationResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return getCommandInvocationResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("CommandId", targetDepth)) {
                    context.nextToken();
                    getCommandInvocationResponseBuilder.commandId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("InstanceId", targetDepth)) {
                    context.nextToken();
                    getCommandInvocationResponseBuilder.instanceId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Comment", targetDepth)) {
                    context.nextToken();
                    getCommandInvocationResponseBuilder.comment(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DocumentName", targetDepth)) {
                    context.nextToken();
                    getCommandInvocationResponseBuilder.documentName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("PluginName", targetDepth)) {
                    context.nextToken();
                    getCommandInvocationResponseBuilder.pluginName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ResponseCode", targetDepth)) {
                    context.nextToken();
                    getCommandInvocationResponseBuilder.responseCode(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("ExecutionStartDateTime", targetDepth)) {
                    context.nextToken();
                    getCommandInvocationResponseBuilder.executionStartDateTime(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("ExecutionElapsedTime", targetDepth)) {
                    context.nextToken();
                    getCommandInvocationResponseBuilder.executionElapsedTime(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("ExecutionEndDateTime", targetDepth)) {
                    context.nextToken();
                    getCommandInvocationResponseBuilder.executionEndDateTime(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    getCommandInvocationResponseBuilder.status(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("StatusDetails", targetDepth)) {
                    context.nextToken();
                    getCommandInvocationResponseBuilder.statusDetails(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("StandardOutputContent", targetDepth)) {
                    context.nextToken();
                    getCommandInvocationResponseBuilder.standardOutputContent(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("StandardOutputUrl", targetDepth)) {
                    context.nextToken();
                    getCommandInvocationResponseBuilder.standardOutputUrl(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("StandardErrorContent", targetDepth)) {
                    context.nextToken();
                    getCommandInvocationResponseBuilder.standardErrorContent(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("StandardErrorUrl", targetDepth)) {
                    context.nextToken();
                    getCommandInvocationResponseBuilder.standardErrorUrl(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return getCommandInvocationResponseBuilder.build();
    }

    private static GetCommandInvocationResponseUnmarshaller INSTANCE;

    public static GetCommandInvocationResponseUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new GetCommandInvocationResponseUnmarshaller();
        return INSTANCE;
    }
}
