/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.services.ssm.model.*;

import software.amazon.awssdk.protocol.*;
import software.amazon.awssdk.annotation.SdkInternalApi;

/**
 * MaintenanceWindowExecutionTaskIdentityMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class MaintenanceWindowExecutionTaskIdentityMarshaller {

    private static final MarshallingInfo<String> WINDOWEXECUTIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowExecutionId").build();
    private static final MarshallingInfo<String> TASKEXECUTIONID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskExecutionId").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> STATUSDETAILS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusDetails").build();
    private static final MarshallingInfo<java.time.Instant> STARTTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").build();
    private static final MarshallingInfo<java.time.Instant> ENDTIME_BINDING = MarshallingInfo.builder(MarshallingType.INSTANT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").build();
    private static final MarshallingInfo<String> TASKARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskArn").build();
    private static final MarshallingInfo<String> TASKTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskType").build();

    private static final MaintenanceWindowExecutionTaskIdentityMarshaller instance = new MaintenanceWindowExecutionTaskIdentityMarshaller();

    public static MaintenanceWindowExecutionTaskIdentityMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(MaintenanceWindowExecutionTaskIdentity maintenanceWindowExecutionTaskIdentity,
            ProtocolMarshaller protocolMarshaller) {

        if (maintenanceWindowExecutionTaskIdentity == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(maintenanceWindowExecutionTaskIdentity.windowExecutionId(), WINDOWEXECUTIONID_BINDING);

            protocolMarshaller.marshall(maintenanceWindowExecutionTaskIdentity.taskExecutionId(), TASKEXECUTIONID_BINDING);

            protocolMarshaller.marshall(maintenanceWindowExecutionTaskIdentity.status(), STATUS_BINDING);

            protocolMarshaller.marshall(maintenanceWindowExecutionTaskIdentity.statusDetails(), STATUSDETAILS_BINDING);

            protocolMarshaller.marshall(maintenanceWindowExecutionTaskIdentity.startTime(), STARTTIME_BINDING);

            protocolMarshaller.marshall(maintenanceWindowExecutionTaskIdentity.endTime(), ENDTIME_BINDING);

            protocolMarshaller.marshall(maintenanceWindowExecutionTaskIdentity.taskArn(), TASKARN_BINDING);

            protocolMarshaller.marshall(maintenanceWindowExecutionTaskIdentity.taskType(), TASKTYPE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
