/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.ssm.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * MaintenanceWindowExecutionTaskIdentity JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class MaintenanceWindowExecutionTaskIdentityUnmarshaller implements
        Unmarshaller<MaintenanceWindowExecutionTaskIdentity, JsonUnmarshallerContext> {

    public MaintenanceWindowExecutionTaskIdentity unmarshall(JsonUnmarshallerContext context) throws Exception {
        MaintenanceWindowExecutionTaskIdentity.Builder maintenanceWindowExecutionTaskIdentityBuilder = MaintenanceWindowExecutionTaskIdentity
                .builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("WindowExecutionId", targetDepth)) {
                    context.nextToken();
                    maintenanceWindowExecutionTaskIdentityBuilder.windowExecutionId(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("TaskExecutionId", targetDepth)) {
                    context.nextToken();
                    maintenanceWindowExecutionTaskIdentityBuilder.taskExecutionId(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    maintenanceWindowExecutionTaskIdentityBuilder.status(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("StatusDetails", targetDepth)) {
                    context.nextToken();
                    maintenanceWindowExecutionTaskIdentityBuilder.statusDetails(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("StartTime", targetDepth)) {
                    context.nextToken();
                    maintenanceWindowExecutionTaskIdentityBuilder.startTime(context.getUnmarshaller(java.time.Instant.class)
                            .unmarshall(context));
                }
                if (context.testExpression("EndTime", targetDepth)) {
                    context.nextToken();
                    maintenanceWindowExecutionTaskIdentityBuilder.endTime(context.getUnmarshaller(java.time.Instant.class)
                            .unmarshall(context));
                }
                if (context.testExpression("TaskArn", targetDepth)) {
                    context.nextToken();
                    maintenanceWindowExecutionTaskIdentityBuilder.taskArn(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("TaskType", targetDepth)) {
                    context.nextToken();
                    maintenanceWindowExecutionTaskIdentityBuilder.taskType(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return maintenanceWindowExecutionTaskIdentityBuilder.build();
    }

    private static MaintenanceWindowExecutionTaskIdentityUnmarshaller INSTANCE;

    public static MaintenanceWindowExecutionTaskIdentityUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new MaintenanceWindowExecutionTaskIdentityUnmarshaller();
        return INSTANCE;
    }
}
