/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.util.Map;
import java.util.List;
import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.services.ssm.model.*;

import software.amazon.awssdk.util.IdempotentUtils;

import software.amazon.awssdk.protocol.*;
import software.amazon.awssdk.annotation.SdkInternalApi;

/**
 * RegisterTaskWithMaintenanceWindowRequestMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class RegisterTaskWithMaintenanceWindowRequestModelMarshaller {

    private static final MarshallingInfo<String> WINDOWID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowId").build();
    private static final MarshallingInfo<List> TARGETS_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Targets").build();
    private static final MarshallingInfo<String> TASKARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskArn").build();
    private static final MarshallingInfo<String> SERVICEROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceRoleArn").build();
    private static final MarshallingInfo<String> TASKTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskType").build();
    private static final MarshallingInfo<Map> TASKPARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskParameters").build();
    private static final MarshallingInfo<Integer> PRIORITY_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Priority").build();
    private static final MarshallingInfo<String> MAXCONCURRENCY_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxConcurrency").build();
    private static final MarshallingInfo<String> MAXERRORS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxErrors").build();
    private static final MarshallingInfo<StructuredPojo> LOGGINGINFO_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LoggingInfo")
            .build();
    private static final MarshallingInfo<String> CLIENTTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientToken")
            .defaultValueSupplier(software.amazon.awssdk.util.IdempotentUtils.getGenerator()).build();

    private static final RegisterTaskWithMaintenanceWindowRequestModelMarshaller instance = new RegisterTaskWithMaintenanceWindowRequestModelMarshaller();

    public static RegisterTaskWithMaintenanceWindowRequestModelMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(RegisterTaskWithMaintenanceWindowRequest registerTaskWithMaintenanceWindowRequest,
            ProtocolMarshaller protocolMarshaller) {

        if (registerTaskWithMaintenanceWindowRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(registerTaskWithMaintenanceWindowRequest.windowId(), WINDOWID_BINDING);

            protocolMarshaller.marshall(registerTaskWithMaintenanceWindowRequest.targets(), TARGETS_BINDING);

            protocolMarshaller.marshall(registerTaskWithMaintenanceWindowRequest.taskArn(), TASKARN_BINDING);

            protocolMarshaller.marshall(registerTaskWithMaintenanceWindowRequest.serviceRoleArn(), SERVICEROLEARN_BINDING);

            protocolMarshaller.marshall(registerTaskWithMaintenanceWindowRequest.taskType(), TASKTYPE_BINDING);

            protocolMarshaller.marshall(registerTaskWithMaintenanceWindowRequest.taskParameters(), TASKPARAMETERS_BINDING);

            protocolMarshaller.marshall(registerTaskWithMaintenanceWindowRequest.priority(), PRIORITY_BINDING);

            protocolMarshaller.marshall(registerTaskWithMaintenanceWindowRequest.maxConcurrency(), MAXCONCURRENCY_BINDING);

            protocolMarshaller.marshall(registerTaskWithMaintenanceWindowRequest.maxErrors(), MAXERRORS_BINDING);

            protocolMarshaller.marshall(registerTaskWithMaintenanceWindowRequest.loggingInfo(), LOGGINGINFO_BINDING);

            protocolMarshaller.marshall(registerTaskWithMaintenanceWindowRequest.clientToken(), CLIENTTOKEN_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
