/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTask;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeMaintenanceWindowTasksResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeMaintenanceWindowTasksResponse> {
    private final List<MaintenanceWindowTask> tasks;
    private final String nextToken;

    private DescribeMaintenanceWindowTasksResponse(BuilderImpl builder) {
        this.tasks = builder.tasks;
        this.nextToken = builder.nextToken;
    }

    public List<MaintenanceWindowTask> tasks() {
        return this.tasks;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.tasks() == null ? 0 : this.tasks().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowTasksResponse)) {
            return false;
        }
        DescribeMaintenanceWindowTasksResponse other = (DescribeMaintenanceWindowTasksResponse)((Object)obj);
        if (other.tasks() == null ^ this.tasks() == null) {
            return false;
        }
        if (other.tasks() != null && !other.tasks().equals(this.tasks())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.tasks() != null) {
            sb.append("Tasks: ").append(this.tasks()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<MaintenanceWindowTask> tasks;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowTasksResponse model) {
            this.setTasks(model.tasks);
            this.setNextToken(model.nextToken);
        }

        public final Collection<MaintenanceWindowTask> getTasks() {
            return this.tasks;
        }

        @Override
        public final Builder tasks(Collection<MaintenanceWindowTask> tasks) {
            this.tasks = MaintenanceWindowTaskListCopier.copy(tasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(MaintenanceWindowTask ... tasks) {
            this.tasks(Arrays.asList(tasks));
            return this;
        }

        public final void setTasks(Collection<MaintenanceWindowTask> tasks) {
            this.tasks = MaintenanceWindowTaskListCopier.copy(tasks);
        }

        @SafeVarargs
        public final void setTasks(MaintenanceWindowTask ... tasks) {
            this.tasks(Arrays.asList(tasks));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeMaintenanceWindowTasksResponse build() {
            return new DescribeMaintenanceWindowTasksResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeMaintenanceWindowTasksResponse> {
        public Builder tasks(Collection<MaintenanceWindowTask> var1);

        public Builder tasks(MaintenanceWindowTask ... var1);

        public Builder nextToken(String var1);
    }
}

