/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ssm.model.ParameterStringFilter;
import software.amazon.awssdk.services.ssm.model.ParameterStringFilterListCopier;
import software.amazon.awssdk.services.ssm.model.ParametersFilter;
import software.amazon.awssdk.services.ssm.model.ParametersFilterListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeParametersRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeParametersRequest> {
    private final List<ParametersFilter> filters;
    private final List<ParameterStringFilter> parameterFilters;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeParametersRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.parameterFilters = builder.parameterFilters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<ParametersFilter> filters() {
        return this.filters;
    }

    public List<ParameterStringFilter> parameterFilters() {
        return this.parameterFilters;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.parameterFilters() == null ? 0 : this.parameterFilters().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeParametersRequest)) {
            return false;
        }
        DescribeParametersRequest other = (DescribeParametersRequest)((Object)obj);
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.parameterFilters() == null ^ this.parameterFilters() == null) {
            return false;
        }
        if (other.parameterFilters() != null && !other.parameterFilters().equals(this.parameterFilters())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.parameterFilters() != null) {
            sb.append("ParameterFilters: ").append(this.parameterFilters()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ParametersFilter> filters;
        private List<ParameterStringFilter> parameterFilters;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeParametersRequest model) {
            this.setFilters(model.filters);
            this.setParameterFilters(model.parameterFilters);
            this.setMaxResults(model.maxResults);
            this.setNextToken(model.nextToken);
        }

        public final Collection<ParametersFilter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<ParametersFilter> filters) {
            this.filters = ParametersFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ParametersFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<ParametersFilter> filters) {
            this.filters = ParametersFilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(ParametersFilter ... filters) {
            this.filters(Arrays.asList(filters));
        }

        public final Collection<ParameterStringFilter> getParameterFilters() {
            return this.parameterFilters;
        }

        @Override
        public final Builder parameterFilters(Collection<ParameterStringFilter> parameterFilters) {
            this.parameterFilters = ParameterStringFilterListCopier.copy(parameterFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterFilters(ParameterStringFilter ... parameterFilters) {
            this.parameterFilters(Arrays.asList(parameterFilters));
            return this;
        }

        public final void setParameterFilters(Collection<ParameterStringFilter> parameterFilters) {
            this.parameterFilters = ParameterStringFilterListCopier.copy(parameterFilters);
        }

        @SafeVarargs
        public final void setParameterFilters(ParameterStringFilter ... parameterFilters) {
            this.parameterFilters(Arrays.asList(parameterFilters));
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeParametersRequest build() {
            return new DescribeParametersRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeParametersRequest> {
        public Builder filters(Collection<ParametersFilter> var1);

        public Builder filters(ParametersFilter ... var1);

        public Builder parameterFilters(Collection<ParameterStringFilter> var1);

        public Builder parameterFilters(ParameterStringFilter ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);
    }
}

