/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ssm.model.ParameterStringFilter;
import software.amazon.awssdk.services.ssm.model.ParameterStringFilterListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetParametersByPathRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetParametersByPathRequest> {
    private final String path;
    private final Boolean recursive;
    private final List<ParameterStringFilter> parameterFilters;
    private final Boolean withDecryption;
    private final Integer maxResults;
    private final String nextToken;

    private GetParametersByPathRequest(BuilderImpl builder) {
        this.path = builder.path;
        this.recursive = builder.recursive;
        this.parameterFilters = builder.parameterFilters;
        this.withDecryption = builder.withDecryption;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public String path() {
        return this.path;
    }

    public Boolean recursive() {
        return this.recursive;
    }

    public List<ParameterStringFilter> parameterFilters() {
        return this.parameterFilters;
    }

    public Boolean withDecryption() {
        return this.withDecryption;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.path() == null ? 0 : this.path().hashCode());
        hashCode = 31 * hashCode + (this.recursive() == null ? 0 : this.recursive().hashCode());
        hashCode = 31 * hashCode + (this.parameterFilters() == null ? 0 : this.parameterFilters().hashCode());
        hashCode = 31 * hashCode + (this.withDecryption() == null ? 0 : this.withDecryption().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParametersByPathRequest)) {
            return false;
        }
        GetParametersByPathRequest other = (GetParametersByPathRequest)((Object)obj);
        if (other.path() == null ^ this.path() == null) {
            return false;
        }
        if (other.path() != null && !other.path().equals(this.path())) {
            return false;
        }
        if (other.recursive() == null ^ this.recursive() == null) {
            return false;
        }
        if (other.recursive() != null && !other.recursive().equals(this.recursive())) {
            return false;
        }
        if (other.parameterFilters() == null ^ this.parameterFilters() == null) {
            return false;
        }
        if (other.parameterFilters() != null && !other.parameterFilters().equals(this.parameterFilters())) {
            return false;
        }
        if (other.withDecryption() == null ^ this.withDecryption() == null) {
            return false;
        }
        if (other.withDecryption() != null && !other.withDecryption().equals(this.withDecryption())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.path() != null) {
            sb.append("Path: ").append(this.path()).append(",");
        }
        if (this.recursive() != null) {
            sb.append("Recursive: ").append(this.recursive()).append(",");
        }
        if (this.parameterFilters() != null) {
            sb.append("ParameterFilters: ").append(this.parameterFilters()).append(",");
        }
        if (this.withDecryption() != null) {
            sb.append("WithDecryption: ").append(this.withDecryption()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String path;
        private Boolean recursive;
        private List<ParameterStringFilter> parameterFilters;
        private Boolean withDecryption;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParametersByPathRequest model) {
            this.setPath(model.path);
            this.setRecursive(model.recursive);
            this.setParameterFilters(model.parameterFilters);
            this.setWithDecryption(model.withDecryption);
            this.setMaxResults(model.maxResults);
            this.setNextToken(model.nextToken);
        }

        public final String getPath() {
            return this.path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final Boolean getRecursive() {
            return this.recursive;
        }

        @Override
        public final Builder recursive(Boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public final void setRecursive(Boolean recursive) {
            this.recursive = recursive;
        }

        public final Collection<ParameterStringFilter> getParameterFilters() {
            return this.parameterFilters;
        }

        @Override
        public final Builder parameterFilters(Collection<ParameterStringFilter> parameterFilters) {
            this.parameterFilters = ParameterStringFilterListCopier.copy(parameterFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterFilters(ParameterStringFilter ... parameterFilters) {
            this.parameterFilters(Arrays.asList(parameterFilters));
            return this;
        }

        public final void setParameterFilters(Collection<ParameterStringFilter> parameterFilters) {
            this.parameterFilters = ParameterStringFilterListCopier.copy(parameterFilters);
        }

        @SafeVarargs
        public final void setParameterFilters(ParameterStringFilter ... parameterFilters) {
            this.parameterFilters(Arrays.asList(parameterFilters));
        }

        public final Boolean getWithDecryption() {
            return this.withDecryption;
        }

        @Override
        public final Builder withDecryption(Boolean withDecryption) {
            this.withDecryption = withDecryption;
            return this;
        }

        public final void setWithDecryption(Boolean withDecryption) {
            this.withDecryption = withDecryption;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public GetParametersByPathRequest build() {
            return new GetParametersByPathRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetParametersByPathRequest> {
        public Builder path(String var1);

        public Builder recursive(Boolean var1);

        public Builder parameterFilters(Collection<ParameterStringFilter> var1);

        public Builder parameterFilters(ParameterStringFilter ... var1);

        public Builder withDecryption(Boolean var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);
    }
}

