/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ssm.model.ParameterNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetParametersRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetParametersRequest> {
    private final List<String> names;
    private final Boolean withDecryption;

    private GetParametersRequest(BuilderImpl builder) {
        this.names = builder.names;
        this.withDecryption = builder.withDecryption;
    }

    public List<String> names() {
        return this.names;
    }

    public Boolean withDecryption() {
        return this.withDecryption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.names() == null ? 0 : this.names().hashCode());
        hashCode = 31 * hashCode + (this.withDecryption() == null ? 0 : this.withDecryption().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParametersRequest)) {
            return false;
        }
        GetParametersRequest other = (GetParametersRequest)((Object)obj);
        if (other.names() == null ^ this.names() == null) {
            return false;
        }
        if (other.names() != null && !other.names().equals(this.names())) {
            return false;
        }
        if (other.withDecryption() == null ^ this.withDecryption() == null) {
            return false;
        }
        return other.withDecryption() == null || other.withDecryption().equals(this.withDecryption());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.names() != null) {
            sb.append("Names: ").append(this.names()).append(",");
        }
        if (this.withDecryption() != null) {
            sb.append("WithDecryption: ").append(this.withDecryption()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> names;
        private Boolean withDecryption;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParametersRequest model) {
            this.setNames(model.names);
            this.setWithDecryption(model.withDecryption);
        }

        public final Collection<String> getNames() {
            return this.names;
        }

        @Override
        public final Builder names(Collection<String> names) {
            this.names = ParameterNameListCopier.copy(names);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder names(String ... names) {
            this.names(Arrays.asList(names));
            return this;
        }

        public final void setNames(Collection<String> names) {
            this.names = ParameterNameListCopier.copy(names);
        }

        @SafeVarargs
        public final void setNames(String ... names) {
            this.names(Arrays.asList(names));
        }

        public final Boolean getWithDecryption() {
            return this.withDecryption;
        }

        @Override
        public final Builder withDecryption(Boolean withDecryption) {
            this.withDecryption = withDecryption;
            return this;
        }

        public final void setWithDecryption(Boolean withDecryption) {
            this.withDecryption = withDecryption;
        }

        public GetParametersRequest build() {
            return new GetParametersRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetParametersRequest> {
        public Builder names(Collection<String> var1);

        public Builder names(String ... var1);

        public Builder withDecryption(Boolean var1);
    }
}

