/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.InstanceAggregatedAssociationOverview;
import software.amazon.awssdk.services.ssm.model.PingStatus;
import software.amazon.awssdk.services.ssm.model.PlatformType;
import software.amazon.awssdk.services.ssm.model.ResourceType;
import software.amazon.awssdk.services.ssm.transform.InstanceInformationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceInformation
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceInformation> {
    private final String instanceId;
    private final String pingStatus;
    private final Instant lastPingDateTime;
    private final String agentVersion;
    private final Boolean isLatestVersion;
    private final String platformType;
    private final String platformName;
    private final String platformVersion;
    private final String activationId;
    private final String iamRole;
    private final Instant registrationDate;
    private final String resourceType;
    private final String name;
    private final String ipAddress;
    private final String computerName;
    private final String associationStatus;
    private final Instant lastAssociationExecutionDate;
    private final Instant lastSuccessfulAssociationExecutionDate;
    private final InstanceAggregatedAssociationOverview associationOverview;

    private InstanceInformation(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.pingStatus = builder.pingStatus;
        this.lastPingDateTime = builder.lastPingDateTime;
        this.agentVersion = builder.agentVersion;
        this.isLatestVersion = builder.isLatestVersion;
        this.platformType = builder.platformType;
        this.platformName = builder.platformName;
        this.platformVersion = builder.platformVersion;
        this.activationId = builder.activationId;
        this.iamRole = builder.iamRole;
        this.registrationDate = builder.registrationDate;
        this.resourceType = builder.resourceType;
        this.name = builder.name;
        this.ipAddress = builder.ipAddress;
        this.computerName = builder.computerName;
        this.associationStatus = builder.associationStatus;
        this.lastAssociationExecutionDate = builder.lastAssociationExecutionDate;
        this.lastSuccessfulAssociationExecutionDate = builder.lastSuccessfulAssociationExecutionDate;
        this.associationOverview = builder.associationOverview;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String pingStatus() {
        return this.pingStatus;
    }

    public Instant lastPingDateTime() {
        return this.lastPingDateTime;
    }

    public String agentVersion() {
        return this.agentVersion;
    }

    public Boolean isLatestVersion() {
        return this.isLatestVersion;
    }

    public String platformType() {
        return this.platformType;
    }

    public String platformName() {
        return this.platformName;
    }

    public String platformVersion() {
        return this.platformVersion;
    }

    public String activationId() {
        return this.activationId;
    }

    public String iamRole() {
        return this.iamRole;
    }

    public Instant registrationDate() {
        return this.registrationDate;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public String name() {
        return this.name;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public String computerName() {
        return this.computerName;
    }

    public String associationStatus() {
        return this.associationStatus;
    }

    public Instant lastAssociationExecutionDate() {
        return this.lastAssociationExecutionDate;
    }

    public Instant lastSuccessfulAssociationExecutionDate() {
        return this.lastSuccessfulAssociationExecutionDate;
    }

    public InstanceAggregatedAssociationOverview associationOverview() {
        return this.associationOverview;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.pingStatus() == null ? 0 : this.pingStatus().hashCode());
        hashCode = 31 * hashCode + (this.lastPingDateTime() == null ? 0 : this.lastPingDateTime().hashCode());
        hashCode = 31 * hashCode + (this.agentVersion() == null ? 0 : this.agentVersion().hashCode());
        hashCode = 31 * hashCode + (this.isLatestVersion() == null ? 0 : this.isLatestVersion().hashCode());
        hashCode = 31 * hashCode + (this.platformType() == null ? 0 : this.platformType().hashCode());
        hashCode = 31 * hashCode + (this.platformName() == null ? 0 : this.platformName().hashCode());
        hashCode = 31 * hashCode + (this.platformVersion() == null ? 0 : this.platformVersion().hashCode());
        hashCode = 31 * hashCode + (this.activationId() == null ? 0 : this.activationId().hashCode());
        hashCode = 31 * hashCode + (this.iamRole() == null ? 0 : this.iamRole().hashCode());
        hashCode = 31 * hashCode + (this.registrationDate() == null ? 0 : this.registrationDate().hashCode());
        hashCode = 31 * hashCode + (this.resourceType() == null ? 0 : this.resourceType().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.ipAddress() == null ? 0 : this.ipAddress().hashCode());
        hashCode = 31 * hashCode + (this.computerName() == null ? 0 : this.computerName().hashCode());
        hashCode = 31 * hashCode + (this.associationStatus() == null ? 0 : this.associationStatus().hashCode());
        hashCode = 31 * hashCode + (this.lastAssociationExecutionDate() == null ? 0 : this.lastAssociationExecutionDate().hashCode());
        hashCode = 31 * hashCode + (this.lastSuccessfulAssociationExecutionDate() == null ? 0 : this.lastSuccessfulAssociationExecutionDate().hashCode());
        hashCode = 31 * hashCode + (this.associationOverview() == null ? 0 : this.associationOverview().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceInformation)) {
            return false;
        }
        InstanceInformation other = (InstanceInformation)obj;
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.pingStatus() == null ^ this.pingStatus() == null) {
            return false;
        }
        if (other.pingStatus() != null && !other.pingStatus().equals(this.pingStatus())) {
            return false;
        }
        if (other.lastPingDateTime() == null ^ this.lastPingDateTime() == null) {
            return false;
        }
        if (other.lastPingDateTime() != null && !other.lastPingDateTime().equals(this.lastPingDateTime())) {
            return false;
        }
        if (other.agentVersion() == null ^ this.agentVersion() == null) {
            return false;
        }
        if (other.agentVersion() != null && !other.agentVersion().equals(this.agentVersion())) {
            return false;
        }
        if (other.isLatestVersion() == null ^ this.isLatestVersion() == null) {
            return false;
        }
        if (other.isLatestVersion() != null && !other.isLatestVersion().equals(this.isLatestVersion())) {
            return false;
        }
        if (other.platformType() == null ^ this.platformType() == null) {
            return false;
        }
        if (other.platformType() != null && !other.platformType().equals(this.platformType())) {
            return false;
        }
        if (other.platformName() == null ^ this.platformName() == null) {
            return false;
        }
        if (other.platformName() != null && !other.platformName().equals(this.platformName())) {
            return false;
        }
        if (other.platformVersion() == null ^ this.platformVersion() == null) {
            return false;
        }
        if (other.platformVersion() != null && !other.platformVersion().equals(this.platformVersion())) {
            return false;
        }
        if (other.activationId() == null ^ this.activationId() == null) {
            return false;
        }
        if (other.activationId() != null && !other.activationId().equals(this.activationId())) {
            return false;
        }
        if (other.iamRole() == null ^ this.iamRole() == null) {
            return false;
        }
        if (other.iamRole() != null && !other.iamRole().equals(this.iamRole())) {
            return false;
        }
        if (other.registrationDate() == null ^ this.registrationDate() == null) {
            return false;
        }
        if (other.registrationDate() != null && !other.registrationDate().equals(this.registrationDate())) {
            return false;
        }
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.ipAddress() == null ^ this.ipAddress() == null) {
            return false;
        }
        if (other.ipAddress() != null && !other.ipAddress().equals(this.ipAddress())) {
            return false;
        }
        if (other.computerName() == null ^ this.computerName() == null) {
            return false;
        }
        if (other.computerName() != null && !other.computerName().equals(this.computerName())) {
            return false;
        }
        if (other.associationStatus() == null ^ this.associationStatus() == null) {
            return false;
        }
        if (other.associationStatus() != null && !other.associationStatus().equals(this.associationStatus())) {
            return false;
        }
        if (other.lastAssociationExecutionDate() == null ^ this.lastAssociationExecutionDate() == null) {
            return false;
        }
        if (other.lastAssociationExecutionDate() != null && !other.lastAssociationExecutionDate().equals(this.lastAssociationExecutionDate())) {
            return false;
        }
        if (other.lastSuccessfulAssociationExecutionDate() == null ^ this.lastSuccessfulAssociationExecutionDate() == null) {
            return false;
        }
        if (other.lastSuccessfulAssociationExecutionDate() != null && !other.lastSuccessfulAssociationExecutionDate().equals(this.lastSuccessfulAssociationExecutionDate())) {
            return false;
        }
        if (other.associationOverview() == null ^ this.associationOverview() == null) {
            return false;
        }
        return other.associationOverview() == null || other.associationOverview().equals(this.associationOverview());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.pingStatus() != null) {
            sb.append("PingStatus: ").append(this.pingStatus()).append(",");
        }
        if (this.lastPingDateTime() != null) {
            sb.append("LastPingDateTime: ").append(this.lastPingDateTime()).append(",");
        }
        if (this.agentVersion() != null) {
            sb.append("AgentVersion: ").append(this.agentVersion()).append(",");
        }
        if (this.isLatestVersion() != null) {
            sb.append("IsLatestVersion: ").append(this.isLatestVersion()).append(",");
        }
        if (this.platformType() != null) {
            sb.append("PlatformType: ").append(this.platformType()).append(",");
        }
        if (this.platformName() != null) {
            sb.append("PlatformName: ").append(this.platformName()).append(",");
        }
        if (this.platformVersion() != null) {
            sb.append("PlatformVersion: ").append(this.platformVersion()).append(",");
        }
        if (this.activationId() != null) {
            sb.append("ActivationId: ").append(this.activationId()).append(",");
        }
        if (this.iamRole() != null) {
            sb.append("IamRole: ").append(this.iamRole()).append(",");
        }
        if (this.registrationDate() != null) {
            sb.append("RegistrationDate: ").append(this.registrationDate()).append(",");
        }
        if (this.resourceType() != null) {
            sb.append("ResourceType: ").append(this.resourceType()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.ipAddress() != null) {
            sb.append("IPAddress: ").append(this.ipAddress()).append(",");
        }
        if (this.computerName() != null) {
            sb.append("ComputerName: ").append(this.computerName()).append(",");
        }
        if (this.associationStatus() != null) {
            sb.append("AssociationStatus: ").append(this.associationStatus()).append(",");
        }
        if (this.lastAssociationExecutionDate() != null) {
            sb.append("LastAssociationExecutionDate: ").append(this.lastAssociationExecutionDate()).append(",");
        }
        if (this.lastSuccessfulAssociationExecutionDate() != null) {
            sb.append("LastSuccessfulAssociationExecutionDate: ").append(this.lastSuccessfulAssociationExecutionDate()).append(",");
        }
        if (this.associationOverview() != null) {
            sb.append("AssociationOverview: ").append(this.associationOverview()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceInformationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String pingStatus;
        private Instant lastPingDateTime;
        private String agentVersion;
        private Boolean isLatestVersion;
        private String platformType;
        private String platformName;
        private String platformVersion;
        private String activationId;
        private String iamRole;
        private Instant registrationDate;
        private String resourceType;
        private String name;
        private String ipAddress;
        private String computerName;
        private String associationStatus;
        private Instant lastAssociationExecutionDate;
        private Instant lastSuccessfulAssociationExecutionDate;
        private InstanceAggregatedAssociationOverview associationOverview;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceInformation model) {
            this.setInstanceId(model.instanceId);
            this.setPingStatus(model.pingStatus);
            this.setLastPingDateTime(model.lastPingDateTime);
            this.setAgentVersion(model.agentVersion);
            this.setIsLatestVersion(model.isLatestVersion);
            this.setPlatformType(model.platformType);
            this.setPlatformName(model.platformName);
            this.setPlatformVersion(model.platformVersion);
            this.setActivationId(model.activationId);
            this.setIamRole(model.iamRole);
            this.setRegistrationDate(model.registrationDate);
            this.setResourceType(model.resourceType);
            this.setName(model.name);
            this.setIPAddress(model.ipAddress);
            this.setComputerName(model.computerName);
            this.setAssociationStatus(model.associationStatus);
            this.setLastAssociationExecutionDate(model.lastAssociationExecutionDate);
            this.setLastSuccessfulAssociationExecutionDate(model.lastSuccessfulAssociationExecutionDate);
            this.setAssociationOverview(model.associationOverview);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getPingStatus() {
            return this.pingStatus;
        }

        @Override
        public final Builder pingStatus(String pingStatus) {
            this.pingStatus = pingStatus;
            return this;
        }

        @Override
        public final Builder pingStatus(PingStatus pingStatus) {
            this.pingStatus(pingStatus.toString());
            return this;
        }

        public final void setPingStatus(String pingStatus) {
            this.pingStatus = pingStatus;
        }

        public final void setPingStatus(PingStatus pingStatus) {
            this.pingStatus(pingStatus.toString());
        }

        public final Instant getLastPingDateTime() {
            return this.lastPingDateTime;
        }

        @Override
        public final Builder lastPingDateTime(Instant lastPingDateTime) {
            this.lastPingDateTime = lastPingDateTime;
            return this;
        }

        public final void setLastPingDateTime(Instant lastPingDateTime) {
            this.lastPingDateTime = lastPingDateTime;
        }

        public final String getAgentVersion() {
            return this.agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        public final Boolean getIsLatestVersion() {
            return this.isLatestVersion;
        }

        @Override
        public final Builder isLatestVersion(Boolean isLatestVersion) {
            this.isLatestVersion = isLatestVersion;
            return this;
        }

        public final void setIsLatestVersion(Boolean isLatestVersion) {
            this.isLatestVersion = isLatestVersion;
        }

        public final String getPlatformType() {
            return this.platformType;
        }

        @Override
        public final Builder platformType(String platformType) {
            this.platformType = platformType;
            return this;
        }

        @Override
        public final Builder platformType(PlatformType platformType) {
            this.platformType(platformType.toString());
            return this;
        }

        public final void setPlatformType(String platformType) {
            this.platformType = platformType;
        }

        public final void setPlatformType(PlatformType platformType) {
            this.platformType(platformType.toString());
        }

        public final String getPlatformName() {
            return this.platformName;
        }

        @Override
        public final Builder platformName(String platformName) {
            this.platformName = platformName;
            return this;
        }

        public final void setPlatformName(String platformName) {
            this.platformName = platformName;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public final String getActivationId() {
            return this.activationId;
        }

        @Override
        public final Builder activationId(String activationId) {
            this.activationId = activationId;
            return this;
        }

        public final void setActivationId(String activationId) {
            this.activationId = activationId;
        }

        public final String getIamRole() {
            return this.iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        public final Instant getRegistrationDate() {
            return this.registrationDate;
        }

        @Override
        public final Builder registrationDate(Instant registrationDate) {
            this.registrationDate = registrationDate;
            return this;
        }

        public final void setRegistrationDate(Instant registrationDate) {
            this.registrationDate = registrationDate;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final void setResourceType(ResourceType resourceType) {
            this.resourceType(resourceType.toString());
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getIPAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIPAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getComputerName() {
            return this.computerName;
        }

        @Override
        public final Builder computerName(String computerName) {
            this.computerName = computerName;
            return this;
        }

        public final void setComputerName(String computerName) {
            this.computerName = computerName;
        }

        public final String getAssociationStatus() {
            return this.associationStatus;
        }

        @Override
        public final Builder associationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
            return this;
        }

        public final void setAssociationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
        }

        public final Instant getLastAssociationExecutionDate() {
            return this.lastAssociationExecutionDate;
        }

        @Override
        public final Builder lastAssociationExecutionDate(Instant lastAssociationExecutionDate) {
            this.lastAssociationExecutionDate = lastAssociationExecutionDate;
            return this;
        }

        public final void setLastAssociationExecutionDate(Instant lastAssociationExecutionDate) {
            this.lastAssociationExecutionDate = lastAssociationExecutionDate;
        }

        public final Instant getLastSuccessfulAssociationExecutionDate() {
            return this.lastSuccessfulAssociationExecutionDate;
        }

        @Override
        public final Builder lastSuccessfulAssociationExecutionDate(Instant lastSuccessfulAssociationExecutionDate) {
            this.lastSuccessfulAssociationExecutionDate = lastSuccessfulAssociationExecutionDate;
            return this;
        }

        public final void setLastSuccessfulAssociationExecutionDate(Instant lastSuccessfulAssociationExecutionDate) {
            this.lastSuccessfulAssociationExecutionDate = lastSuccessfulAssociationExecutionDate;
        }

        public final InstanceAggregatedAssociationOverview getAssociationOverview() {
            return this.associationOverview;
        }

        @Override
        public final Builder associationOverview(InstanceAggregatedAssociationOverview associationOverview) {
            this.associationOverview = associationOverview;
            return this;
        }

        public final void setAssociationOverview(InstanceAggregatedAssociationOverview associationOverview) {
            this.associationOverview = associationOverview;
        }

        public InstanceInformation build() {
            return new InstanceInformation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceInformation> {
        public Builder instanceId(String var1);

        public Builder pingStatus(String var1);

        public Builder pingStatus(PingStatus var1);

        public Builder lastPingDateTime(Instant var1);

        public Builder agentVersion(String var1);

        public Builder isLatestVersion(Boolean var1);

        public Builder platformType(String var1);

        public Builder platformType(PlatformType var1);

        public Builder platformName(String var1);

        public Builder platformVersion(String var1);

        public Builder activationId(String var1);

        public Builder iamRole(String var1);

        public Builder registrationDate(Instant var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder name(String var1);

        public Builder ipAddress(String var1);

        public Builder computerName(String var1);

        public Builder associationStatus(String var1);

        public Builder lastAssociationExecutionDate(Instant var1);

        public Builder lastSuccessfulAssociationExecutionDate(Instant var1);

        public Builder associationOverview(InstanceAggregatedAssociationOverview var1);
    }
}

