/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskParameterValueListCopier;
import software.amazon.awssdk.services.ssm.transform.MaintenanceWindowTaskParameterValueExpressionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MaintenanceWindowTaskParameterValueExpression
implements StructuredPojo,
ToCopyableBuilder<Builder, MaintenanceWindowTaskParameterValueExpression> {
    private final List<String> values;

    private MaintenanceWindowTaskParameterValueExpression(BuilderImpl builder) {
        this.values = builder.values;
    }

    public List<String> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.values() == null ? 0 : this.values().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowTaskParameterValueExpression)) {
            return false;
        }
        MaintenanceWindowTaskParameterValueExpression other = (MaintenanceWindowTaskParameterValueExpression)obj;
        if (other.values() == null ^ this.values() == null) {
            return false;
        }
        return other.values() == null || other.values().equals(this.values());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.values() != null) {
            sb.append("Values: ").append(this.values()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MaintenanceWindowTaskParameterValueExpressionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> values;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowTaskParameterValueExpression model) {
            this.setValues(model.values);
        }

        public final Collection<String> getValues() {
            return this.values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = MaintenanceWindowTaskParameterValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = MaintenanceWindowTaskParameterValueListCopier.copy(values);
        }

        @SafeVarargs
        public final void setValues(String ... values) {
            this.values(Arrays.asList(values));
        }

        public MaintenanceWindowTaskParameterValueExpression build() {
            return new MaintenanceWindowTaskParameterValueExpression(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MaintenanceWindowTaskParameterValueExpression> {
        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);
    }
}

