/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateManagedInstanceRoleRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateManagedInstanceRoleRequest> {
    private final String instanceId;
    private final String iamRole;

    private UpdateManagedInstanceRoleRequest(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.iamRole = builder.iamRole;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String iamRole() {
        return this.iamRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.iamRole() == null ? 0 : this.iamRole().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateManagedInstanceRoleRequest)) {
            return false;
        }
        UpdateManagedInstanceRoleRequest other = (UpdateManagedInstanceRoleRequest)((Object)obj);
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.iamRole() == null ^ this.iamRole() == null) {
            return false;
        }
        return other.iamRole() == null || other.iamRole().equals(this.iamRole());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.iamRole() != null) {
            sb.append("IamRole: ").append(this.iamRole()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String iamRole;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateManagedInstanceRoleRequest model) {
            this.setInstanceId(model.instanceId);
            this.setIamRole(model.iamRole);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getIamRole() {
            return this.iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        public UpdateManagedInstanceRoleRequest build() {
            return new UpdateManagedInstanceRoleRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateManagedInstanceRoleRequest> {
        public Builder instanceId(String var1);

        public Builder iamRole(String var1);
    }
}

