/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.AutomationExecution;

@SdkInternalApi
public class AutomationExecutionMarshaller {
    private static final MarshallingInfo<String> AUTOMATIONEXECUTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutomationExecutionId").build();
    private static final MarshallingInfo<String> DOCUMENTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentName").build();
    private static final MarshallingInfo<String> DOCUMENTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentVersion").build();
    private static final MarshallingInfo<Instant> EXECUTIONSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionStartTime").build();
    private static final MarshallingInfo<Instant> EXECUTIONENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionEndTime").build();
    private static final MarshallingInfo<String> AUTOMATIONEXECUTIONSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutomationExecutionStatus").build();
    private static final MarshallingInfo<List> STEPEXECUTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StepExecutions").build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").build();
    private static final MarshallingInfo<Map> OUTPUTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Outputs").build();
    private static final MarshallingInfo<String> FAILUREMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureMessage").build();
    private static final AutomationExecutionMarshaller instance = new AutomationExecutionMarshaller();

    public static AutomationExecutionMarshaller getInstance() {
        return instance;
    }

    public void marshall(AutomationExecution automationExecution, ProtocolMarshaller protocolMarshaller) {
        if (automationExecution == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)automationExecution.automationExecutionId(), AUTOMATIONEXECUTIONID_BINDING);
            protocolMarshaller.marshall((Object)automationExecution.documentName(), DOCUMENTNAME_BINDING);
            protocolMarshaller.marshall((Object)automationExecution.documentVersion(), DOCUMENTVERSION_BINDING);
            protocolMarshaller.marshall((Object)automationExecution.executionStartTime(), EXECUTIONSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)automationExecution.executionEndTime(), EXECUTIONENDTIME_BINDING);
            protocolMarshaller.marshall((Object)automationExecution.automationExecutionStatus(), AUTOMATIONEXECUTIONSTATUS_BINDING);
            protocolMarshaller.marshall(automationExecution.stepExecutions(), STEPEXECUTIONS_BINDING);
            protocolMarshaller.marshall(automationExecution.parameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall(automationExecution.outputs(), OUTPUTS_BINDING);
            protocolMarshaller.marshall((Object)automationExecution.failureMessage(), FAILUREMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

