/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class AddTagsToResourceRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<AddTagsToResourceRequest.Builder, AddTagsToResourceRequest> {
    private final String resourceType;

    private final String resourceId;

    private final List<Tag> tags;

    private AddTagsToResourceRequest(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Specifies the type of resource you are tagging.
     * </p>
     * 
     * @return Specifies the type of resource you are tagging.
     * @see ResourceTypeForTagging
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The resource ID you want to tag.
     * </p>
     * 
     * @return The resource ID you want to tag.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * One or more tags. The value parameter is required, but if you don't want the tag to have a value, specify the
     * parameter with no value, and we set the value to an empty string.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more tags. The value parameter is required, but if you don't want the tag to have a value, specify
     *         the parameter with no value, and we set the value to an empty string.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((resourceType() == null) ? 0 : resourceType().hashCode());
        hashCode = 31 * hashCode + ((resourceId() == null) ? 0 : resourceId().hashCode());
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddTagsToResourceRequest)) {
            return false;
        }
        AddTagsToResourceRequest other = (AddTagsToResourceRequest) obj;
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.resourceId() == null ^ this.resourceId() == null) {
            return false;
        }
        if (other.resourceId() != null && !other.resourceId().equals(this.resourceId())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (resourceType() != null) {
            sb.append("ResourceType: ").append(resourceType()).append(",");
        }
        if (resourceId() != null) {
            sb.append("ResourceId: ").append(resourceId()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, AddTagsToResourceRequest> {
        /**
         * <p>
         * Specifies the type of resource you are tagging.
         * </p>
         * 
         * @param resourceType
         *        Specifies the type of resource you are tagging.
         * @see ResourceTypeForTagging
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceTypeForTagging
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Specifies the type of resource you are tagging.
         * </p>
         * 
         * @param resourceType
         *        Specifies the type of resource you are tagging.
         * @see ResourceTypeForTagging
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceTypeForTagging
         */
        Builder resourceType(ResourceTypeForTagging resourceType);

        /**
         * <p>
         * The resource ID you want to tag.
         * </p>
         * 
         * @param resourceId
         *        The resource ID you want to tag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * One or more tags. The value parameter is required, but if you don't want the tag to have a value, specify the
         * parameter with no value, and we set the value to an empty string.
         * </p>
         * 
         * @param tags
         *        One or more tags. The value parameter is required, but if you don't want the tag to have a value,
         *        specify the parameter with no value, and we set the value to an empty string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * One or more tags. The value parameter is required, but if you don't want the tag to have a value, specify the
         * parameter with no value, and we set the value to an empty string.
         * </p>
         * 
         * @param tags
         *        One or more tags. The value parameter is required, but if you don't want the tag to have a value,
         *        specify the parameter with no value, and we set the value to an empty string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);
    }

    private static final class BuilderImpl implements Builder {
        private String resourceType;

        private String resourceId;

        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(AddTagsToResourceRequest model) {
            setResourceType(model.resourceType);
            setResourceId(model.resourceId);
            setTags(model.tags);
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceTypeForTagging resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Collection<Tag> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @Override
        public AddTagsToResourceRequest build() {
            return new AddTagsToResourceRequest(this);
        }
    }
}
