/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeregisterPatchBaselineForPatchGroupResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DeregisterPatchBaselineForPatchGroupResponse.Builder, DeregisterPatchBaselineForPatchGroupResponse> {
    private final String baselineId;

    private final String patchGroup;

    private DeregisterPatchBaselineForPatchGroupResponse(BuilderImpl builder) {
        this.baselineId = builder.baselineId;
        this.patchGroup = builder.patchGroup;
    }

    /**
     * <p>
     * The ID of the patch baseline the patch group was deregistered from.
     * </p>
     * 
     * @return The ID of the patch baseline the patch group was deregistered from.
     */
    public String baselineId() {
        return baselineId;
    }

    /**
     * <p>
     * The name of the patch group deregistered from the patch baseline.
     * </p>
     * 
     * @return The name of the patch group deregistered from the patch baseline.
     */
    public String patchGroup() {
        return patchGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((baselineId() == null) ? 0 : baselineId().hashCode());
        hashCode = 31 * hashCode + ((patchGroup() == null) ? 0 : patchGroup().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterPatchBaselineForPatchGroupResponse)) {
            return false;
        }
        DeregisterPatchBaselineForPatchGroupResponse other = (DeregisterPatchBaselineForPatchGroupResponse) obj;
        if (other.baselineId() == null ^ this.baselineId() == null) {
            return false;
        }
        if (other.baselineId() != null && !other.baselineId().equals(this.baselineId())) {
            return false;
        }
        if (other.patchGroup() == null ^ this.patchGroup() == null) {
            return false;
        }
        if (other.patchGroup() != null && !other.patchGroup().equals(this.patchGroup())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (baselineId() != null) {
            sb.append("BaselineId: ").append(baselineId()).append(",");
        }
        if (patchGroup() != null) {
            sb.append("PatchGroup: ").append(patchGroup()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeregisterPatchBaselineForPatchGroupResponse> {
        /**
         * <p>
         * The ID of the patch baseline the patch group was deregistered from.
         * </p>
         * 
         * @param baselineId
         *        The ID of the patch baseline the patch group was deregistered from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineId(String baselineId);

        /**
         * <p>
         * The name of the patch group deregistered from the patch baseline.
         * </p>
         * 
         * @param patchGroup
         *        The name of the patch group deregistered from the patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchGroup(String patchGroup);
    }

    private static final class BuilderImpl implements Builder {
        private String baselineId;

        private String patchGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterPatchBaselineForPatchGroupResponse model) {
            setBaselineId(model.baselineId);
            setPatchGroup(model.patchGroup);
        }

        public final String getBaselineId() {
            return baselineId;
        }

        @Override
        public final Builder baselineId(String baselineId) {
            this.baselineId = baselineId;
            return this;
        }

        public final void setBaselineId(String baselineId) {
            this.baselineId = baselineId;
        }

        public final String getPatchGroup() {
            return patchGroup;
        }

        @Override
        public final Builder patchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
            return this;
        }

        public final void setPatchGroup(String patchGroup) {
            this.patchGroup = patchGroup;
        }

        @Override
        public DeregisterPatchBaselineForPatchGroupResponse build() {
            return new DeregisterPatchBaselineForPatchGroupResponse(this);
        }
    }
}
