/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeMaintenanceWindowTargetsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeMaintenanceWindowTargetsResponse.Builder, DescribeMaintenanceWindowTargetsResponse> {
    private final List<MaintenanceWindowTarget> targets;

    private final String nextToken;

    private DescribeMaintenanceWindowTargetsResponse(BuilderImpl builder) {
        this.targets = builder.targets;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the targets in the Maintenance Window.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the targets in the Maintenance Window.
     */
    public List<MaintenanceWindowTarget> targets() {
        return targets;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((targets() == null) ? 0 : targets().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowTargetsResponse)) {
            return false;
        }
        DescribeMaintenanceWindowTargetsResponse other = (DescribeMaintenanceWindowTargetsResponse) obj;
        if (other.targets() == null ^ this.targets() == null) {
            return false;
        }
        if (other.targets() != null && !other.targets().equals(this.targets())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (targets() != null) {
            sb.append("Targets: ").append(targets()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeMaintenanceWindowTargetsResponse> {
        /**
         * <p>
         * Information about the targets in the Maintenance Window.
         * </p>
         * 
         * @param targets
         *        Information about the targets in the Maintenance Window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<MaintenanceWindowTarget> targets);

        /**
         * <p>
         * Information about the targets in the Maintenance Window.
         * </p>
         * 
         * @param targets
         *        Information about the targets in the Maintenance Window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(MaintenanceWindowTarget... targets);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<MaintenanceWindowTarget> targets;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowTargetsResponse model) {
            setTargets(model.targets);
            setNextToken(model.nextToken);
        }

        public final Collection<MaintenanceWindowTarget> getTargets() {
            return targets;
        }

        @Override
        public final Builder targets(Collection<MaintenanceWindowTarget> targets) {
            this.targets = MaintenanceWindowTargetListCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(MaintenanceWindowTarget... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        public final void setTargets(Collection<MaintenanceWindowTarget> targets) {
            this.targets = MaintenanceWindowTargetListCopier.copy(targets);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeMaintenanceWindowTargetsResponse build() {
            return new DescribeMaintenanceWindowTargetsResponse(this);
        }
    }
}
