/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeMaintenanceWindowTasksResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeMaintenanceWindowTasksResponse.Builder, DescribeMaintenanceWindowTasksResponse> {
    private final List<MaintenanceWindowTask> tasks;

    private final String nextToken;

    private DescribeMaintenanceWindowTasksResponse(BuilderImpl builder) {
        this.tasks = builder.tasks;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the tasks in the Maintenance Window.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the tasks in the Maintenance Window.
     */
    public List<MaintenanceWindowTask> tasks() {
        return tasks;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((tasks() == null) ? 0 : tasks().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowTasksResponse)) {
            return false;
        }
        DescribeMaintenanceWindowTasksResponse other = (DescribeMaintenanceWindowTasksResponse) obj;
        if (other.tasks() == null ^ this.tasks() == null) {
            return false;
        }
        if (other.tasks() != null && !other.tasks().equals(this.tasks())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (tasks() != null) {
            sb.append("Tasks: ").append(tasks()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeMaintenanceWindowTasksResponse> {
        /**
         * <p>
         * Information about the tasks in the Maintenance Window.
         * </p>
         * 
         * @param tasks
         *        Information about the tasks in the Maintenance Window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tasks(Collection<MaintenanceWindowTask> tasks);

        /**
         * <p>
         * Information about the tasks in the Maintenance Window.
         * </p>
         * 
         * @param tasks
         *        Information about the tasks in the Maintenance Window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tasks(MaintenanceWindowTask... tasks);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<MaintenanceWindowTask> tasks;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowTasksResponse model) {
            setTasks(model.tasks);
            setNextToken(model.nextToken);
        }

        public final Collection<MaintenanceWindowTask> getTasks() {
            return tasks;
        }

        @Override
        public final Builder tasks(Collection<MaintenanceWindowTask> tasks) {
            this.tasks = MaintenanceWindowTaskListCopier.copy(tasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(MaintenanceWindowTask... tasks) {
            tasks(Arrays.asList(tasks));
            return this;
        }

        public final void setTasks(Collection<MaintenanceWindowTask> tasks) {
            this.tasks = MaintenanceWindowTaskListCopier.copy(tasks);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeMaintenanceWindowTasksResponse build() {
            return new DescribeMaintenanceWindowTasksResponse(this);
        }
    }
}
