/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetAutomationExecutionResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetAutomationExecutionResponse.Builder, GetAutomationExecutionResponse> {
    private final AutomationExecution automationExecution;

    private GetAutomationExecutionResponse(BuilderImpl builder) {
        this.automationExecution = builder.automationExecution;
    }

    /**
     * <p>
     * Detailed information about the current state of an automation execution.
     * </p>
     * 
     * @return Detailed information about the current state of an automation execution.
     */
    public AutomationExecution automationExecution() {
        return automationExecution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((automationExecution() == null) ? 0 : automationExecution().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAutomationExecutionResponse)) {
            return false;
        }
        GetAutomationExecutionResponse other = (GetAutomationExecutionResponse) obj;
        if (other.automationExecution() == null ^ this.automationExecution() == null) {
            return false;
        }
        if (other.automationExecution() != null && !other.automationExecution().equals(this.automationExecution())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (automationExecution() != null) {
            sb.append("AutomationExecution: ").append(automationExecution()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetAutomationExecutionResponse> {
        /**
         * <p>
         * Detailed information about the current state of an automation execution.
         * </p>
         * 
         * @param automationExecution
         *        Detailed information about the current state of an automation execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automationExecution(AutomationExecution automationExecution);
    }

    private static final class BuilderImpl implements Builder {
        private AutomationExecution automationExecution;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAutomationExecutionResponse model) {
            setAutomationExecution(model.automationExecution);
        }

        public final AutomationExecution getAutomationExecution() {
            return automationExecution;
        }

        @Override
        public final Builder automationExecution(AutomationExecution automationExecution) {
            this.automationExecution = automationExecution;
            return this;
        }

        public final void setAutomationExecution(AutomationExecution automationExecution) {
            this.automationExecution = automationExecution;
        }

        @Override
        public GetAutomationExecutionResponse build() {
            return new GetAutomationExecutionResponse(this);
        }
    }
}
