/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetParametersByPathRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetParametersByPathRequest.Builder, GetParametersByPathRequest> {
    private final String path;

    private final Boolean recursive;

    private final List<ParameterStringFilter> parameterFilters;

    private final Boolean withDecryption;

    private final Integer maxResults;

    private final String nextToken;

    private GetParametersByPathRequest(BuilderImpl builder) {
        this.path = builder.path;
        this.recursive = builder.recursive;
        this.parameterFilters = builder.parameterFilters;
        this.withDecryption = builder.withDecryption;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The hierarchy for the parameter. Hierarchies start with a forward slash (/) and end with the parameter name. A
     * hierarchy can have a maximum of five levels. Examples: /Environment/Test/DBString003
     * </p>
     * <p>
     * /Finance/Prod/IAD/OS/WinServ2016/license15
     * </p>
     * 
     * @return The hierarchy for the parameter. Hierarchies start with a forward slash (/) and end with the parameter
     *         name. A hierarchy can have a maximum of five levels. Examples: /Environment/Test/DBString003</p>
     *         <p>
     *         /Finance/Prod/IAD/OS/WinServ2016/license15
     */
    public String path() {
        return path;
    }

    /**
     * <p>
     * Retrieve all parameters within a hierarchy.
     * </p>
     * 
     * @return Retrieve all parameters within a hierarchy.
     */
    public Boolean recursive() {
        return recursive;
    }

    /**
     * <p>
     * Filters to limit the request results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Filters to limit the request results.
     */
    public List<ParameterStringFilter> parameterFilters() {
        return parameterFilters;
    }

    /**
     * <p>
     * Retrieve all parameters in a hierarchy with their value decrypted.
     * </p>
     * 
     * @return Retrieve all parameters in a hierarchy with their value decrypted.
     */
    public Boolean withDecryption() {
        return withDecryption;
    }

    /**
     * <p>
     * The maximum number of items to return for this call. The call also returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     * 
     * @return The maximum number of items to return for this call. The call also returns a token that you can specify
     *         in a subsequent call to get the next set of results.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token to start the list. Use this token to get the next set of results.
     * </p>
     * 
     * @return A token to start the list. Use this token to get the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((path() == null) ? 0 : path().hashCode());
        hashCode = 31 * hashCode + ((recursive() == null) ? 0 : recursive().hashCode());
        hashCode = 31 * hashCode + ((parameterFilters() == null) ? 0 : parameterFilters().hashCode());
        hashCode = 31 * hashCode + ((withDecryption() == null) ? 0 : withDecryption().hashCode());
        hashCode = 31 * hashCode + ((maxResults() == null) ? 0 : maxResults().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParametersByPathRequest)) {
            return false;
        }
        GetParametersByPathRequest other = (GetParametersByPathRequest) obj;
        if (other.path() == null ^ this.path() == null) {
            return false;
        }
        if (other.path() != null && !other.path().equals(this.path())) {
            return false;
        }
        if (other.recursive() == null ^ this.recursive() == null) {
            return false;
        }
        if (other.recursive() != null && !other.recursive().equals(this.recursive())) {
            return false;
        }
        if (other.parameterFilters() == null ^ this.parameterFilters() == null) {
            return false;
        }
        if (other.parameterFilters() != null && !other.parameterFilters().equals(this.parameterFilters())) {
            return false;
        }
        if (other.withDecryption() == null ^ this.withDecryption() == null) {
            return false;
        }
        if (other.withDecryption() != null && !other.withDecryption().equals(this.withDecryption())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (path() != null) {
            sb.append("Path: ").append(path()).append(",");
        }
        if (recursive() != null) {
            sb.append("Recursive: ").append(recursive()).append(",");
        }
        if (parameterFilters() != null) {
            sb.append("ParameterFilters: ").append(parameterFilters()).append(",");
        }
        if (withDecryption() != null) {
            sb.append("WithDecryption: ").append(withDecryption()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetParametersByPathRequest> {
        /**
         * <p>
         * The hierarchy for the parameter. Hierarchies start with a forward slash (/) and end with the parameter name.
         * A hierarchy can have a maximum of five levels. Examples: /Environment/Test/DBString003
         * </p>
         * <p>
         * /Finance/Prod/IAD/OS/WinServ2016/license15
         * </p>
         * 
         * @param path
         *        The hierarchy for the parameter. Hierarchies start with a forward slash (/) and end with the parameter
         *        name. A hierarchy can have a maximum of five levels. Examples: /Environment/Test/DBString003</p>
         *        <p>
         *        /Finance/Prod/IAD/OS/WinServ2016/license15
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * Retrieve all parameters within a hierarchy.
         * </p>
         * 
         * @param recursive
         *        Retrieve all parameters within a hierarchy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recursive(Boolean recursive);

        /**
         * <p>
         * Filters to limit the request results.
         * </p>
         * 
         * @param parameterFilters
         *        Filters to limit the request results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterFilters(Collection<ParameterStringFilter> parameterFilters);

        /**
         * <p>
         * Filters to limit the request results.
         * </p>
         * 
         * @param parameterFilters
         *        Filters to limit the request results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterFilters(ParameterStringFilter... parameterFilters);

        /**
         * <p>
         * Retrieve all parameters in a hierarchy with their value decrypted.
         * </p>
         * 
         * @param withDecryption
         *        Retrieve all parameters in a hierarchy with their value decrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder withDecryption(Boolean withDecryption);

        /**
         * <p>
         * The maximum number of items to return for this call. The call also returns a token that you can specify in a
         * subsequent call to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this call. The call also returns a token that you can
         *        specify in a subsequent call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token to start the list. Use this token to get the next set of results.
         * </p>
         * 
         * @param nextToken
         *        A token to start the list. Use this token to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private String path;

        private Boolean recursive;

        private List<ParameterStringFilter> parameterFilters;

        private Boolean withDecryption;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParametersByPathRequest model) {
            setPath(model.path);
            setRecursive(model.recursive);
            setParameterFilters(model.parameterFilters);
            setWithDecryption(model.withDecryption);
            setMaxResults(model.maxResults);
            setNextToken(model.nextToken);
        }

        public final String getPath() {
            return path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final Boolean getRecursive() {
            return recursive;
        }

        @Override
        public final Builder recursive(Boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public final void setRecursive(Boolean recursive) {
            this.recursive = recursive;
        }

        public final Collection<ParameterStringFilter> getParameterFilters() {
            return parameterFilters;
        }

        @Override
        public final Builder parameterFilters(Collection<ParameterStringFilter> parameterFilters) {
            this.parameterFilters = ParameterStringFilterListCopier.copy(parameterFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterFilters(ParameterStringFilter... parameterFilters) {
            parameterFilters(Arrays.asList(parameterFilters));
            return this;
        }

        public final void setParameterFilters(Collection<ParameterStringFilter> parameterFilters) {
            this.parameterFilters = ParameterStringFilterListCopier.copy(parameterFilters);
        }

        public final Boolean getWithDecryption() {
            return withDecryption;
        }

        @Override
        public final Builder withDecryption(Boolean withDecryption) {
            this.withDecryption = withDecryption;
            return this;
        }

        public final void setWithDecryption(Boolean withDecryption) {
            this.withDecryption = withDecryption;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetParametersByPathRequest build() {
            return new GetParametersByPathRequest(this);
        }
    }
}
