/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The specified filter option is not valid. Valid options are Equals and BeginsWith. For Path filter, valid options are
 * Recursive and OneLevel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InvalidFilterOptionException extends SSMException implements
        ToCopyableBuilder<InvalidFilterOptionException.Builder, InvalidFilterOptionException> {
    private InvalidFilterOptionException(BuilderImpl builder) {
        super(builder.message);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public interface Builder extends CopyableBuilder<Builder, InvalidFilterOptionException> {
        Builder message(String message);
    }

    private static final class BuilderImpl implements Builder {
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidFilterOptionException model) {
            this.message = model.getMessage();
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public InvalidFilterOptionException build() {
            return new InvalidFilterOptionException(this);
        }
    }
}
