/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListDocumentsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListDocumentsResponse.Builder, ListDocumentsResponse> {
    private final List<DocumentIdentifier> documentIdentifiers;

    private final String nextToken;

    private ListDocumentsResponse(BuilderImpl builder) {
        this.documentIdentifiers = builder.documentIdentifiers;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The names of the SSM documents.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The names of the SSM documents.
     */
    public List<DocumentIdentifier> documentIdentifiers() {
        return documentIdentifiers;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((documentIdentifiers() == null) ? 0 : documentIdentifiers().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDocumentsResponse)) {
            return false;
        }
        ListDocumentsResponse other = (ListDocumentsResponse) obj;
        if (other.documentIdentifiers() == null ^ this.documentIdentifiers() == null) {
            return false;
        }
        if (other.documentIdentifiers() != null && !other.documentIdentifiers().equals(this.documentIdentifiers())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (documentIdentifiers() != null) {
            sb.append("DocumentIdentifiers: ").append(documentIdentifiers()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListDocumentsResponse> {
        /**
         * <p>
         * The names of the SSM documents.
         * </p>
         * 
         * @param documentIdentifiers
         *        The names of the SSM documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentIdentifiers(Collection<DocumentIdentifier> documentIdentifiers);

        /**
         * <p>
         * The names of the SSM documents.
         * </p>
         * 
         * @param documentIdentifiers
         *        The names of the SSM documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentIdentifiers(DocumentIdentifier... documentIdentifiers);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<DocumentIdentifier> documentIdentifiers;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDocumentsResponse model) {
            setDocumentIdentifiers(model.documentIdentifiers);
            setNextToken(model.nextToken);
        }

        public final Collection<DocumentIdentifier> getDocumentIdentifiers() {
            return documentIdentifiers;
        }

        @Override
        public final Builder documentIdentifiers(Collection<DocumentIdentifier> documentIdentifiers) {
            this.documentIdentifiers = DocumentIdentifierListCopier.copy(documentIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentIdentifiers(DocumentIdentifier... documentIdentifiers) {
            documentIdentifiers(Arrays.asList(documentIdentifiers));
            return this;
        }

        public final void setDocumentIdentifiers(Collection<DocumentIdentifier> documentIdentifiers) {
            this.documentIdentifiers = DocumentIdentifierListCopier.copy(documentIdentifiers);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDocumentsResponse build() {
            return new ListDocumentsResponse(this);
        }
    }
}
