/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.MaintenanceWindowExecutionTaskInvocationIdentityMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the information about a task invocation for a particular target as part of a task execution performed as
 * part of a Maintenance Window execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MaintenanceWindowExecutionTaskInvocationIdentity
        implements
        StructuredPojo,
        ToCopyableBuilder<MaintenanceWindowExecutionTaskInvocationIdentity.Builder, MaintenanceWindowExecutionTaskInvocationIdentity> {
    private final String windowExecutionId;

    private final String taskExecutionId;

    private final String invocationId;

    private final String executionId;

    private final String parameters;

    private final String status;

    private final String statusDetails;

    private final Instant startTime;

    private final Instant endTime;

    private final String ownerInformation;

    private final String windowTargetId;

    private MaintenanceWindowExecutionTaskInvocationIdentity(BuilderImpl builder) {
        this.windowExecutionId = builder.windowExecutionId;
        this.taskExecutionId = builder.taskExecutionId;
        this.invocationId = builder.invocationId;
        this.executionId = builder.executionId;
        this.parameters = builder.parameters;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.ownerInformation = builder.ownerInformation;
        this.windowTargetId = builder.windowTargetId;
    }

    /**
     * <p>
     * The ID of the Maintenance Window execution that ran the task.
     * </p>
     * 
     * @return The ID of the Maintenance Window execution that ran the task.
     */
    public String windowExecutionId() {
        return windowExecutionId;
    }

    /**
     * <p>
     * The ID of the specific task execution in the Maintenance Window execution.
     * </p>
     * 
     * @return The ID of the specific task execution in the Maintenance Window execution.
     */
    public String taskExecutionId() {
        return taskExecutionId;
    }

    /**
     * <p>
     * The ID of the task invocation.
     * </p>
     * 
     * @return The ID of the task invocation.
     */
    public String invocationId() {
        return invocationId;
    }

    /**
     * <p>
     * The ID of the action performed in the service that actually handled the task invocation. If the task type is
     * RUN_COMMAND, this value is the command ID.
     * </p>
     * 
     * @return The ID of the action performed in the service that actually handled the task invocation. If the task type
     *         is RUN_COMMAND, this value is the command ID.
     */
    public String executionId() {
        return executionId;
    }

    /**
     * <p>
     * The parameters that were provided for the invocation when it was executed.
     * </p>
     * 
     * @return The parameters that were provided for the invocation when it was executed.
     */
    public String parameters() {
        return parameters;
    }

    /**
     * <p>
     * The status of the task invocation.
     * </p>
     * 
     * @return The status of the task invocation.
     * @see MaintenanceWindowExecutionStatus
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The details explaining the status of the task invocation. Only available for certain Status values.
     * </p>
     * 
     * @return The details explaining the status of the task invocation. Only available for certain Status values.
     */
    public String statusDetails() {
        return statusDetails;
    }

    /**
     * <p>
     * The time the invocation started.
     * </p>
     * 
     * @return The time the invocation started.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time the invocation finished.
     * </p>
     * 
     * @return The time the invocation finished.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * User-provided value that was specified when the target was registered with the Maintenance Window. This was also
     * included in any CloudWatch events raised during the task invocation.
     * </p>
     * 
     * @return User-provided value that was specified when the target was registered with the Maintenance Window. This
     *         was also included in any CloudWatch events raised during the task invocation.
     */
    public String ownerInformation() {
        return ownerInformation;
    }

    /**
     * <p>
     * The ID of the target definition in this Maintenance Window the invocation was performed for.
     * </p>
     * 
     * @return The ID of the target definition in this Maintenance Window the invocation was performed for.
     */
    public String windowTargetId() {
        return windowTargetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((windowExecutionId() == null) ? 0 : windowExecutionId().hashCode());
        hashCode = 31 * hashCode + ((taskExecutionId() == null) ? 0 : taskExecutionId().hashCode());
        hashCode = 31 * hashCode + ((invocationId() == null) ? 0 : invocationId().hashCode());
        hashCode = 31 * hashCode + ((executionId() == null) ? 0 : executionId().hashCode());
        hashCode = 31 * hashCode + ((parameters() == null) ? 0 : parameters().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((statusDetails() == null) ? 0 : statusDetails().hashCode());
        hashCode = 31 * hashCode + ((startTime() == null) ? 0 : startTime().hashCode());
        hashCode = 31 * hashCode + ((endTime() == null) ? 0 : endTime().hashCode());
        hashCode = 31 * hashCode + ((ownerInformation() == null) ? 0 : ownerInformation().hashCode());
        hashCode = 31 * hashCode + ((windowTargetId() == null) ? 0 : windowTargetId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowExecutionTaskInvocationIdentity)) {
            return false;
        }
        MaintenanceWindowExecutionTaskInvocationIdentity other = (MaintenanceWindowExecutionTaskInvocationIdentity) obj;
        if (other.windowExecutionId() == null ^ this.windowExecutionId() == null) {
            return false;
        }
        if (other.windowExecutionId() != null && !other.windowExecutionId().equals(this.windowExecutionId())) {
            return false;
        }
        if (other.taskExecutionId() == null ^ this.taskExecutionId() == null) {
            return false;
        }
        if (other.taskExecutionId() != null && !other.taskExecutionId().equals(this.taskExecutionId())) {
            return false;
        }
        if (other.invocationId() == null ^ this.invocationId() == null) {
            return false;
        }
        if (other.invocationId() != null && !other.invocationId().equals(this.invocationId())) {
            return false;
        }
        if (other.executionId() == null ^ this.executionId() == null) {
            return false;
        }
        if (other.executionId() != null && !other.executionId().equals(this.executionId())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.statusDetails() == null ^ this.statusDetails() == null) {
            return false;
        }
        if (other.statusDetails() != null && !other.statusDetails().equals(this.statusDetails())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.ownerInformation() == null ^ this.ownerInformation() == null) {
            return false;
        }
        if (other.ownerInformation() != null && !other.ownerInformation().equals(this.ownerInformation())) {
            return false;
        }
        if (other.windowTargetId() == null ^ this.windowTargetId() == null) {
            return false;
        }
        if (other.windowTargetId() != null && !other.windowTargetId().equals(this.windowTargetId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (windowExecutionId() != null) {
            sb.append("WindowExecutionId: ").append(windowExecutionId()).append(",");
        }
        if (taskExecutionId() != null) {
            sb.append("TaskExecutionId: ").append(taskExecutionId()).append(",");
        }
        if (invocationId() != null) {
            sb.append("InvocationId: ").append(invocationId()).append(",");
        }
        if (executionId() != null) {
            sb.append("ExecutionId: ").append(executionId()).append(",");
        }
        if (parameters() != null) {
            sb.append("Parameters: ").append(parameters()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (statusDetails() != null) {
            sb.append("StatusDetails: ").append(statusDetails()).append(",");
        }
        if (startTime() != null) {
            sb.append("StartTime: ").append(startTime()).append(",");
        }
        if (endTime() != null) {
            sb.append("EndTime: ").append(endTime()).append(",");
        }
        if (ownerInformation() != null) {
            sb.append("OwnerInformation: ").append(ownerInformation()).append(",");
        }
        if (windowTargetId() != null) {
            sb.append("WindowTargetId: ").append(windowTargetId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MaintenanceWindowExecutionTaskInvocationIdentityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, MaintenanceWindowExecutionTaskInvocationIdentity> {
        /**
         * <p>
         * The ID of the Maintenance Window execution that ran the task.
         * </p>
         * 
         * @param windowExecutionId
         *        The ID of the Maintenance Window execution that ran the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowExecutionId(String windowExecutionId);

        /**
         * <p>
         * The ID of the specific task execution in the Maintenance Window execution.
         * </p>
         * 
         * @param taskExecutionId
         *        The ID of the specific task execution in the Maintenance Window execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskExecutionId(String taskExecutionId);

        /**
         * <p>
         * The ID of the task invocation.
         * </p>
         * 
         * @param invocationId
         *        The ID of the task invocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationId(String invocationId);

        /**
         * <p>
         * The ID of the action performed in the service that actually handled the task invocation. If the task type is
         * RUN_COMMAND, this value is the command ID.
         * </p>
         * 
         * @param executionId
         *        The ID of the action performed in the service that actually handled the task invocation. If the task
         *        type is RUN_COMMAND, this value is the command ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionId(String executionId);

        /**
         * <p>
         * The parameters that were provided for the invocation when it was executed.
         * </p>
         * 
         * @param parameters
         *        The parameters that were provided for the invocation when it was executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(String parameters);

        /**
         * <p>
         * The status of the task invocation.
         * </p>
         * 
         * @param status
         *        The status of the task invocation.
         * @see MaintenanceWindowExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceWindowExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the task invocation.
         * </p>
         * 
         * @param status
         *        The status of the task invocation.
         * @see MaintenanceWindowExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceWindowExecutionStatus
         */
        Builder status(MaintenanceWindowExecutionStatus status);

        /**
         * <p>
         * The details explaining the status of the task invocation. Only available for certain Status values.
         * </p>
         * 
         * @param statusDetails
         *        The details explaining the status of the task invocation. Only available for certain Status values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDetails(String statusDetails);

        /**
         * <p>
         * The time the invocation started.
         * </p>
         * 
         * @param startTime
         *        The time the invocation started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time the invocation finished.
         * </p>
         * 
         * @param endTime
         *        The time the invocation finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * User-provided value that was specified when the target was registered with the Maintenance Window. This was
         * also included in any CloudWatch events raised during the task invocation.
         * </p>
         * 
         * @param ownerInformation
         *        User-provided value that was specified when the target was registered with the Maintenance Window.
         *        This was also included in any CloudWatch events raised during the task invocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerInformation(String ownerInformation);

        /**
         * <p>
         * The ID of the target definition in this Maintenance Window the invocation was performed for.
         * </p>
         * 
         * @param windowTargetId
         *        The ID of the target definition in this Maintenance Window the invocation was performed for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowTargetId(String windowTargetId);
    }

    private static final class BuilderImpl implements Builder {
        private String windowExecutionId;

        private String taskExecutionId;

        private String invocationId;

        private String executionId;

        private String parameters;

        private String status;

        private String statusDetails;

        private Instant startTime;

        private Instant endTime;

        private String ownerInformation;

        private String windowTargetId;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowExecutionTaskInvocationIdentity model) {
            setWindowExecutionId(model.windowExecutionId);
            setTaskExecutionId(model.taskExecutionId);
            setInvocationId(model.invocationId);
            setExecutionId(model.executionId);
            setParameters(model.parameters);
            setStatus(model.status);
            setStatusDetails(model.statusDetails);
            setStartTime(model.startTime);
            setEndTime(model.endTime);
            setOwnerInformation(model.ownerInformation);
            setWindowTargetId(model.windowTargetId);
        }

        public final String getWindowExecutionId() {
            return windowExecutionId;
        }

        @Override
        public final Builder windowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
            return this;
        }

        public final void setWindowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
        }

        public final String getTaskExecutionId() {
            return taskExecutionId;
        }

        @Override
        public final Builder taskExecutionId(String taskExecutionId) {
            this.taskExecutionId = taskExecutionId;
            return this;
        }

        public final void setTaskExecutionId(String taskExecutionId) {
            this.taskExecutionId = taskExecutionId;
        }

        public final String getInvocationId() {
            return invocationId;
        }

        @Override
        public final Builder invocationId(String invocationId) {
            this.invocationId = invocationId;
            return this;
        }

        public final void setInvocationId(String invocationId) {
            this.invocationId = invocationId;
        }

        public final String getExecutionId() {
            return executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        public final String getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(String parameters) {
            this.parameters = parameters;
            return this;
        }

        public final void setParameters(String parameters) {
            this.parameters = parameters;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MaintenanceWindowExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDetails() {
            return statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getOwnerInformation() {
            return ownerInformation;
        }

        @Override
        public final Builder ownerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
            return this;
        }

        public final void setOwnerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
        }

        public final String getWindowTargetId() {
            return windowTargetId;
        }

        @Override
        public final Builder windowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
            return this;
        }

        public final void setWindowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
        }

        @Override
        public MaintenanceWindowExecutionTaskInvocationIdentity build() {
            return new MaintenanceWindowExecutionTaskInvocationIdentity(this);
        }
    }
}
