/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.PatchStatusMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the approval status of a patch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PatchStatus implements StructuredPojo, ToCopyableBuilder<PatchStatus.Builder, PatchStatus> {
    private final String deploymentStatus;

    private final Instant approvalDate;

    private PatchStatus(BuilderImpl builder) {
        this.deploymentStatus = builder.deploymentStatus;
        this.approvalDate = builder.approvalDate;
    }

    /**
     * <p>
     * The approval status of a patch (APPROVED, PENDING_APPROVAL, EXPLICIT_APPROVED, EXPLICIT_REJECTED).
     * </p>
     * 
     * @return The approval status of a patch (APPROVED, PENDING_APPROVAL, EXPLICIT_APPROVED, EXPLICIT_REJECTED).
     * @see PatchDeploymentStatus
     */
    public String deploymentStatus() {
        return deploymentStatus;
    }

    /**
     * <p>
     * The date the patch was approved (or will be approved if the status is PENDING_APPROVAL).
     * </p>
     * 
     * @return The date the patch was approved (or will be approved if the status is PENDING_APPROVAL).
     */
    public Instant approvalDate() {
        return approvalDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deploymentStatus() == null) ? 0 : deploymentStatus().hashCode());
        hashCode = 31 * hashCode + ((approvalDate() == null) ? 0 : approvalDate().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchStatus)) {
            return false;
        }
        PatchStatus other = (PatchStatus) obj;
        if (other.deploymentStatus() == null ^ this.deploymentStatus() == null) {
            return false;
        }
        if (other.deploymentStatus() != null && !other.deploymentStatus().equals(this.deploymentStatus())) {
            return false;
        }
        if (other.approvalDate() == null ^ this.approvalDate() == null) {
            return false;
        }
        if (other.approvalDate() != null && !other.approvalDate().equals(this.approvalDate())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deploymentStatus() != null) {
            sb.append("DeploymentStatus: ").append(deploymentStatus()).append(",");
        }
        if (approvalDate() != null) {
            sb.append("ApprovalDate: ").append(approvalDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PatchStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, PatchStatus> {
        /**
         * <p>
         * The approval status of a patch (APPROVED, PENDING_APPROVAL, EXPLICIT_APPROVED, EXPLICIT_REJECTED).
         * </p>
         * 
         * @param deploymentStatus
         *        The approval status of a patch (APPROVED, PENDING_APPROVAL, EXPLICIT_APPROVED, EXPLICIT_REJECTED).
         * @see PatchDeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PatchDeploymentStatus
         */
        Builder deploymentStatus(String deploymentStatus);

        /**
         * <p>
         * The approval status of a patch (APPROVED, PENDING_APPROVAL, EXPLICIT_APPROVED, EXPLICIT_REJECTED).
         * </p>
         * 
         * @param deploymentStatus
         *        The approval status of a patch (APPROVED, PENDING_APPROVAL, EXPLICIT_APPROVED, EXPLICIT_REJECTED).
         * @see PatchDeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PatchDeploymentStatus
         */
        Builder deploymentStatus(PatchDeploymentStatus deploymentStatus);

        /**
         * <p>
         * The date the patch was approved (or will be approved if the status is PENDING_APPROVAL).
         * </p>
         * 
         * @param approvalDate
         *        The date the patch was approved (or will be approved if the status is PENDING_APPROVAL).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalDate(Instant approvalDate);
    }

    private static final class BuilderImpl implements Builder {
        private String deploymentStatus;

        private Instant approvalDate;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchStatus model) {
            setDeploymentStatus(model.deploymentStatus);
            setApprovalDate(model.approvalDate);
        }

        public final String getDeploymentStatus() {
            return deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @Override
        public final Builder deploymentStatus(PatchDeploymentStatus deploymentStatus) {
            this.deploymentStatus(deploymentStatus.toString());
            return this;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        public final Instant getApprovalDate() {
            return approvalDate;
        }

        @Override
        public final Builder approvalDate(Instant approvalDate) {
            this.approvalDate = approvalDate;
            return this;
        }

        public final void setApprovalDate(Instant approvalDate) {
            this.approvalDate = approvalDate;
        }

        @Override
        public PatchStatus build() {
            return new PatchStatus(this);
        }
    }
}
