/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RegisterTaskWithMaintenanceWindowResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<RegisterTaskWithMaintenanceWindowResponse.Builder, RegisterTaskWithMaintenanceWindowResponse> {
    private final String windowTaskId;

    private RegisterTaskWithMaintenanceWindowResponse(BuilderImpl builder) {
        this.windowTaskId = builder.windowTaskId;
    }

    /**
     * <p>
     * The id of the task in the Maintenance Window.
     * </p>
     * 
     * @return The id of the task in the Maintenance Window.
     */
    public String windowTaskId() {
        return windowTaskId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((windowTaskId() == null) ? 0 : windowTaskId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTaskWithMaintenanceWindowResponse)) {
            return false;
        }
        RegisterTaskWithMaintenanceWindowResponse other = (RegisterTaskWithMaintenanceWindowResponse) obj;
        if (other.windowTaskId() == null ^ this.windowTaskId() == null) {
            return false;
        }
        if (other.windowTaskId() != null && !other.windowTaskId().equals(this.windowTaskId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (windowTaskId() != null) {
            sb.append("WindowTaskId: ").append(windowTaskId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, RegisterTaskWithMaintenanceWindowResponse> {
        /**
         * <p>
         * The id of the task in the Maintenance Window.
         * </p>
         * 
         * @param windowTaskId
         *        The id of the task in the Maintenance Window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowTaskId(String windowTaskId);
    }

    private static final class BuilderImpl implements Builder {
        private String windowTaskId;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterTaskWithMaintenanceWindowResponse model) {
            setWindowTaskId(model.windowTaskId);
        }

        public final String getWindowTaskId() {
            return windowTaskId;
        }

        @Override
        public final Builder windowTaskId(String windowTaskId) {
            this.windowTaskId = windowTaskId;
            return this;
        }

        public final void setWindowTaskId(String windowTaskId) {
            this.windowTaskId = windowTaskId;
        }

        @Override
        public RegisterTaskWithMaintenanceWindowResponse build() {
            return new RegisterTaskWithMaintenanceWindowResponse(this);
        }
    }
}
