/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class RemoveTagsFromResourceRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<RemoveTagsFromResourceRequest.Builder, RemoveTagsFromResourceRequest> {
    private final String resourceType;

    private final String resourceId;

    private final List<String> tagKeys;

    private RemoveTagsFromResourceRequest(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.tagKeys = builder.tagKeys;
    }

    /**
     * <p>
     * The type of resource of which you want to remove a tag.
     * </p>
     * 
     * @return The type of resource of which you want to remove a tag.
     * @see ResourceTypeForTagging
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The resource ID for which you want to remove tags.
     * </p>
     * 
     * @return The resource ID for which you want to remove tags.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * Tag keys that you want to remove from the specified resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Tag keys that you want to remove from the specified resource.
     */
    public List<String> tagKeys() {
        return tagKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((resourceType() == null) ? 0 : resourceType().hashCode());
        hashCode = 31 * hashCode + ((resourceId() == null) ? 0 : resourceId().hashCode());
        hashCode = 31 * hashCode + ((tagKeys() == null) ? 0 : tagKeys().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveTagsFromResourceRequest)) {
            return false;
        }
        RemoveTagsFromResourceRequest other = (RemoveTagsFromResourceRequest) obj;
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.resourceId() == null ^ this.resourceId() == null) {
            return false;
        }
        if (other.resourceId() != null && !other.resourceId().equals(this.resourceId())) {
            return false;
        }
        if (other.tagKeys() == null ^ this.tagKeys() == null) {
            return false;
        }
        if (other.tagKeys() != null && !other.tagKeys().equals(this.tagKeys())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (resourceType() != null) {
            sb.append("ResourceType: ").append(resourceType()).append(",");
        }
        if (resourceId() != null) {
            sb.append("ResourceId: ").append(resourceId()).append(",");
        }
        if (tagKeys() != null) {
            sb.append("TagKeys: ").append(tagKeys()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, RemoveTagsFromResourceRequest> {
        /**
         * <p>
         * The type of resource of which you want to remove a tag.
         * </p>
         * 
         * @param resourceType
         *        The type of resource of which you want to remove a tag.
         * @see ResourceTypeForTagging
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceTypeForTagging
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resource of which you want to remove a tag.
         * </p>
         * 
         * @param resourceType
         *        The type of resource of which you want to remove a tag.
         * @see ResourceTypeForTagging
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceTypeForTagging
         */
        Builder resourceType(ResourceTypeForTagging resourceType);

        /**
         * <p>
         * The resource ID for which you want to remove tags.
         * </p>
         * 
         * @param resourceId
         *        The resource ID for which you want to remove tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * Tag keys that you want to remove from the specified resource.
         * </p>
         * 
         * @param tagKeys
         *        Tag keys that you want to remove from the specified resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeys(Collection<String> tagKeys);

        /**
         * <p>
         * Tag keys that you want to remove from the specified resource.
         * </p>
         * 
         * @param tagKeys
         *        Tag keys that you want to remove from the specified resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeys(String... tagKeys);
    }

    private static final class BuilderImpl implements Builder {
        private String resourceType;

        private String resourceId;

        private List<String> tagKeys;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveTagsFromResourceRequest model) {
            setResourceType(model.resourceType);
            setResourceId(model.resourceId);
            setTagKeys(model.tagKeys);
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceTypeForTagging resourceType) {
            this.resourceType(resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final Collection<String> getTagKeys() {
            return tagKeys;
        }

        @Override
        public final Builder tagKeys(Collection<String> tagKeys) {
            this.tagKeys = KeyListCopier.copy(tagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeys(String... tagKeys) {
            tagKeys(Arrays.asList(tagKeys));
            return this;
        }

        public final void setTagKeys(Collection<String> tagKeys) {
            this.tagKeys = KeyListCopier.copy(tagKeys);
        }

        @Override
        public RemoveTagsFromResourceRequest build() {
            return new RemoveTagsFromResourceRequest(this);
        }
    }
}
