/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionTaskIdentity;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionTaskIdentityListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeMaintenanceWindowExecutionTasksResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeMaintenanceWindowExecutionTasksResponse> {
    private final List<MaintenanceWindowExecutionTaskIdentity> windowExecutionTaskIdentities;
    private final String nextToken;

    private DescribeMaintenanceWindowExecutionTasksResponse(BuilderImpl builder) {
        this.windowExecutionTaskIdentities = builder.windowExecutionTaskIdentities;
        this.nextToken = builder.nextToken;
    }

    public List<MaintenanceWindowExecutionTaskIdentity> windowExecutionTaskIdentities() {
        return this.windowExecutionTaskIdentities;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.windowExecutionTaskIdentities() == null ? 0 : this.windowExecutionTaskIdentities().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowExecutionTasksResponse)) {
            return false;
        }
        DescribeMaintenanceWindowExecutionTasksResponse other = (DescribeMaintenanceWindowExecutionTasksResponse)((Object)obj);
        if (other.windowExecutionTaskIdentities() == null ^ this.windowExecutionTaskIdentities() == null) {
            return false;
        }
        if (other.windowExecutionTaskIdentities() != null && !other.windowExecutionTaskIdentities().equals(this.windowExecutionTaskIdentities())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.windowExecutionTaskIdentities() != null) {
            sb.append("WindowExecutionTaskIdentities: ").append(this.windowExecutionTaskIdentities()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<MaintenanceWindowExecutionTaskIdentity> windowExecutionTaskIdentities;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowExecutionTasksResponse model) {
            this.setWindowExecutionTaskIdentities(model.windowExecutionTaskIdentities);
            this.setNextToken(model.nextToken);
        }

        public final Collection<MaintenanceWindowExecutionTaskIdentity> getWindowExecutionTaskIdentities() {
            return this.windowExecutionTaskIdentities;
        }

        @Override
        public final Builder windowExecutionTaskIdentities(Collection<MaintenanceWindowExecutionTaskIdentity> windowExecutionTaskIdentities) {
            this.windowExecutionTaskIdentities = MaintenanceWindowExecutionTaskIdentityListCopier.copy(windowExecutionTaskIdentities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder windowExecutionTaskIdentities(MaintenanceWindowExecutionTaskIdentity ... windowExecutionTaskIdentities) {
            this.windowExecutionTaskIdentities(Arrays.asList(windowExecutionTaskIdentities));
            return this;
        }

        public final void setWindowExecutionTaskIdentities(Collection<MaintenanceWindowExecutionTaskIdentity> windowExecutionTaskIdentities) {
            this.windowExecutionTaskIdentities = MaintenanceWindowExecutionTaskIdentityListCopier.copy(windowExecutionTaskIdentities);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeMaintenanceWindowExecutionTasksResponse build() {
            return new DescribeMaintenanceWindowExecutionTasksResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeMaintenanceWindowExecutionTasksResponse> {
        public Builder windowExecutionTaskIdentities(Collection<MaintenanceWindowExecutionTaskIdentity> var1);

        public Builder windowExecutionTaskIdentities(MaintenanceWindowExecutionTaskIdentity ... var1);

        public Builder nextToken(String var1);
    }
}

