/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandler;
import software.amazon.awssdk.client.SdkClientHandler;
import software.amazon.awssdk.config.ClientConfiguration;
import software.amazon.awssdk.config.SyncClientConfiguration;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.services.ssm.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.ssm.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.ssm.model.AlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.AssociatedInstancesException;
import software.amazon.awssdk.services.ssm.model.AssociationAlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.AssociationDoesNotExistException;
import software.amazon.awssdk.services.ssm.model.AssociationLimitExceededException;
import software.amazon.awssdk.services.ssm.model.AutomationDefinitionNotFoundException;
import software.amazon.awssdk.services.ssm.model.AutomationDefinitionVersionNotFoundException;
import software.amazon.awssdk.services.ssm.model.AutomationExecutionLimitExceededException;
import software.amazon.awssdk.services.ssm.model.AutomationExecutionNotFoundException;
import software.amazon.awssdk.services.ssm.model.CancelCommandRequest;
import software.amazon.awssdk.services.ssm.model.CancelCommandResponse;
import software.amazon.awssdk.services.ssm.model.CreateActivationRequest;
import software.amazon.awssdk.services.ssm.model.CreateActivationResponse;
import software.amazon.awssdk.services.ssm.model.CreateAssociationBatchRequest;
import software.amazon.awssdk.services.ssm.model.CreateAssociationBatchResponse;
import software.amazon.awssdk.services.ssm.model.CreateAssociationRequest;
import software.amazon.awssdk.services.ssm.model.CreateAssociationResponse;
import software.amazon.awssdk.services.ssm.model.CreateDocumentRequest;
import software.amazon.awssdk.services.ssm.model.CreateDocumentResponse;
import software.amazon.awssdk.services.ssm.model.CreateMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.CreateMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.CreatePatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.CreatePatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.CustomSchemaCountLimitExceededException;
import software.amazon.awssdk.services.ssm.model.DeleteActivationRequest;
import software.amazon.awssdk.services.ssm.model.DeleteActivationResponse;
import software.amazon.awssdk.services.ssm.model.DeleteAssociationRequest;
import software.amazon.awssdk.services.ssm.model.DeleteAssociationResponse;
import software.amazon.awssdk.services.ssm.model.DeleteDocumentRequest;
import software.amazon.awssdk.services.ssm.model.DeleteDocumentResponse;
import software.amazon.awssdk.services.ssm.model.DeleteMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.DeleteMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.DeleteParameterRequest;
import software.amazon.awssdk.services.ssm.model.DeleteParameterResponse;
import software.amazon.awssdk.services.ssm.model.DeleteParametersRequest;
import software.amazon.awssdk.services.ssm.model.DeleteParametersResponse;
import software.amazon.awssdk.services.ssm.model.DeletePatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.DeletePatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.DeregisterManagedInstanceRequest;
import software.amazon.awssdk.services.ssm.model.DeregisterManagedInstanceResponse;
import software.amazon.awssdk.services.ssm.model.DeregisterPatchBaselineForPatchGroupRequest;
import software.amazon.awssdk.services.ssm.model.DeregisterPatchBaselineForPatchGroupResponse;
import software.amazon.awssdk.services.ssm.model.DeregisterTargetFromMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.DeregisterTargetFromMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.DeregisterTaskFromMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.DeregisterTaskFromMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.DescribeActivationsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesResponse;
import software.amazon.awssdk.services.ssm.model.DescribeDocumentPermissionRequest;
import software.amazon.awssdk.services.ssm.model.DescribeDocumentPermissionResponse;
import software.amazon.awssdk.services.ssm.model.DescribeDocumentRequest;
import software.amazon.awssdk.services.ssm.model.DescribeDocumentResponse;
import software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeParametersRequest;
import software.amazon.awssdk.services.ssm.model.DescribeParametersResponse;
import software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesResponse;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupStateRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupStateResponse;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupsResponse;
import software.amazon.awssdk.services.ssm.model.DocumentAlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.DocumentLimitExceededException;
import software.amazon.awssdk.services.ssm.model.DocumentPermissionLimitException;
import software.amazon.awssdk.services.ssm.model.DocumentVersionLimitExceededException;
import software.amazon.awssdk.services.ssm.model.DoesNotExistException;
import software.amazon.awssdk.services.ssm.model.DuplicateDocumentContentException;
import software.amazon.awssdk.services.ssm.model.DuplicateInstanceIdException;
import software.amazon.awssdk.services.ssm.model.GetAutomationExecutionRequest;
import software.amazon.awssdk.services.ssm.model.GetAutomationExecutionResponse;
import software.amazon.awssdk.services.ssm.model.GetCommandInvocationRequest;
import software.amazon.awssdk.services.ssm.model.GetCommandInvocationResponse;
import software.amazon.awssdk.services.ssm.model.GetDefaultPatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.GetDefaultPatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.GetDeployablePatchSnapshotForInstanceRequest;
import software.amazon.awssdk.services.ssm.model.GetDeployablePatchSnapshotForInstanceResponse;
import software.amazon.awssdk.services.ssm.model.GetDocumentRequest;
import software.amazon.awssdk.services.ssm.model.GetDocumentResponse;
import software.amazon.awssdk.services.ssm.model.GetInventoryRequest;
import software.amazon.awssdk.services.ssm.model.GetInventoryResponse;
import software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest;
import software.amazon.awssdk.services.ssm.model.GetInventorySchemaResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest;
import software.amazon.awssdk.services.ssm.model.GetParameterHistoryResponse;
import software.amazon.awssdk.services.ssm.model.GetParameterRequest;
import software.amazon.awssdk.services.ssm.model.GetParameterResponse;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse;
import software.amazon.awssdk.services.ssm.model.GetParametersRequest;
import software.amazon.awssdk.services.ssm.model.GetParametersResponse;
import software.amazon.awssdk.services.ssm.model.GetPatchBaselineForPatchGroupRequest;
import software.amazon.awssdk.services.ssm.model.GetPatchBaselineForPatchGroupResponse;
import software.amazon.awssdk.services.ssm.model.GetPatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.GetPatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.HierarchyLevelLimitExceededException;
import software.amazon.awssdk.services.ssm.model.HierarchyTypeMismatchException;
import software.amazon.awssdk.services.ssm.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.ssm.model.InternalServerErrorException;
import software.amazon.awssdk.services.ssm.model.InvalidActivationException;
import software.amazon.awssdk.services.ssm.model.InvalidActivationIdException;
import software.amazon.awssdk.services.ssm.model.InvalidAllowedPatternException;
import software.amazon.awssdk.services.ssm.model.InvalidAutomationExecutionParametersException;
import software.amazon.awssdk.services.ssm.model.InvalidCommandIdException;
import software.amazon.awssdk.services.ssm.model.InvalidDocumentContentException;
import software.amazon.awssdk.services.ssm.model.InvalidDocumentException;
import software.amazon.awssdk.services.ssm.model.InvalidDocumentOperationException;
import software.amazon.awssdk.services.ssm.model.InvalidDocumentSchemaVersionException;
import software.amazon.awssdk.services.ssm.model.InvalidDocumentVersionException;
import software.amazon.awssdk.services.ssm.model.InvalidFilterException;
import software.amazon.awssdk.services.ssm.model.InvalidFilterKeyException;
import software.amazon.awssdk.services.ssm.model.InvalidFilterOptionException;
import software.amazon.awssdk.services.ssm.model.InvalidFilterValueException;
import software.amazon.awssdk.services.ssm.model.InvalidInstanceIdException;
import software.amazon.awssdk.services.ssm.model.InvalidInstanceInformationFilterValueException;
import software.amazon.awssdk.services.ssm.model.InvalidItemContentException;
import software.amazon.awssdk.services.ssm.model.InvalidKeyIdException;
import software.amazon.awssdk.services.ssm.model.InvalidNextTokenException;
import software.amazon.awssdk.services.ssm.model.InvalidNotificationConfigException;
import software.amazon.awssdk.services.ssm.model.InvalidOutputFolderException;
import software.amazon.awssdk.services.ssm.model.InvalidOutputLocationException;
import software.amazon.awssdk.services.ssm.model.InvalidParametersException;
import software.amazon.awssdk.services.ssm.model.InvalidPermissionTypeException;
import software.amazon.awssdk.services.ssm.model.InvalidPluginNameException;
import software.amazon.awssdk.services.ssm.model.InvalidResourceIdException;
import software.amazon.awssdk.services.ssm.model.InvalidResourceTypeException;
import software.amazon.awssdk.services.ssm.model.InvalidResultAttributeException;
import software.amazon.awssdk.services.ssm.model.InvalidRoleException;
import software.amazon.awssdk.services.ssm.model.InvalidScheduleException;
import software.amazon.awssdk.services.ssm.model.InvalidTargetException;
import software.amazon.awssdk.services.ssm.model.InvalidTypeNameException;
import software.amazon.awssdk.services.ssm.model.InvalidUpdateException;
import software.amazon.awssdk.services.ssm.model.InvocationDoesNotExistException;
import software.amazon.awssdk.services.ssm.model.ItemContentMismatchException;
import software.amazon.awssdk.services.ssm.model.ItemSizeLimitExceededException;
import software.amazon.awssdk.services.ssm.model.ListAssociationsRequest;
import software.amazon.awssdk.services.ssm.model.ListAssociationsResponse;
import software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest;
import software.amazon.awssdk.services.ssm.model.ListCommandInvocationsResponse;
import software.amazon.awssdk.services.ssm.model.ListCommandsRequest;
import software.amazon.awssdk.services.ssm.model.ListCommandsResponse;
import software.amazon.awssdk.services.ssm.model.ListDocumentVersionsRequest;
import software.amazon.awssdk.services.ssm.model.ListDocumentVersionsResponse;
import software.amazon.awssdk.services.ssm.model.ListDocumentsRequest;
import software.amazon.awssdk.services.ssm.model.ListDocumentsResponse;
import software.amazon.awssdk.services.ssm.model.ListInventoryEntriesRequest;
import software.amazon.awssdk.services.ssm.model.ListInventoryEntriesResponse;
import software.amazon.awssdk.services.ssm.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ssm.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ssm.model.MaxDocumentSizeExceededException;
import software.amazon.awssdk.services.ssm.model.ModifyDocumentPermissionRequest;
import software.amazon.awssdk.services.ssm.model.ModifyDocumentPermissionResponse;
import software.amazon.awssdk.services.ssm.model.ParameterAlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.ParameterLimitExceededException;
import software.amazon.awssdk.services.ssm.model.ParameterNotFoundException;
import software.amazon.awssdk.services.ssm.model.ParameterPatternMismatchException;
import software.amazon.awssdk.services.ssm.model.PutInventoryRequest;
import software.amazon.awssdk.services.ssm.model.PutInventoryResponse;
import software.amazon.awssdk.services.ssm.model.PutParameterRequest;
import software.amazon.awssdk.services.ssm.model.PutParameterResponse;
import software.amazon.awssdk.services.ssm.model.RegisterDefaultPatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.RegisterDefaultPatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.RegisterPatchBaselineForPatchGroupRequest;
import software.amazon.awssdk.services.ssm.model.RegisterPatchBaselineForPatchGroupResponse;
import software.amazon.awssdk.services.ssm.model.RegisterTargetWithMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.RegisterTargetWithMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.RegisterTaskWithMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.RegisterTaskWithMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.ssm.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.ssm.model.ResourceInUseException;
import software.amazon.awssdk.services.ssm.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.ssm.model.SSMException;
import software.amazon.awssdk.services.ssm.model.SendCommandRequest;
import software.amazon.awssdk.services.ssm.model.SendCommandResponse;
import software.amazon.awssdk.services.ssm.model.StartAutomationExecutionRequest;
import software.amazon.awssdk.services.ssm.model.StartAutomationExecutionResponse;
import software.amazon.awssdk.services.ssm.model.StatusUnchangedException;
import software.amazon.awssdk.services.ssm.model.StopAutomationExecutionRequest;
import software.amazon.awssdk.services.ssm.model.StopAutomationExecutionResponse;
import software.amazon.awssdk.services.ssm.model.TooManyTagsErrorException;
import software.amazon.awssdk.services.ssm.model.TooManyUpdatesException;
import software.amazon.awssdk.services.ssm.model.TotalSizeLimitExceededException;
import software.amazon.awssdk.services.ssm.model.UnsupportedInventorySchemaVersionException;
import software.amazon.awssdk.services.ssm.model.UnsupportedParameterTypeException;
import software.amazon.awssdk.services.ssm.model.UnsupportedPlatformTypeException;
import software.amazon.awssdk.services.ssm.model.UpdateAssociationRequest;
import software.amazon.awssdk.services.ssm.model.UpdateAssociationResponse;
import software.amazon.awssdk.services.ssm.model.UpdateAssociationStatusRequest;
import software.amazon.awssdk.services.ssm.model.UpdateAssociationStatusResponse;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentDefaultVersionRequest;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentDefaultVersionResponse;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentRequest;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentResponse;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.UpdateManagedInstanceRoleRequest;
import software.amazon.awssdk.services.ssm.model.UpdateManagedInstanceRoleResponse;
import software.amazon.awssdk.services.ssm.model.UpdatePatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.UpdatePatchBaselineResponse;
import software.amazon.awssdk.services.ssm.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.AddTagsToResourceResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.CancelCommandRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CancelCommandResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateActivationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateActivationResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateAssociationBatchRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateAssociationBatchResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateAssociationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateAssociationResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateDocumentRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateDocumentResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateMaintenanceWindowResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.CreatePatchBaselineRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreatePatchBaselineResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteActivationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteActivationResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteAssociationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteAssociationResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteDocumentRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteDocumentResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteMaintenanceWindowResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteParameterRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteParameterResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteParametersRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteParametersResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DeletePatchBaselineRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeletePatchBaselineResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DeregisterManagedInstanceRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeregisterManagedInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DeregisterPatchBaselineForPatchGroupRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeregisterPatchBaselineForPatchGroupResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DeregisterTargetFromMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeregisterTargetFromMaintenanceWindowResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DeregisterTaskFromMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeregisterTaskFromMaintenanceWindowResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeActivationsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeActivationsResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeAssociationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeAssociationResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeAutomationExecutionsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeAutomationExecutionsResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeAvailablePatchesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeAvailablePatchesResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeDocumentPermissionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeDocumentPermissionResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeDocumentRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeDocumentResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeEffectiveInstanceAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeEffectiveInstanceAssociationsResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeEffectivePatchesForPatchBaselineRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeEffectivePatchesForPatchBaselineResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeInstanceAssociationsStatusRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeInstanceAssociationsStatusResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeInstanceInformationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeInstanceInformationResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeInstancePatchStatesForPatchGroupRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeInstancePatchStatesForPatchGroupResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeInstancePatchStatesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeInstancePatchStatesResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeInstancePatchesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeInstancePatchesResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowExecutionTaskInvocationsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowExecutionTaskInvocationsResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowExecutionTasksRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowExecutionTasksResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowExecutionsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowExecutionsResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowTargetsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowTargetsResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowTasksRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowTasksResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowsResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeParametersRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeParametersResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribePatchBaselinesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribePatchBaselinesResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribePatchGroupStateRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribePatchGroupStateResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribePatchGroupsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribePatchGroupsResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.GetAutomationExecutionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetAutomationExecutionResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.GetCommandInvocationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetCommandInvocationResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.GetDefaultPatchBaselineRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetDefaultPatchBaselineResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.GetDeployablePatchSnapshotForInstanceRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetDeployablePatchSnapshotForInstanceResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.GetDocumentRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetDocumentResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.GetInventoryRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetInventoryResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.GetInventorySchemaRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetInventorySchemaResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.GetMaintenanceWindowExecutionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetMaintenanceWindowExecutionResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.GetMaintenanceWindowExecutionTaskRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetMaintenanceWindowExecutionTaskResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.GetMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetMaintenanceWindowResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.GetParameterHistoryRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetParameterHistoryResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.GetParameterRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetParameterResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.GetParametersByPathRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetParametersByPathResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.GetParametersRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetParametersResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.GetPatchBaselineForPatchGroupRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetPatchBaselineForPatchGroupResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.GetPatchBaselineRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetPatchBaselineResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.ListAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListAssociationsResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.ListCommandInvocationsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListCommandInvocationsResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.ListCommandsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListCommandsResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.ListDocumentVersionsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListDocumentVersionsResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.ListDocumentsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListDocumentsResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.ListInventoryEntriesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListInventoryEntriesResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListTagsForResourceResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.ModifyDocumentPermissionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ModifyDocumentPermissionResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.PutInventoryRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.PutInventoryResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.PutParameterRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.PutParameterResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.RegisterDefaultPatchBaselineRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.RegisterDefaultPatchBaselineResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.RegisterPatchBaselineForPatchGroupRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.RegisterPatchBaselineForPatchGroupResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.RegisterTargetWithMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.RegisterTargetWithMaintenanceWindowResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.RegisterTaskWithMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.RegisterTaskWithMaintenanceWindowResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.RemoveTagsFromResourceResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.SendCommandRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.SendCommandResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.StartAutomationExecutionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.StartAutomationExecutionResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.StopAutomationExecutionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.StopAutomationExecutionResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateAssociationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateAssociationResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateAssociationStatusRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateAssociationStatusResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateDocumentDefaultVersionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateDocumentDefaultVersionResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateDocumentRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateDocumentResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateMaintenanceWindowResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateManagedInstanceRoleRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateManagedInstanceRoleResponseUnmarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdatePatchBaselineRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdatePatchBaselineResponseUnmarshaller;

/**
 * Internal implementation of {@link SSMClient}.
 *
 * @see SSMClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultSSMClient implements SSMClient {
    private final ClientHandler clientHandler;

    private final SdkJsonProtocolFactory protocolFactory;

    private final ClientConfiguration clientConfiguration;

    protected DefaultSSMClient(SyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkClientHandler(clientConfiguration, null);
        this.protocolFactory = init();
        this.clientConfiguration = clientConfiguration;
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified resource. Tags are metadata that you assign to your managed
     * instances, Maintenance Windows, or Parameter Store parameters. Tags enable you to categorize your resources in
     * different ways, for example, by purpose, owner, or environment. Each tag consists of a key and an optional value,
     * both of which you define. For example, you could define a set of tags for your account's managed instances that
     * helps you track each instance's owner and stack level. For example: Key=Owner and Value=DbAdmin, SysAdmin, or
     * Dev. Or Key=Stack and Value=Production, Pre-Production, or Test.
     * </p>
     * <p>
     * Each resource can have a maximum of 10 tags.
     * </p>
     * <p>
     * We recommend that you devise a set of tag keys that meets your needs for each resource type. Using a consistent
     * set of tag keys makes it easier for you to manage your resources. You can search and filter the resources based
     * on the tags you add. Tags don't have any semantic meaning to Amazon EC2 and are interpreted strictly as a string
     * of characters.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging Your Amazon EC2 Resources</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param addTagsToResourceRequest
     * @return Result of the AddTagsToResource operation returned by the service.
     * @throws InvalidResourceTypeException
     *         The resource type is not valid. If you are attempting to tag an instance, the instance must be a
     *         registered, managed instance.
     * @throws InvalidResourceIdException
     *         The resource ID is not valid. Verify that you entered the correct ID and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws TooManyTagsErrorException
     *         The Targets parameter includes too many tags. Remove one or more tags and try the command again.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.AddTagsToResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AddTagsToResourceResponse addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest)
            throws InvalidResourceTypeException, InvalidResourceIdException, InternalServerErrorException,
            TooManyTagsErrorException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<AddTagsToResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new AddTagsToResourceResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<AddTagsToResourceRequest, AddTagsToResourceResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(addTagsToResourceRequest).withMarshaller(new AddTagsToResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Attempts to cancel the command specified by the Command ID. There is no guarantee that the command will be
     * terminated and the underlying process stopped.
     * </p>
     *
     * @param cancelCommandRequest
     * @return Result of the CancelCommand operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidCommandIdException
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws DuplicateInstanceIdException
     *         You cannot specify an instance ID in more than one association.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.CancelCommand
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CancelCommand" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CancelCommandResponse cancelCommand(CancelCommandRequest cancelCommandRequest) throws InternalServerErrorException,
            InvalidCommandIdException, InvalidInstanceIdException, DuplicateInstanceIdException, SdkBaseException,
            SdkClientException, SSMException {

        HttpResponseHandler<CancelCommandResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CancelCommandResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CancelCommandRequest, CancelCommandResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(cancelCommandRequest).withMarshaller(new CancelCommandRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Registers your on-premises server or virtual machine with Amazon EC2 so that you can manage these resources using
     * Run Command. An on-premises server or virtual machine that has been registered with EC2 is called a managed
     * instance. For more information about activations, see <a
     * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances.html">Setting
     * Up Systems Manager in Hybrid Environments</a>.
     * </p>
     *
     * @param createActivationRequest
     * @return Result of the CreateActivation operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.CreateActivation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateActivation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateActivationResponse createActivation(CreateActivationRequest createActivationRequest)
            throws InternalServerErrorException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<CreateActivationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateActivationResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateActivationRequest, CreateActivationResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createActivationRequest).withMarshaller(new CreateActivationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Associates the specified Systems Manager document with the specified instances or targets.
     * </p>
     * <p>
     * When you associate a document with one or more instances using instance IDs or tags, the SSM Agent running on the
     * instance processes the document and configures the instance as specified.
     * </p>
     * <p>
     * If you associate a document with an instance that already has an associated document, the system throws the
     * AssociationAlreadyExists exception.
     * </p>
     *
     * @param createAssociationRequest
     * @return Result of the CreateAssociation operation returned by the service.
     * @throws AssociationAlreadyExistsException
     *         The specified association already exists.
     * @throws AssociationLimitExceededException
     *         You can have at most 2,000 active associations.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidDocumentVersionException
     *         The document version is not valid or does not exist.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws UnsupportedPlatformTypeException
     *         The document does not support the platform type of the given instance ID(s). For example, you sent an
     *         document for a Windows instance to a Linux instance.
     * @throws InvalidOutputLocationException
     *         The output location is not valid or does not exist.
     * @throws InvalidParametersException
     *         You must specify values for all required parameters in the SSM document. You can only supply values to
     *         parameters defined in the SSM document.
     * @throws InvalidTargetException
     *         The target is not valid or does not exist. It might not be configured for EC2 Systems Manager or you
     *         might not have permission to perform the operation.
     * @throws InvalidScheduleException
     *         The schedule is invalid. Verify your cron or rate expression and try again.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.CreateAssociation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateAssociationResponse createAssociation(CreateAssociationRequest createAssociationRequest)
            throws AssociationAlreadyExistsException, AssociationLimitExceededException, InternalServerErrorException,
            InvalidDocumentException, InvalidDocumentVersionException, InvalidInstanceIdException,
            UnsupportedPlatformTypeException, InvalidOutputLocationException, InvalidParametersException, InvalidTargetException,
            InvalidScheduleException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<CreateAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateAssociationResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateAssociationRequest, CreateAssociationResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createAssociationRequest).withMarshaller(new CreateAssociationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Associates the specified Systems Manager document with the specified instances or targets.
     * </p>
     * <p>
     * When you associate a document with one or more instances using instance IDs or tags, the SSM Agent running on the
     * instance processes the document and configures the instance as specified.
     * </p>
     * <p>
     * If you associate a document with an instance that already has an associated document, the system throws the
     * AssociationAlreadyExists exception.
     * </p>
     *
     * @param createAssociationBatchRequest
     * @return Result of the CreateAssociationBatch operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidDocumentVersionException
     *         The document version is not valid or does not exist.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidParametersException
     *         You must specify values for all required parameters in the SSM document. You can only supply values to
     *         parameters defined in the SSM document.
     * @throws DuplicateInstanceIdException
     *         You cannot specify an instance ID in more than one association.
     * @throws AssociationLimitExceededException
     *         You can have at most 2,000 active associations.
     * @throws UnsupportedPlatformTypeException
     *         The document does not support the platform type of the given instance ID(s). For example, you sent an
     *         document for a Windows instance to a Linux instance.
     * @throws InvalidOutputLocationException
     *         The output location is not valid or does not exist.
     * @throws InvalidTargetException
     *         The target is not valid or does not exist. It might not be configured for EC2 Systems Manager or you
     *         might not have permission to perform the operation.
     * @throws InvalidScheduleException
     *         The schedule is invalid. Verify your cron or rate expression and try again.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.CreateAssociationBatch
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateAssociationBatch" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateAssociationBatchResponse createAssociationBatch(CreateAssociationBatchRequest createAssociationBatchRequest)
            throws InternalServerErrorException, InvalidDocumentException, InvalidDocumentVersionException,
            InvalidInstanceIdException, InvalidParametersException, DuplicateInstanceIdException,
            AssociationLimitExceededException, UnsupportedPlatformTypeException, InvalidOutputLocationException,
            InvalidTargetException, InvalidScheduleException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<CreateAssociationBatchResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateAssociationBatchResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateAssociationBatchRequest, CreateAssociationBatchResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createAssociationBatchRequest)
                .withMarshaller(new CreateAssociationBatchRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a Systems Manager document.
     * </p>
     * <p>
     * After you create a document, you can use CreateAssociation to associate it with one or more running instances.
     * </p>
     *
     * @param createDocumentRequest
     * @return Result of the CreateDocument operation returned by the service.
     * @throws DocumentAlreadyExistsException
     *         The specified document already exists.
     * @throws MaxDocumentSizeExceededException
     *         The size limit of a document is 64 KB.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentContentException
     *         The content for the document is not valid.
     * @throws DocumentLimitExceededException
     *         You can have at most 200 active SSM documents.
     * @throws InvalidDocumentSchemaVersionException
     *         The version of the document schema is not supported.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.CreateDocument
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateDocument" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDocumentResponse createDocument(CreateDocumentRequest createDocumentRequest)
            throws DocumentAlreadyExistsException, MaxDocumentSizeExceededException, InternalServerErrorException,
            InvalidDocumentContentException, DocumentLimitExceededException, InvalidDocumentSchemaVersionException,
            SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<CreateDocumentResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateDocumentResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateDocumentRequest, CreateDocumentResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createDocumentRequest).withMarshaller(new CreateDocumentRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a new Maintenance Window.
     * </p>
     *
     * @param createMaintenanceWindowRequest
     * @return Result of the CreateMaintenanceWindow operation returned by the service.
     * @throws IdempotentParameterMismatchException
     *         Error returned when an idempotent operation is retried and the parameters don't match the original call
     *         to the API with the same idempotency token.
     * @throws ResourceLimitExceededException
     *         Error returned when the caller has exceeded the default resource limits (e.g. too many Maintenance
     *         Windows have been created).
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.CreateMaintenanceWindow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateMaintenanceWindow" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateMaintenanceWindowResponse createMaintenanceWindow(CreateMaintenanceWindowRequest createMaintenanceWindowRequest)
            throws IdempotentParameterMismatchException, ResourceLimitExceededException, InternalServerErrorException,
            SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<CreateMaintenanceWindowResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreateMaintenanceWindowResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreateMaintenanceWindowRequest, CreateMaintenanceWindowResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createMaintenanceWindowRequest)
                .withMarshaller(new CreateMaintenanceWindowRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a patch baseline.
     * </p>
     *
     * @param createPatchBaselineRequest
     * @return Result of the CreatePatchBaseline operation returned by the service.
     * @throws IdempotentParameterMismatchException
     *         Error returned when an idempotent operation is retried and the parameters don't match the original call
     *         to the API with the same idempotency token.
     * @throws ResourceLimitExceededException
     *         Error returned when the caller has exceeded the default resource limits (e.g. too many Maintenance
     *         Windows have been created).
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.CreatePatchBaseline
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreatePatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreatePatchBaselineResponse createPatchBaseline(CreatePatchBaselineRequest createPatchBaselineRequest)
            throws IdempotentParameterMismatchException, ResourceLimitExceededException, InternalServerErrorException,
            SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<CreatePatchBaselineResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new CreatePatchBaselineResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<CreatePatchBaselineRequest, CreatePatchBaselineResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(createPatchBaselineRequest).withMarshaller(new CreatePatchBaselineRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes an activation. You are not required to delete an activation. If you delete an activation, you can no
     * longer use it to register additional managed instances. Deleting an activation does not de-register managed
     * instances. You must manually de-register managed instances.
     * </p>
     *
     * @param deleteActivationRequest
     * @return Result of the DeleteActivation operation returned by the service.
     * @throws InvalidActivationIdException
     *         The activation ID is not valid. Verify the you entered the correct ActivationId or ActivationCode and try
     *         again.
     * @throws InvalidActivationException
     *         The activation is not valid. The activation might have been deleted, or the ActivationId and the
     *         ActivationCode do not match.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DeleteActivation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteActivation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteActivationResponse deleteActivation(DeleteActivationRequest deleteActivationRequest)
            throws InvalidActivationIdException, InvalidActivationException, InternalServerErrorException, SdkBaseException,
            SdkClientException, SSMException {

        HttpResponseHandler<DeleteActivationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteActivationResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteActivationRequest, DeleteActivationResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteActivationRequest).withMarshaller(new DeleteActivationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Disassociates the specified Systems Manager document from the specified instance.
     * </p>
     * <p>
     * When you disassociate a document from an instance, it does not change the configuration of the instance. To
     * change the configuration state of an instance after you disassociate a document, you must create a new document
     * with the desired configuration and associate it with the instance.
     * </p>
     *
     * @param deleteAssociationRequest
     * @return Result of the DeleteAssociation operation returned by the service.
     * @throws AssociationDoesNotExistException
     *         The specified association does not exist.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws TooManyUpdatesException
     *         There are concurrent updates for a resource that supports one update at a time.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DeleteAssociation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteAssociationResponse deleteAssociation(DeleteAssociationRequest deleteAssociationRequest)
            throws AssociationDoesNotExistException, InternalServerErrorException, InvalidDocumentException,
            InvalidInstanceIdException, TooManyUpdatesException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<DeleteAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteAssociationResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteAssociationRequest, DeleteAssociationResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteAssociationRequest).withMarshaller(new DeleteAssociationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes the Systems Manager document and all instance associations to the document.
     * </p>
     * <p>
     * Before you delete the document, we recommend that you use <a>DeleteAssociation</a> to disassociate all instances
     * that are associated with the document.
     * </p>
     *
     * @param deleteDocumentRequest
     * @return Result of the DeleteDocument operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidDocumentOperationException
     *         You attempted to delete a document while it is still shared. You must stop sharing the document before
     *         you can delete it.
     * @throws AssociatedInstancesException
     *         You must disassociate a document from all instances before you can delete it.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DeleteDocument
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteDocument" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteDocumentResponse deleteDocument(DeleteDocumentRequest deleteDocumentRequest)
            throws InternalServerErrorException, InvalidDocumentException, InvalidDocumentOperationException,
            AssociatedInstancesException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<DeleteDocumentResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteDocumentResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteDocumentRequest, DeleteDocumentResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteDocumentRequest).withMarshaller(new DeleteDocumentRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a Maintenance Window.
     * </p>
     *
     * @param deleteMaintenanceWindowRequest
     * @return Result of the DeleteMaintenanceWindow operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DeleteMaintenanceWindow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteMaintenanceWindow" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteMaintenanceWindowResponse deleteMaintenanceWindow(DeleteMaintenanceWindowRequest deleteMaintenanceWindowRequest)
            throws InternalServerErrorException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<DeleteMaintenanceWindowResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteMaintenanceWindowResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteMaintenanceWindowRequest, DeleteMaintenanceWindowResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteMaintenanceWindowRequest)
                .withMarshaller(new DeleteMaintenanceWindowRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Delete a parameter from the system.
     * </p>
     *
     * @param deleteParameterRequest
     * @return Result of the DeleteParameter operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ParameterNotFoundException
     *         The parameter could not be found. Verify the name and try again.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DeleteParameter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteParameter" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteParameterResponse deleteParameter(DeleteParameterRequest deleteParameterRequest)
            throws InternalServerErrorException, ParameterNotFoundException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<DeleteParameterResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteParameterResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteParameterRequest, DeleteParameterResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteParameterRequest).withMarshaller(new DeleteParameterRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Delete a list of parameters.
     * </p>
     *
     * @param deleteParametersRequest
     * @return Result of the DeleteParameters operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DeleteParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteParameters" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteParametersResponse deleteParameters(DeleteParametersRequest deleteParametersRequest)
            throws InternalServerErrorException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<DeleteParametersResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeleteParametersResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeleteParametersRequest, DeleteParametersResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deleteParametersRequest).withMarshaller(new DeleteParametersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a patch baseline.
     * </p>
     *
     * @param deletePatchBaselineRequest
     * @return Result of the DeletePatchBaseline operation returned by the service.
     * @throws ResourceInUseException
     *         Error returned if an attempt is made to delete a patch baseline that is registered for a patch group.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DeletePatchBaseline
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeletePatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeletePatchBaselineResponse deletePatchBaseline(DeletePatchBaselineRequest deletePatchBaselineRequest)
            throws ResourceInUseException, InternalServerErrorException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<DeletePatchBaselineResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeletePatchBaselineResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DeletePatchBaselineRequest, DeletePatchBaselineResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(deletePatchBaselineRequest).withMarshaller(new DeletePatchBaselineRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Removes the server or virtual machine from the list of registered servers. You can reregister the instance again
     * at any time. If you don't plan to use Run Command on the server, we suggest uninstalling the SSM Agent first.
     * </p>
     *
     * @param deregisterManagedInstanceRequest
     * @return Result of the DeregisterManagedInstance operation returned by the service.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DeregisterManagedInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterManagedInstance" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeregisterManagedInstanceResponse deregisterManagedInstance(
            DeregisterManagedInstanceRequest deregisterManagedInstanceRequest) throws InvalidInstanceIdException,
            InternalServerErrorException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<DeregisterManagedInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeregisterManagedInstanceResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DeregisterManagedInstanceRequest, DeregisterManagedInstanceResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(deregisterManagedInstanceRequest)
                        .withMarshaller(new DeregisterManagedInstanceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Removes a patch group from a patch baseline.
     * </p>
     *
     * @param deregisterPatchBaselineForPatchGroupRequest
     * @return Result of the DeregisterPatchBaselineForPatchGroup operation returned by the service.
     * @throws InvalidResourceIdException
     *         The resource ID is not valid. Verify that you entered the correct ID and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DeregisterPatchBaselineForPatchGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterPatchBaselineForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeregisterPatchBaselineForPatchGroupResponse deregisterPatchBaselineForPatchGroup(
            DeregisterPatchBaselineForPatchGroupRequest deregisterPatchBaselineForPatchGroupRequest)
            throws InvalidResourceIdException, InternalServerErrorException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<DeregisterPatchBaselineForPatchGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                        new DeregisterPatchBaselineForPatchGroupResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DeregisterPatchBaselineForPatchGroupRequest, DeregisterPatchBaselineForPatchGroupResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(deregisterPatchBaselineForPatchGroupRequest)
                        .withMarshaller(new DeregisterPatchBaselineForPatchGroupRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Removes a target from a Maintenance Window.
     * </p>
     *
     * @param deregisterTargetFromMaintenanceWindowRequest
     * @return Result of the DeregisterTargetFromMaintenanceWindow operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource (e.g. a Maintenance Window) doesn't exist.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DeregisterTargetFromMaintenanceWindow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterTargetFromMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeregisterTargetFromMaintenanceWindowResponse deregisterTargetFromMaintenanceWindow(
            DeregisterTargetFromMaintenanceWindowRequest deregisterTargetFromMaintenanceWindowRequest)
            throws DoesNotExistException, InternalServerErrorException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<DeregisterTargetFromMaintenanceWindowResponse> responseHandler = protocolFactory
                .createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                        new DeregisterTargetFromMaintenanceWindowResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DeregisterTargetFromMaintenanceWindowRequest, DeregisterTargetFromMaintenanceWindowResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(deregisterTargetFromMaintenanceWindowRequest)
                        .withMarshaller(new DeregisterTargetFromMaintenanceWindowRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Removes a task from a Maintenance Window.
     * </p>
     *
     * @param deregisterTaskFromMaintenanceWindowRequest
     * @return Result of the DeregisterTaskFromMaintenanceWindow operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource (e.g. a Maintenance Window) doesn't exist.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DeregisterTaskFromMaintenanceWindow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterTaskFromMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeregisterTaskFromMaintenanceWindowResponse deregisterTaskFromMaintenanceWindow(
            DeregisterTaskFromMaintenanceWindowRequest deregisterTaskFromMaintenanceWindowRequest) throws DoesNotExistException,
            InternalServerErrorException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<DeregisterTaskFromMaintenanceWindowResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DeregisterTaskFromMaintenanceWindowResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DeregisterTaskFromMaintenanceWindowRequest, DeregisterTaskFromMaintenanceWindowResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(deregisterTaskFromMaintenanceWindowRequest)
                        .withMarshaller(new DeregisterTaskFromMaintenanceWindowRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Details about the activation, including: the date and time the activation was created, the expiration date, the
     * IAM role assigned to the instances in the activation, and the number of instances activated by this registration.
     * </p>
     *
     * @param describeActivationsRequest
     * @return Result of the DescribeActivations operation returned by the service.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DescribeActivations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeActivations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeActivationsResponse describeActivations(DescribeActivationsRequest describeActivationsRequest)
            throws InvalidFilterException, InvalidNextTokenException, InternalServerErrorException, SdkBaseException,
            SdkClientException, SSMException {

        HttpResponseHandler<DescribeActivationsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribeActivationsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribeActivationsRequest, DescribeActivationsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(describeActivationsRequest).withMarshaller(new DescribeActivationsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Describes the associations for the specified Systems Manager document or instance.
     * </p>
     *
     * @param describeAssociationRequest
     * @return Result of the DescribeAssociation operation returned by the service.
     * @throws AssociationDoesNotExistException
     *         The specified association does not exist.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DescribeAssociation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeAssociationResponse describeAssociation(DescribeAssociationRequest describeAssociationRequest)
            throws AssociationDoesNotExistException, InternalServerErrorException, InvalidDocumentException,
            InvalidInstanceIdException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<DescribeAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribeAssociationResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribeAssociationRequest, DescribeAssociationResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(describeAssociationRequest).withMarshaller(new DescribeAssociationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Provides details about all active and terminated Automation executions.
     * </p>
     *
     * @param describeAutomationExecutionsRequest
     * @return Result of the DescribeAutomationExecutions operation returned by the service.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DescribeAutomationExecutions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAutomationExecutionsResponse describeAutomationExecutions(
            DescribeAutomationExecutionsRequest describeAutomationExecutionsRequest) throws InvalidNextTokenException,
            InternalServerErrorException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<DescribeAutomationExecutionsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribeAutomationExecutionsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeAutomationExecutionsRequest, DescribeAutomationExecutionsResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeAutomationExecutionsRequest)
                        .withMarshaller(new DescribeAutomationExecutionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists all patches that could possibly be included in a patch baseline.
     * </p>
     *
     * @param describeAvailablePatchesRequest
     * @return Result of the DescribeAvailablePatches operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DescribeAvailablePatches
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAvailablePatches" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeAvailablePatchesResponse describeAvailablePatches(
            DescribeAvailablePatchesRequest describeAvailablePatchesRequest) throws InternalServerErrorException,
            SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<DescribeAvailablePatchesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribeAvailablePatchesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeAvailablePatchesRequest, DescribeAvailablePatchesResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeAvailablePatchesRequest)
                        .withMarshaller(new DescribeAvailablePatchesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Describes the specified SSM document.
     * </p>
     *
     * @param describeDocumentRequest
     * @return Result of the DescribeDocument operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidDocumentVersionException
     *         The document version is not valid or does not exist.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DescribeDocument
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocument" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeDocumentResponse describeDocument(DescribeDocumentRequest describeDocumentRequest)
            throws InternalServerErrorException, InvalidDocumentException, InvalidDocumentVersionException, SdkBaseException,
            SdkClientException, SSMException {

        HttpResponseHandler<DescribeDocumentResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribeDocumentResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribeDocumentRequest, DescribeDocumentResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(describeDocumentRequest).withMarshaller(new DescribeDocumentRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Describes the permissions for a Systems Manager document. If you created the document, you are the owner. If a
     * document is shared, it can either be shared privately (by specifying a user's AWS account ID) or publicly
     * (<i>All</i>).
     * </p>
     *
     * @param describeDocumentPermissionRequest
     * @return Result of the DescribeDocumentPermission operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidPermissionTypeException
     *         The permission type is not supported. <i>Share</i> is the only supported permission type.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DescribeDocumentPermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocumentPermission" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeDocumentPermissionResponse describeDocumentPermission(
            DescribeDocumentPermissionRequest describeDocumentPermissionRequest) throws InternalServerErrorException,
            InvalidDocumentException, InvalidPermissionTypeException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<DescribeDocumentPermissionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribeDocumentPermissionResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeDocumentPermissionRequest, DescribeDocumentPermissionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeDocumentPermissionRequest)
                        .withMarshaller(new DescribeDocumentPermissionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * All associations for the instance(s).
     * </p>
     *
     * @param describeEffectiveInstanceAssociationsRequest
     * @return Result of the DescribeEffectiveInstanceAssociations operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DescribeEffectiveInstanceAssociations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectiveInstanceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeEffectiveInstanceAssociationsResponse describeEffectiveInstanceAssociations(
            DescribeEffectiveInstanceAssociationsRequest describeEffectiveInstanceAssociationsRequest)
            throws InternalServerErrorException, InvalidInstanceIdException, InvalidNextTokenException, SdkBaseException,
            SdkClientException, SSMException {

        HttpResponseHandler<DescribeEffectiveInstanceAssociationsResponse> responseHandler = protocolFactory
                .createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                        new DescribeEffectiveInstanceAssociationsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeEffectiveInstanceAssociationsRequest, DescribeEffectiveInstanceAssociationsResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeEffectiveInstanceAssociationsRequest)
                        .withMarshaller(new DescribeEffectiveInstanceAssociationsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves the current effective patches (the patch and the approval state) for the specified patch baseline.
     * </p>
     *
     * @param describeEffectivePatchesForPatchBaselineRequest
     * @return Result of the DescribeEffectivePatchesForPatchBaseline operation returned by the service.
     * @throws InvalidResourceIdException
     *         The resource ID is not valid. Verify that you entered the correct ID and try again.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource (e.g. a Maintenance Window) doesn't exist.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DescribeEffectivePatchesForPatchBaseline
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectivePatchesForPatchBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeEffectivePatchesForPatchBaselineResponse describeEffectivePatchesForPatchBaseline(
            DescribeEffectivePatchesForPatchBaselineRequest describeEffectivePatchesForPatchBaselineRequest)
            throws InvalidResourceIdException, DoesNotExistException, InternalServerErrorException, SdkBaseException,
            SdkClientException, SSMException {

        HttpResponseHandler<DescribeEffectivePatchesForPatchBaselineResponse> responseHandler = protocolFactory
                .createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                        new DescribeEffectivePatchesForPatchBaselineResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeEffectivePatchesForPatchBaselineRequest, DescribeEffectivePatchesForPatchBaselineResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeEffectivePatchesForPatchBaselineRequest)
                        .withMarshaller(new DescribeEffectivePatchesForPatchBaselineRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * The status of the associations for the instance(s).
     * </p>
     *
     * @param describeInstanceAssociationsStatusRequest
     * @return Result of the DescribeInstanceAssociationsStatus operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DescribeInstanceAssociationsStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceAssociationsStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeInstanceAssociationsStatusResponse describeInstanceAssociationsStatus(
            DescribeInstanceAssociationsStatusRequest describeInstanceAssociationsStatusRequest)
            throws InternalServerErrorException, InvalidInstanceIdException, InvalidNextTokenException, SdkBaseException,
            SdkClientException, SSMException {

        HttpResponseHandler<DescribeInstanceAssociationsStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribeInstanceAssociationsStatusResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeInstanceAssociationsStatusRequest, DescribeInstanceAssociationsStatusResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeInstanceAssociationsStatusRequest)
                        .withMarshaller(new DescribeInstanceAssociationsStatusRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Describes one or more of your instances. You can use this to get information about instances like the operating
     * system platform, the SSM Agent version (Linux), status etc. If you specify one or more instance IDs, it returns
     * information for those instances. If you do not specify instance IDs, it returns information for all your
     * instances. If you specify an instance ID that is not valid or an instance that you do not own, you receive an
     * error.
     * </p>
     *
     * @param describeInstanceInformationRequest
     * @return Result of the DescribeInstanceInformation operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidInstanceInformationFilterValueException
     *         The specified filter value is not valid.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DescribeInstanceInformation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceInformation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeInstanceInformationResponse describeInstanceInformation(
            DescribeInstanceInformationRequest describeInstanceInformationRequest) throws InternalServerErrorException,
            InvalidInstanceIdException, InvalidNextTokenException, InvalidInstanceInformationFilterValueException,
            InvalidFilterKeyException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<DescribeInstanceInformationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribeInstanceInformationResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeInstanceInformationRequest, DescribeInstanceInformationResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeInstanceInformationRequest)
                        .withMarshaller(new DescribeInstanceInformationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves the high-level patch state of one or more instances.
     * </p>
     *
     * @param describeInstancePatchStatesRequest
     * @return Result of the DescribeInstancePatchStates operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DescribeInstancePatchStates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeInstancePatchStatesResponse describeInstancePatchStates(
            DescribeInstancePatchStatesRequest describeInstancePatchStatesRequest) throws InternalServerErrorException,
            InvalidNextTokenException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<DescribeInstancePatchStatesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribeInstancePatchStatesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeInstancePatchStatesRequest, DescribeInstancePatchStatesResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeInstancePatchStatesRequest)
                        .withMarshaller(new DescribeInstancePatchStatesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves the high-level patch state for the instances in the specified patch group.
     * </p>
     *
     * @param describeInstancePatchStatesForPatchGroupRequest
     * @return Result of the DescribeInstancePatchStatesForPatchGroup operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DescribeInstancePatchStatesForPatchGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStatesForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeInstancePatchStatesForPatchGroupResponse describeInstancePatchStatesForPatchGroup(
            DescribeInstancePatchStatesForPatchGroupRequest describeInstancePatchStatesForPatchGroupRequest)
            throws InternalServerErrorException, InvalidFilterException, InvalidNextTokenException, SdkBaseException,
            SdkClientException, SSMException {

        HttpResponseHandler<DescribeInstancePatchStatesForPatchGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                        new DescribeInstancePatchStatesForPatchGroupResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeInstancePatchStatesForPatchGroupRequest, DescribeInstancePatchStatesForPatchGroupResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeInstancePatchStatesForPatchGroupRequest)
                        .withMarshaller(new DescribeInstancePatchStatesForPatchGroupRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about the patches on the specified instance and their state relative to the patch baseline
     * being used for the instance.
     * </p>
     *
     * @param describeInstancePatchesRequest
     * @return Result of the DescribeInstancePatches operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DescribeInstancePatches
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatches" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeInstancePatchesResponse describeInstancePatches(DescribeInstancePatchesRequest describeInstancePatchesRequest)
            throws InternalServerErrorException, InvalidInstanceIdException, InvalidFilterException, InvalidNextTokenException,
            SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<DescribeInstancePatchesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribeInstancePatchesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribeInstancePatchesRequest, DescribeInstancePatchesResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(describeInstancePatchesRequest)
                .withMarshaller(new DescribeInstancePatchesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves the individual task executions (one per target) for a particular task executed as part of a Maintenance
     * Window execution.
     * </p>
     *
     * @param describeMaintenanceWindowExecutionTaskInvocationsRequest
     * @return Result of the DescribeMaintenanceWindowExecutionTaskInvocations operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource (e.g. a Maintenance Window) doesn't exist.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DescribeMaintenanceWindowExecutionTaskInvocations
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTaskInvocations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeMaintenanceWindowExecutionTaskInvocationsResponse describeMaintenanceWindowExecutionTaskInvocations(
            DescribeMaintenanceWindowExecutionTaskInvocationsRequest describeMaintenanceWindowExecutionTaskInvocationsRequest)
            throws DoesNotExistException, InternalServerErrorException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<DescribeMaintenanceWindowExecutionTaskInvocationsResponse> responseHandler = protocolFactory
                .createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                        new DescribeMaintenanceWindowExecutionTaskInvocationsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeMaintenanceWindowExecutionTaskInvocationsRequest, DescribeMaintenanceWindowExecutionTaskInvocationsResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeMaintenanceWindowExecutionTaskInvocationsRequest)
                        .withMarshaller(new DescribeMaintenanceWindowExecutionTaskInvocationsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * For a given Maintenance Window execution, lists the tasks that were executed.
     * </p>
     *
     * @param describeMaintenanceWindowExecutionTasksRequest
     * @return Result of the DescribeMaintenanceWindowExecutionTasks operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource (e.g. a Maintenance Window) doesn't exist.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DescribeMaintenanceWindowExecutionTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTasks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeMaintenanceWindowExecutionTasksResponse describeMaintenanceWindowExecutionTasks(
            DescribeMaintenanceWindowExecutionTasksRequest describeMaintenanceWindowExecutionTasksRequest)
            throws DoesNotExistException, InternalServerErrorException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<DescribeMaintenanceWindowExecutionTasksResponse> responseHandler = protocolFactory
                .createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                        new DescribeMaintenanceWindowExecutionTasksResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeMaintenanceWindowExecutionTasksRequest, DescribeMaintenanceWindowExecutionTasksResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeMaintenanceWindowExecutionTasksRequest)
                        .withMarshaller(new DescribeMaintenanceWindowExecutionTasksRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists the executions of a Maintenance Window (meaning, information about when the Maintenance Window was
     * scheduled to be active and information about tasks registered and run with the Maintenance Window).
     * </p>
     *
     * @param describeMaintenanceWindowExecutionsRequest
     * @return Result of the DescribeMaintenanceWindowExecutions operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DescribeMaintenanceWindowExecutions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeMaintenanceWindowExecutionsResponse describeMaintenanceWindowExecutions(
            DescribeMaintenanceWindowExecutionsRequest describeMaintenanceWindowExecutionsRequest)
            throws InternalServerErrorException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<DescribeMaintenanceWindowExecutionsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribeMaintenanceWindowExecutionsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeMaintenanceWindowExecutionsRequest, DescribeMaintenanceWindowExecutionsResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeMaintenanceWindowExecutionsRequest)
                        .withMarshaller(new DescribeMaintenanceWindowExecutionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists the targets registered with the Maintenance Window.
     * </p>
     *
     * @param describeMaintenanceWindowTargetsRequest
     * @return Result of the DescribeMaintenanceWindowTargets operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource (e.g. a Maintenance Window) doesn't exist.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DescribeMaintenanceWindowTargets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTargets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeMaintenanceWindowTargetsResponse describeMaintenanceWindowTargets(
            DescribeMaintenanceWindowTargetsRequest describeMaintenanceWindowTargetsRequest) throws DoesNotExistException,
            InternalServerErrorException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<DescribeMaintenanceWindowTargetsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribeMaintenanceWindowTargetsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeMaintenanceWindowTargetsRequest, DescribeMaintenanceWindowTargetsResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeMaintenanceWindowTargetsRequest)
                        .withMarshaller(new DescribeMaintenanceWindowTargetsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists the tasks in a Maintenance Window.
     * </p>
     *
     * @param describeMaintenanceWindowTasksRequest
     * @return Result of the DescribeMaintenanceWindowTasks operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource (e.g. a Maintenance Window) doesn't exist.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DescribeMaintenanceWindowTasks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTasks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeMaintenanceWindowTasksResponse describeMaintenanceWindowTasks(
            DescribeMaintenanceWindowTasksRequest describeMaintenanceWindowTasksRequest) throws DoesNotExistException,
            InternalServerErrorException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<DescribeMaintenanceWindowTasksResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribeMaintenanceWindowTasksResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeMaintenanceWindowTasksRequest, DescribeMaintenanceWindowTasksResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeMaintenanceWindowTasksRequest)
                        .withMarshaller(new DescribeMaintenanceWindowTasksRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves the Maintenance Windows in an AWS account.
     * </p>
     *
     * @param describeMaintenanceWindowsRequest
     * @return Result of the DescribeMaintenanceWindows operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DescribeMaintenanceWindows
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindows" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeMaintenanceWindowsResponse describeMaintenanceWindows(
            DescribeMaintenanceWindowsRequest describeMaintenanceWindowsRequest) throws InternalServerErrorException,
            SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<DescribeMaintenanceWindowsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribeMaintenanceWindowsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<DescribeMaintenanceWindowsRequest, DescribeMaintenanceWindowsResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(describeMaintenanceWindowsRequest)
                        .withMarshaller(new DescribeMaintenanceWindowsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Get information about a parameter.
     * </p>
     *
     * @param describeParametersRequest
     * @return Result of the DescribeParameters operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidFilterOptionException
     *         The specified filter option is not valid. Valid options are Equals and BeginsWith. For Path filter, valid
     *         options are Recursive and OneLevel.
     * @throws InvalidFilterValueException
     *         The filter value is not valid. Verify the value and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DescribeParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeParameters" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeParametersResponse describeParameters(DescribeParametersRequest describeParametersRequest)
            throws InternalServerErrorException, InvalidFilterKeyException, InvalidFilterOptionException,
            InvalidFilterValueException, InvalidNextTokenException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<DescribeParametersResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribeParametersResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribeParametersRequest, DescribeParametersResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(describeParametersRequest).withMarshaller(new DescribeParametersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists the patch baselines in your AWS account.
     * </p>
     *
     * @param describePatchBaselinesRequest
     * @return Result of the DescribePatchBaselines operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DescribePatchBaselines
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchBaselines" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribePatchBaselinesResponse describePatchBaselines(DescribePatchBaselinesRequest describePatchBaselinesRequest)
            throws InternalServerErrorException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<DescribePatchBaselinesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribePatchBaselinesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribePatchBaselinesRequest, DescribePatchBaselinesResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(describePatchBaselinesRequest)
                .withMarshaller(new DescribePatchBaselinesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns high-level aggregated patch compliance state for a patch group.
     * </p>
     *
     * @param describePatchGroupStateRequest
     * @return Result of the DescribePatchGroupState operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DescribePatchGroupState
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroupState" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribePatchGroupStateResponse describePatchGroupState(DescribePatchGroupStateRequest describePatchGroupStateRequest)
            throws InternalServerErrorException, InvalidNextTokenException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<DescribePatchGroupStateResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribePatchGroupStateResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribePatchGroupStateRequest, DescribePatchGroupStateResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(describePatchGroupStateRequest)
                .withMarshaller(new DescribePatchGroupStateRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists all patch groups that have been registered with patch baselines.
     * </p>
     *
     * @param describePatchGroupsRequest
     * @return Result of the DescribePatchGroups operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.DescribePatchGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribePatchGroupsResponse describePatchGroups(DescribePatchGroupsRequest describePatchGroupsRequest)
            throws InternalServerErrorException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<DescribePatchGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new DescribePatchGroupsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<DescribePatchGroupsRequest, DescribePatchGroupsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(describePatchGroupsRequest).withMarshaller(new DescribePatchGroupsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Get detailed information about a particular Automation execution.
     * </p>
     *
     * @param getAutomationExecutionRequest
     * @return Result of the GetAutomationExecution operation returned by the service.
     * @throws AutomationExecutionNotFoundException
     *         There is no automation execution information for the requested automation execution ID.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.GetAutomationExecution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetAutomationExecution" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetAutomationExecutionResponse getAutomationExecution(GetAutomationExecutionRequest getAutomationExecutionRequest)
            throws AutomationExecutionNotFoundException, InternalServerErrorException, SdkBaseException, SdkClientException,
            SSMException {

        HttpResponseHandler<GetAutomationExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetAutomationExecutionResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetAutomationExecutionRequest, GetAutomationExecutionResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getAutomationExecutionRequest)
                .withMarshaller(new GetAutomationExecutionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns detailed information about command execution for an invocation or plugin.
     * </p>
     *
     * @param getCommandInvocationRequest
     * @return Result of the GetCommandInvocation operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidCommandIdException
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidPluginNameException
     *         The plugin name is not valid.
     * @throws InvocationDoesNotExistException
     *         The command ID and instance ID you specified did not match any invocations. Verify the command ID adn the
     *         instance ID and try again.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.GetCommandInvocation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetCommandInvocation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetCommandInvocationResponse getCommandInvocation(GetCommandInvocationRequest getCommandInvocationRequest)
            throws InternalServerErrorException, InvalidCommandIdException, InvalidInstanceIdException,
            InvalidPluginNameException, InvocationDoesNotExistException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<GetCommandInvocationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetCommandInvocationResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetCommandInvocationRequest, GetCommandInvocationResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getCommandInvocationRequest)
                .withMarshaller(new GetCommandInvocationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves the default patch baseline.
     * </p>
     *
     * @param getDefaultPatchBaselineRequest
     * @return Result of the GetDefaultPatchBaseline operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.GetDefaultPatchBaseline
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDefaultPatchBaseline" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetDefaultPatchBaselineResponse getDefaultPatchBaseline(GetDefaultPatchBaselineRequest getDefaultPatchBaselineRequest)
            throws InternalServerErrorException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<GetDefaultPatchBaselineResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetDefaultPatchBaselineResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetDefaultPatchBaselineRequest, GetDefaultPatchBaselineResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getDefaultPatchBaselineRequest)
                .withMarshaller(new GetDefaultPatchBaselineRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves the current snapshot for the patch baseline the instance uses. This API is primarily used by the
     * AWS-ApplyPatchBaseline Systems Manager document.
     * </p>
     *
     * @param getDeployablePatchSnapshotForInstanceRequest
     * @return Result of the GetDeployablePatchSnapshotForInstance operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.GetDeployablePatchSnapshotForInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDeployablePatchSnapshotForInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetDeployablePatchSnapshotForInstanceResponse getDeployablePatchSnapshotForInstance(
            GetDeployablePatchSnapshotForInstanceRequest getDeployablePatchSnapshotForInstanceRequest)
            throws InternalServerErrorException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<GetDeployablePatchSnapshotForInstanceResponse> responseHandler = protocolFactory
                .createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                        new GetDeployablePatchSnapshotForInstanceResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<GetDeployablePatchSnapshotForInstanceRequest, GetDeployablePatchSnapshotForInstanceResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getDeployablePatchSnapshotForInstanceRequest)
                        .withMarshaller(new GetDeployablePatchSnapshotForInstanceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Gets the contents of the specified SSM document.
     * </p>
     *
     * @param getDocumentRequest
     * @return Result of the GetDocument operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidDocumentVersionException
     *         The document version is not valid or does not exist.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.GetDocument
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDocument" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDocumentResponse getDocument(GetDocumentRequest getDocumentRequest) throws InternalServerErrorException,
            InvalidDocumentException, InvalidDocumentVersionException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<GetDocumentResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetDocumentResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetDocumentRequest, GetDocumentResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getDocumentRequest).withMarshaller(new GetDocumentRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Query inventory information.
     * </p>
     *
     * @param getInventoryRequest
     * @return Result of the GetInventory operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidTypeNameException
     *         The parameter type name is not valid.
     * @throws InvalidResultAttributeException
     *         The specified inventory item result attribute is not valid.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.GetInventory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetInventoryResponse getInventory(GetInventoryRequest getInventoryRequest) throws InternalServerErrorException,
            InvalidFilterException, InvalidNextTokenException, InvalidTypeNameException, InvalidResultAttributeException,
            SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<GetInventoryResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetInventoryResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetInventoryRequest, GetInventoryResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getInventoryRequest).withMarshaller(new GetInventoryRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Return a list of inventory type names for the account, or return a list of attribute names for a specific
     * Inventory item type.
     * </p>
     *
     * @param getInventorySchemaRequest
     * @return Result of the GetInventorySchema operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidTypeNameException
     *         The parameter type name is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.GetInventorySchema
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventorySchema" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetInventorySchemaResponse getInventorySchema(GetInventorySchemaRequest getInventorySchemaRequest)
            throws InternalServerErrorException, InvalidTypeNameException, InvalidNextTokenException, SdkBaseException,
            SdkClientException, SSMException {

        HttpResponseHandler<GetInventorySchemaResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetInventorySchemaResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetInventorySchemaRequest, GetInventorySchemaResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getInventorySchemaRequest).withMarshaller(new GetInventorySchemaRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves a Maintenance Window.
     * </p>
     *
     * @param getMaintenanceWindowRequest
     * @return Result of the GetMaintenanceWindow operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource (e.g. a Maintenance Window) doesn't exist.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.GetMaintenanceWindow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetMaintenanceWindowResponse getMaintenanceWindow(GetMaintenanceWindowRequest getMaintenanceWindowRequest)
            throws DoesNotExistException, InternalServerErrorException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<GetMaintenanceWindowResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetMaintenanceWindowResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetMaintenanceWindowRequest, GetMaintenanceWindowResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getMaintenanceWindowRequest)
                .withMarshaller(new GetMaintenanceWindowRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves details about a specific task executed as part of a Maintenance Window execution.
     * </p>
     *
     * @param getMaintenanceWindowExecutionRequest
     * @return Result of the GetMaintenanceWindowExecution operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource (e.g. a Maintenance Window) doesn't exist.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.GetMaintenanceWindowExecution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetMaintenanceWindowExecutionResponse getMaintenanceWindowExecution(
            GetMaintenanceWindowExecutionRequest getMaintenanceWindowExecutionRequest) throws DoesNotExistException,
            InternalServerErrorException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<GetMaintenanceWindowExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetMaintenanceWindowExecutionResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<GetMaintenanceWindowExecutionRequest, GetMaintenanceWindowExecutionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getMaintenanceWindowExecutionRequest)
                        .withMarshaller(new GetMaintenanceWindowExecutionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves the details about a specific task executed as part of a Maintenance Window execution.
     * </p>
     *
     * @param getMaintenanceWindowExecutionTaskRequest
     * @return Result of the GetMaintenanceWindowExecutionTask operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource (e.g. a Maintenance Window) doesn't exist.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.GetMaintenanceWindowExecutionTask
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecutionTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetMaintenanceWindowExecutionTaskResponse getMaintenanceWindowExecutionTask(
            GetMaintenanceWindowExecutionTaskRequest getMaintenanceWindowExecutionTaskRequest) throws DoesNotExistException,
            InternalServerErrorException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<GetMaintenanceWindowExecutionTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetMaintenanceWindowExecutionTaskResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<GetMaintenanceWindowExecutionTaskRequest, GetMaintenanceWindowExecutionTaskResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getMaintenanceWindowExecutionTaskRequest)
                        .withMarshaller(new GetMaintenanceWindowExecutionTaskRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Get information about a parameter by using the parameter name.
     * </p>
     *
     * @param getParameterRequest
     * @return Result of the GetParameter operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidKeyIdException
     *         The query key ID is not valid.
     * @throws ParameterNotFoundException
     *         The parameter could not be found. Verify the name and try again.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.GetParameter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameter" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetParameterResponse getParameter(GetParameterRequest getParameterRequest) throws InternalServerErrorException,
            InvalidKeyIdException, ParameterNotFoundException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<GetParameterResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetParameterResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetParameterRequest, GetParameterResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getParameterRequest).withMarshaller(new GetParameterRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Query a list of all parameters used by the AWS account.
     * </p>
     *
     * @param getParameterHistoryRequest
     * @return Result of the GetParameterHistory operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ParameterNotFoundException
     *         The parameter could not be found. Verify the name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidKeyIdException
     *         The query key ID is not valid.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.GetParameterHistory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameterHistory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetParameterHistoryResponse getParameterHistory(GetParameterHistoryRequest getParameterHistoryRequest)
            throws InternalServerErrorException, ParameterNotFoundException, InvalidNextTokenException, InvalidKeyIdException,
            SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<GetParameterHistoryResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetParameterHistoryResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetParameterHistoryRequest, GetParameterHistoryResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getParameterHistoryRequest).withMarshaller(new GetParameterHistoryRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Get details of a parameter.
     * </p>
     *
     * @param getParametersRequest
     * @return Result of the GetParameters operation returned by the service.
     * @throws InvalidKeyIdException
     *         The query key ID is not valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.GetParameters
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameters" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetParametersResponse getParameters(GetParametersRequest getParametersRequest) throws InvalidKeyIdException,
            InternalServerErrorException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<GetParametersResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetParametersResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetParametersRequest, GetParametersResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getParametersRequest).withMarshaller(new GetParametersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieve parameters in a specific hierarchy. For more information, see <a
     * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-working-path.html">Using
     * Parameter Hierarchies</a>.
     * </p>
     *
     * @param getParametersByPathRequest
     * @return Result of the GetParametersByPath operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidFilterOptionException
     *         The specified filter option is not valid. Valid options are Equals and BeginsWith. For Path filter, valid
     *         options are Recursive and OneLevel.
     * @throws InvalidFilterValueException
     *         The filter value is not valid. Verify the value and try again.
     * @throws InvalidKeyIdException
     *         The query key ID is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.GetParametersByPath
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParametersByPath" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetParametersByPathResponse getParametersByPath(GetParametersByPathRequest getParametersByPathRequest)
            throws InternalServerErrorException, InvalidFilterKeyException, InvalidFilterOptionException,
            InvalidFilterValueException, InvalidKeyIdException, InvalidNextTokenException, SdkBaseException, SdkClientException,
            SSMException {

        HttpResponseHandler<GetParametersByPathResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetParametersByPathResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetParametersByPathRequest, GetParametersByPathResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getParametersByPathRequest).withMarshaller(new GetParametersByPathRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves information about a patch baseline.
     * </p>
     *
     * @param getPatchBaselineRequest
     * @return Result of the GetPatchBaseline operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource (e.g. a Maintenance Window) doesn't exist.
     * @throws InvalidResourceIdException
     *         The resource ID is not valid. Verify that you entered the correct ID and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.GetPatchBaseline
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetPatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetPatchBaselineResponse getPatchBaseline(GetPatchBaselineRequest getPatchBaselineRequest)
            throws DoesNotExistException, InvalidResourceIdException, InternalServerErrorException, SdkBaseException,
            SdkClientException, SSMException {

        HttpResponseHandler<GetPatchBaselineResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetPatchBaselineResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<GetPatchBaselineRequest, GetPatchBaselineResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(getPatchBaselineRequest).withMarshaller(new GetPatchBaselineRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves the patch baseline that should be used for the specified patch group.
     * </p>
     *
     * @param getPatchBaselineForPatchGroupRequest
     * @return Result of the GetPatchBaselineForPatchGroup operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.GetPatchBaselineForPatchGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetPatchBaselineForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetPatchBaselineForPatchGroupResponse getPatchBaselineForPatchGroup(
            GetPatchBaselineForPatchGroupRequest getPatchBaselineForPatchGroupRequest) throws InternalServerErrorException,
            SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<GetPatchBaselineForPatchGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new GetPatchBaselineForPatchGroupResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<GetPatchBaselineForPatchGroupRequest, GetPatchBaselineForPatchGroupResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(getPatchBaselineForPatchGroupRequest)
                        .withMarshaller(new GetPatchBaselineForPatchGroupRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists the associations for the specified Systems Manager document or instance.
     * </p>
     *
     * @param listAssociationsRequest
     * @return Result of the ListAssociations operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.ListAssociations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAssociationsResponse listAssociations(ListAssociationsRequest listAssociationsRequest)
            throws InternalServerErrorException, InvalidNextTokenException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<ListAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ListAssociationsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListAssociationsRequest, ListAssociationsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(listAssociationsRequest).withMarshaller(new ListAssociationsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * An invocation is copy of a command sent to a specific instance. A command can apply to one or more instances. A
     * command invocation applies to one instance. For example, if a user executes SendCommand against three instances,
     * then a command invocation is created for each requested instance ID. ListCommandInvocations provide status about
     * command execution.
     * </p>
     *
     * @param listCommandInvocationsRequest
     * @return Result of the ListCommandInvocations operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidCommandIdException
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.ListCommandInvocations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommandInvocations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListCommandInvocationsResponse listCommandInvocations(ListCommandInvocationsRequest listCommandInvocationsRequest)
            throws InternalServerErrorException, InvalidCommandIdException, InvalidInstanceIdException,
            InvalidFilterKeyException, InvalidNextTokenException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<ListCommandInvocationsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ListCommandInvocationsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListCommandInvocationsRequest, ListCommandInvocationsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(listCommandInvocationsRequest)
                .withMarshaller(new ListCommandInvocationsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists the commands requested by users of the AWS account.
     * </p>
     *
     * @param listCommandsRequest
     * @return Result of the ListCommands operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidCommandIdException
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.ListCommands
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommands" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListCommandsResponse listCommands(ListCommandsRequest listCommandsRequest) throws InternalServerErrorException,
            InvalidCommandIdException, InvalidInstanceIdException, InvalidFilterKeyException, InvalidNextTokenException,
            SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<ListCommandsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ListCommandsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListCommandsRequest, ListCommandsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(listCommandsRequest).withMarshaller(new ListCommandsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * List all versions for a document.
     * </p>
     *
     * @param listDocumentVersionsRequest
     * @return Result of the ListDocumentVersions operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.ListDocumentVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocumentVersions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDocumentVersionsResponse listDocumentVersions(ListDocumentVersionsRequest listDocumentVersionsRequest)
            throws InternalServerErrorException, InvalidNextTokenException, InvalidDocumentException, SdkBaseException,
            SdkClientException, SSMException {

        HttpResponseHandler<ListDocumentVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ListDocumentVersionsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListDocumentVersionsRequest, ListDocumentVersionsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(listDocumentVersionsRequest)
                .withMarshaller(new ListDocumentVersionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Describes one or more of your SSM documents.
     * </p>
     *
     * @param listDocumentsRequest
     * @return Result of the ListDocuments operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.ListDocuments
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocuments" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDocumentsResponse listDocuments(ListDocumentsRequest listDocumentsRequest) throws InternalServerErrorException,
            InvalidNextTokenException, InvalidFilterKeyException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<ListDocumentsResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ListDocumentsResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListDocumentsRequest, ListDocumentsResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(listDocumentsRequest).withMarshaller(new ListDocumentsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * A list of inventory items returned by the request.
     * </p>
     *
     * @param listInventoryEntriesRequest
     * @return Result of the ListInventoryEntries operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidTypeNameException
     *         The parameter type name is not valid.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.ListInventoryEntries
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListInventoryEntries" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListInventoryEntriesResponse listInventoryEntries(ListInventoryEntriesRequest listInventoryEntriesRequest)
            throws InternalServerErrorException, InvalidInstanceIdException, InvalidTypeNameException, InvalidFilterException,
            InvalidNextTokenException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<ListInventoryEntriesResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ListInventoryEntriesResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListInventoryEntriesRequest, ListInventoryEntriesResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(listInventoryEntriesRequest)
                .withMarshaller(new ListInventoryEntriesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns a list of the tags assigned to the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidResourceTypeException
     *         The resource type is not valid. If you are attempting to tag an instance, the instance must be a
     *         registered, managed instance.
     * @throws InvalidResourceIdException
     *         The resource ID is not valid. Verify that you entered the correct ID and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InvalidResourceTypeException, InvalidResourceIdException, InternalServerErrorException, SdkBaseException,
            SdkClientException, SSMException {

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ListTagsForResourceResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(listTagsForResourceRequest).withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Shares a Systems Manager document publicly or privately. If you share a document privately, you must specify the
     * AWS user account IDs for those people who can use the document. If you share a document publicly, you must
     * specify <i>All</i> as the account ID.
     * </p>
     *
     * @param modifyDocumentPermissionRequest
     * @return Result of the ModifyDocumentPermission operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidPermissionTypeException
     *         The permission type is not supported. <i>Share</i> is the only supported permission type.
     * @throws DocumentPermissionLimitException
     *         The document cannot be shared with more AWS user accounts. You can share a document with a maximum of 20
     *         accounts. You can publicly share up to five documents. If you need to increase this limit, contact AWS
     *         Support.
     * @throws DocumentLimitExceededException
     *         You can have at most 200 active SSM documents.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.ModifyDocumentPermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ModifyDocumentPermission" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ModifyDocumentPermissionResponse modifyDocumentPermission(
            ModifyDocumentPermissionRequest modifyDocumentPermissionRequest) throws InternalServerErrorException,
            InvalidDocumentException, InvalidPermissionTypeException, DocumentPermissionLimitException,
            DocumentLimitExceededException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<ModifyDocumentPermissionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new ModifyDocumentPermissionResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<ModifyDocumentPermissionRequest, ModifyDocumentPermissionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(modifyDocumentPermissionRequest)
                        .withMarshaller(new ModifyDocumentPermissionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Bulk update custom inventory items on one more instance. The request adds an inventory item, if it doesn't
     * already exist, or updates an inventory item, if it does exist.
     * </p>
     *
     * @param putInventoryRequest
     * @return Result of the PutInventory operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidTypeNameException
     *         The parameter type name is not valid.
     * @throws InvalidItemContentException
     *         One or more content items is not valid.
     * @throws TotalSizeLimitExceededException
     *         The size of inventory data has exceeded the total size limit for the resource.
     * @throws ItemSizeLimitExceededException
     *         The inventory item size has exceeded the size limit.
     * @throws ItemContentMismatchException
     *         The inventory item has invalid content.
     * @throws CustomSchemaCountLimitExceededException
     *         You have exceeded the limit for custom schemas. Delete one or more custom schemas and try again.
     * @throws UnsupportedInventorySchemaVersionException
     *         Inventory item type schema version has to match supported versions in the service. Check output of
     *         GetInventorySchema to see the available schema version for each type.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.PutInventory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutInventory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutInventoryResponse putInventory(PutInventoryRequest putInventoryRequest) throws InternalServerErrorException,
            InvalidInstanceIdException, InvalidTypeNameException, InvalidItemContentException, TotalSizeLimitExceededException,
            ItemSizeLimitExceededException, ItemContentMismatchException, CustomSchemaCountLimitExceededException,
            UnsupportedInventorySchemaVersionException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<PutInventoryResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new PutInventoryResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<PutInventoryRequest, PutInventoryResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(putInventoryRequest).withMarshaller(new PutInventoryRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Add one or more parameters to the system.
     * </p>
     *
     * @param putParameterRequest
     * @return Result of the PutParameter operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidKeyIdException
     *         The query key ID is not valid.
     * @throws ParameterLimitExceededException
     *         You have exceeded the number of parameters for this AWS account. Delete one or more parameters and try
     *         again.
     * @throws TooManyUpdatesException
     *         There are concurrent updates for a resource that supports one update at a time.
     * @throws ParameterAlreadyExistsException
     *         The parameter already exists. You can't create duplicate parameters.
     * @throws HierarchyLevelLimitExceededException
     *         A hierarchy can have a maximum of five levels. For example:</p>
     *         <p>
     *         /Finance/Prod/IAD/OS/WinServ2016/license15
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-working-path.html"
     *         >Develop a Parameter Hierarchy</a>.
     * @throws HierarchyTypeMismatchException
     *         Parameter Store does not support changing a parameter type in a hierarchy. For example, you can't change
     *         a parameter from a String type to a SecureString type. You must create a new, unique parameter.
     * @throws InvalidAllowedPatternException
     *         The request does not meet the regular expression requirement.
     * @throws ParameterPatternMismatchException
     *         The parameter name is not valid.
     * @throws UnsupportedParameterTypeException
     *         The parameter type is not supported.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.PutParameter
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutParameter" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutParameterResponse putParameter(PutParameterRequest putParameterRequest) throws InternalServerErrorException,
            InvalidKeyIdException, ParameterLimitExceededException, TooManyUpdatesException, ParameterAlreadyExistsException,
            HierarchyLevelLimitExceededException, HierarchyTypeMismatchException, InvalidAllowedPatternException,
            ParameterPatternMismatchException, UnsupportedParameterTypeException, SdkBaseException, SdkClientException,
            SSMException {

        HttpResponseHandler<PutParameterResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new PutParameterResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<PutParameterRequest, PutParameterResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(putParameterRequest).withMarshaller(new PutParameterRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Defines the default patch baseline.
     * </p>
     *
     * @param registerDefaultPatchBaselineRequest
     * @return Result of the RegisterDefaultPatchBaseline operation returned by the service.
     * @throws InvalidResourceIdException
     *         The resource ID is not valid. Verify that you entered the correct ID and try again.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource (e.g. a Maintenance Window) doesn't exist.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.RegisterDefaultPatchBaseline
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterDefaultPatchBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RegisterDefaultPatchBaselineResponse registerDefaultPatchBaseline(
            RegisterDefaultPatchBaselineRequest registerDefaultPatchBaselineRequest) throws InvalidResourceIdException,
            DoesNotExistException, InternalServerErrorException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<RegisterDefaultPatchBaselineResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new RegisterDefaultPatchBaselineResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<RegisterDefaultPatchBaselineRequest, RegisterDefaultPatchBaselineResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(registerDefaultPatchBaselineRequest)
                        .withMarshaller(new RegisterDefaultPatchBaselineRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Registers a patch baseline for a patch group.
     * </p>
     *
     * @param registerPatchBaselineForPatchGroupRequest
     * @return Result of the RegisterPatchBaselineForPatchGroup operation returned by the service.
     * @throws AlreadyExistsException
     *         Error returned if an attempt is made to register a patch group with a patch baseline that is already
     *         registered with a different patch baseline.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource (e.g. a Maintenance Window) doesn't exist.
     * @throws InvalidResourceIdException
     *         The resource ID is not valid. Verify that you entered the correct ID and try again.
     * @throws ResourceLimitExceededException
     *         Error returned when the caller has exceeded the default resource limits (e.g. too many Maintenance
     *         Windows have been created).
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.RegisterPatchBaselineForPatchGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterPatchBaselineForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RegisterPatchBaselineForPatchGroupResponse registerPatchBaselineForPatchGroup(
            RegisterPatchBaselineForPatchGroupRequest registerPatchBaselineForPatchGroupRequest) throws AlreadyExistsException,
            DoesNotExistException, InvalidResourceIdException, ResourceLimitExceededException, InternalServerErrorException,
            SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<RegisterPatchBaselineForPatchGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new RegisterPatchBaselineForPatchGroupResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<RegisterPatchBaselineForPatchGroupRequest, RegisterPatchBaselineForPatchGroupResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(registerPatchBaselineForPatchGroupRequest)
                        .withMarshaller(new RegisterPatchBaselineForPatchGroupRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Registers a target with a Maintenance Window.
     * </p>
     *
     * @param registerTargetWithMaintenanceWindowRequest
     * @return Result of the RegisterTargetWithMaintenanceWindow operation returned by the service.
     * @throws IdempotentParameterMismatchException
     *         Error returned when an idempotent operation is retried and the parameters don't match the original call
     *         to the API with the same idempotency token.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource (e.g. a Maintenance Window) doesn't exist.
     * @throws ResourceLimitExceededException
     *         Error returned when the caller has exceeded the default resource limits (e.g. too many Maintenance
     *         Windows have been created).
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.RegisterTargetWithMaintenanceWindow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterTargetWithMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RegisterTargetWithMaintenanceWindowResponse registerTargetWithMaintenanceWindow(
            RegisterTargetWithMaintenanceWindowRequest registerTargetWithMaintenanceWindowRequest)
            throws IdempotentParameterMismatchException, DoesNotExistException, ResourceLimitExceededException,
            InternalServerErrorException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<RegisterTargetWithMaintenanceWindowResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new RegisterTargetWithMaintenanceWindowResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<RegisterTargetWithMaintenanceWindowRequest, RegisterTargetWithMaintenanceWindowResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(registerTargetWithMaintenanceWindowRequest)
                        .withMarshaller(new RegisterTargetWithMaintenanceWindowRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Adds a new task to a Maintenance Window.
     * </p>
     *
     * @param registerTaskWithMaintenanceWindowRequest
     * @return Result of the RegisterTaskWithMaintenanceWindow operation returned by the service.
     * @throws IdempotentParameterMismatchException
     *         Error returned when an idempotent operation is retried and the parameters don't match the original call
     *         to the API with the same idempotency token.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource (e.g. a Maintenance Window) doesn't exist.
     * @throws ResourceLimitExceededException
     *         Error returned when the caller has exceeded the default resource limits (e.g. too many Maintenance
     *         Windows have been created).
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.RegisterTaskWithMaintenanceWindow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterTaskWithMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RegisterTaskWithMaintenanceWindowResponse registerTaskWithMaintenanceWindow(
            RegisterTaskWithMaintenanceWindowRequest registerTaskWithMaintenanceWindowRequest)
            throws IdempotentParameterMismatchException, DoesNotExistException, ResourceLimitExceededException,
            InternalServerErrorException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<RegisterTaskWithMaintenanceWindowResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new RegisterTaskWithMaintenanceWindowResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<RegisterTaskWithMaintenanceWindowRequest, RegisterTaskWithMaintenanceWindowResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(registerTaskWithMaintenanceWindowRequest)
                        .withMarshaller(new RegisterTaskWithMaintenanceWindowRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Removes all tags from the specified resource.
     * </p>
     *
     * @param removeTagsFromResourceRequest
     * @return Result of the RemoveTagsFromResource operation returned by the service.
     * @throws InvalidResourceTypeException
     *         The resource type is not valid. If you are attempting to tag an instance, the instance must be a
     *         registered, managed instance.
     * @throws InvalidResourceIdException
     *         The resource ID is not valid. Verify that you entered the correct ID and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.RemoveTagsFromResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RemoveTagsFromResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public RemoveTagsFromResourceResponse removeTagsFromResource(RemoveTagsFromResourceRequest removeTagsFromResourceRequest)
            throws InvalidResourceTypeException, InvalidResourceIdException, InternalServerErrorException, SdkBaseException,
            SdkClientException, SSMException {

        HttpResponseHandler<RemoveTagsFromResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new RemoveTagsFromResourceResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<RemoveTagsFromResourceRequest, RemoveTagsFromResourceResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(removeTagsFromResourceRequest)
                .withMarshaller(new RemoveTagsFromResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Executes commands on one or more managed instances.
     * </p>
     *
     * @param sendCommandRequest
     * @return Result of the SendCommand operation returned by the service.
     * @throws DuplicateInstanceIdException
     *         You cannot specify an instance ID in more than one association.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidOutputFolderException
     *         The S3 bucket does not exist.
     * @throws InvalidParametersException
     *         You must specify values for all required parameters in the SSM document. You can only supply values to
     *         parameters defined in the SSM document.
     * @throws UnsupportedPlatformTypeException
     *         The document does not support the platform type of the given instance ID(s). For example, you sent an
     *         document for a Windows instance to a Linux instance.
     * @throws MaxDocumentSizeExceededException
     *         The size limit of a document is 64 KB.
     * @throws InvalidRoleException
     *         The role name can't contain invalid characters. Also verify that you specified an IAM role for
     *         notifications that includes the required trust policy. For information about configuring the IAM role for
     *         Run Command notifications, see <a
     *         href="http://docs.aws.amazon.com/systems-manager/latest/userguide/rc-sns-notifications.html">Configuring
     *         Amazon SNS Notifications for Run Command</a> in the <i>Amazon EC2 Systems Manager User Guide</i>.
     * @throws InvalidNotificationConfigException
     *         One or more configuration items is not valid. Verify that a valid Amazon Resource Name (ARN) was provided
     *         for an Amazon SNS topic.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.SendCommand
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/SendCommand" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public SendCommandResponse sendCommand(SendCommandRequest sendCommandRequest) throws DuplicateInstanceIdException,
            InternalServerErrorException, InvalidInstanceIdException, InvalidDocumentException, InvalidOutputFolderException,
            InvalidParametersException, UnsupportedPlatformTypeException, MaxDocumentSizeExceededException, InvalidRoleException,
            InvalidNotificationConfigException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<SendCommandResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new SendCommandResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<SendCommandRequest, SendCommandResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(sendCommandRequest).withMarshaller(new SendCommandRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Initiates execution of an Automation document.
     * </p>
     *
     * @param startAutomationExecutionRequest
     * @return Result of the StartAutomationExecution operation returned by the service.
     * @throws AutomationDefinitionNotFoundException
     *         An Automation document with the specified name could not be found.
     * @throws InvalidAutomationExecutionParametersException
     *         The supplied parameters for invoking the specified Automation document are incorrect. For example, they
     *         may not match the set of parameters permitted for the specified Automation document.
     * @throws AutomationExecutionLimitExceededException
     *         The number of simultaneously running Automation executions exceeded the allowable limit.
     * @throws AutomationDefinitionVersionNotFoundException
     *         An Automation document with the specified name and version could not be found.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.StartAutomationExecution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartAutomationExecution" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StartAutomationExecutionResponse startAutomationExecution(
            StartAutomationExecutionRequest startAutomationExecutionRequest) throws AutomationDefinitionNotFoundException,
            InvalidAutomationExecutionParametersException, AutomationExecutionLimitExceededException,
            AutomationDefinitionVersionNotFoundException, InternalServerErrorException, SdkBaseException, SdkClientException,
            SSMException {

        HttpResponseHandler<StartAutomationExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new StartAutomationExecutionResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<StartAutomationExecutionRequest, StartAutomationExecutionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(startAutomationExecutionRequest)
                        .withMarshaller(new StartAutomationExecutionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Stop an Automation that is currently executing.
     * </p>
     *
     * @param stopAutomationExecutionRequest
     * @return Result of the StopAutomationExecution operation returned by the service.
     * @throws AutomationExecutionNotFoundException
     *         There is no automation execution information for the requested automation execution ID.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.StopAutomationExecution
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StopAutomationExecution" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StopAutomationExecutionResponse stopAutomationExecution(StopAutomationExecutionRequest stopAutomationExecutionRequest)
            throws AutomationExecutionNotFoundException, InternalServerErrorException, SdkBaseException, SdkClientException,
            SSMException {

        HttpResponseHandler<StopAutomationExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new StopAutomationExecutionResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<StopAutomationExecutionRequest, StopAutomationExecutionResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(stopAutomationExecutionRequest)
                .withMarshaller(new StopAutomationExecutionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates an association. You can only update the document version, schedule, parameters, and Amazon S3 output of
     * an association.
     * </p>
     *
     * @param updateAssociationRequest
     * @return Result of the UpdateAssociation operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidScheduleException
     *         The schedule is invalid. Verify your cron or rate expression and try again.
     * @throws InvalidParametersException
     *         You must specify values for all required parameters in the SSM document. You can only supply values to
     *         parameters defined in the SSM document.
     * @throws InvalidOutputLocationException
     *         The output location is not valid or does not exist.
     * @throws InvalidDocumentVersionException
     *         The document version is not valid or does not exist.
     * @throws AssociationDoesNotExistException
     *         The specified association does not exist.
     * @throws InvalidUpdateException
     *         The update is not valid.
     * @throws TooManyUpdatesException
     *         There are concurrent updates for a resource that supports one update at a time.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidTargetException
     *         The target is not valid or does not exist. It might not be configured for EC2 Systems Manager or you
     *         might not have permission to perform the operation.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.UpdateAssociation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateAssociationResponse updateAssociation(UpdateAssociationRequest updateAssociationRequest)
            throws InternalServerErrorException, InvalidScheduleException, InvalidParametersException,
            InvalidOutputLocationException, InvalidDocumentVersionException, AssociationDoesNotExistException,
            InvalidUpdateException, TooManyUpdatesException, InvalidDocumentException, InvalidTargetException, SdkBaseException,
            SdkClientException, SSMException {

        HttpResponseHandler<UpdateAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateAssociationResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateAssociationRequest, UpdateAssociationResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateAssociationRequest).withMarshaller(new UpdateAssociationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the status of the Systems Manager document associated with the specified instance.
     * </p>
     *
     * @param updateAssociationStatusRequest
     * @return Result of the UpdateAssociationStatus operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws AssociationDoesNotExistException
     *         The specified association does not exist.
     * @throws StatusUnchangedException
     *         The updated status is the same as the current status.
     * @throws TooManyUpdatesException
     *         There are concurrent updates for a resource that supports one update at a time.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.UpdateAssociationStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateAssociationStatus" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateAssociationStatusResponse updateAssociationStatus(UpdateAssociationStatusRequest updateAssociationStatusRequest)
            throws InternalServerErrorException, InvalidInstanceIdException, InvalidDocumentException,
            AssociationDoesNotExistException, StatusUnchangedException, TooManyUpdatesException, SdkBaseException,
            SdkClientException, SSMException {

        HttpResponseHandler<UpdateAssociationStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateAssociationStatusResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateAssociationStatusRequest, UpdateAssociationStatusResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateAssociationStatusRequest)
                .withMarshaller(new UpdateAssociationStatusRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * The document you want to update.
     * </p>
     *
     * @param updateDocumentRequest
     * @return Result of the UpdateDocument operation returned by the service.
     * @throws MaxDocumentSizeExceededException
     *         The size limit of a document is 64 KB.
     * @throws DocumentVersionLimitExceededException
     *         The document has too many versions. Delete one or more document versions and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws DuplicateDocumentContentException
     *         The content of the association document matches another document. Change the content of the document and
     *         try again.
     * @throws InvalidDocumentContentException
     *         The content for the document is not valid.
     * @throws InvalidDocumentVersionException
     *         The document version is not valid or does not exist.
     * @throws InvalidDocumentSchemaVersionException
     *         The version of the document schema is not supported.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.UpdateDocument
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateDocument" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateDocumentResponse updateDocument(UpdateDocumentRequest updateDocumentRequest)
            throws MaxDocumentSizeExceededException, DocumentVersionLimitExceededException, InternalServerErrorException,
            DuplicateDocumentContentException, InvalidDocumentContentException, InvalidDocumentVersionException,
            InvalidDocumentSchemaVersionException, InvalidDocumentException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<UpdateDocumentResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateDocumentResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateDocumentRequest, UpdateDocumentResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateDocumentRequest).withMarshaller(new UpdateDocumentRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Set the default version of a document.
     * </p>
     *
     * @param updateDocumentDefaultVersionRequest
     * @return Result of the UpdateDocumentDefaultVersion operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidDocumentVersionException
     *         The document version is not valid or does not exist.
     * @throws InvalidDocumentSchemaVersionException
     *         The version of the document schema is not supported.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.UpdateDocumentDefaultVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateDocumentDefaultVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateDocumentDefaultVersionResponse updateDocumentDefaultVersion(
            UpdateDocumentDefaultVersionRequest updateDocumentDefaultVersionRequest) throws InternalServerErrorException,
            InvalidDocumentException, InvalidDocumentVersionException, InvalidDocumentSchemaVersionException, SdkBaseException,
            SdkClientException, SSMException {

        HttpResponseHandler<UpdateDocumentDefaultVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateDocumentDefaultVersionResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<UpdateDocumentDefaultVersionRequest, UpdateDocumentDefaultVersionResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(updateDocumentDefaultVersionRequest)
                        .withMarshaller(new UpdateDocumentDefaultVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates an existing Maintenance Window. Only specified parameters are modified.
     * </p>
     *
     * @param updateMaintenanceWindowRequest
     * @return Result of the UpdateMaintenanceWindow operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource (e.g. a Maintenance Window) doesn't exist.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.UpdateMaintenanceWindow
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateMaintenanceWindow" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateMaintenanceWindowResponse updateMaintenanceWindow(UpdateMaintenanceWindowRequest updateMaintenanceWindowRequest)
            throws DoesNotExistException, InternalServerErrorException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<UpdateMaintenanceWindowResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateMaintenanceWindowResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdateMaintenanceWindowRequest, UpdateMaintenanceWindowResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updateMaintenanceWindowRequest)
                .withMarshaller(new UpdateMaintenanceWindowRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Assigns or changes an Amazon Identity and Access Management (IAM) role to the managed instance.
     * </p>
     *
     * @param updateManagedInstanceRoleRequest
     * @return Result of the UpdateManagedInstanceRole operation returned by the service.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         The SSM Agent is not running. On managed instances and Linux instances, verify that the SSM Agent is
     *         running. On EC2 Windows instances, verify that the EC2Config service is running.
     *         </p>
     *         <p>
     *         The SSM Agent or EC2Config service is not registered to the SSM endpoint. Try reinstalling the SSM Agent
     *         or EC2Config service.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.UpdateManagedInstanceRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateManagedInstanceRole" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateManagedInstanceRoleResponse updateManagedInstanceRole(
            UpdateManagedInstanceRoleRequest updateManagedInstanceRoleRequest) throws InvalidInstanceIdException,
            InternalServerErrorException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<UpdateManagedInstanceRoleResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdateManagedInstanceRoleResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler
                .execute(new ClientExecutionParams<UpdateManagedInstanceRoleRequest, UpdateManagedInstanceRoleResponse>()
                        .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                        .withInput(updateManagedInstanceRoleRequest)
                        .withMarshaller(new UpdateManagedInstanceRoleRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Modifies an existing patch baseline. Fields not specified in the request are left unchanged.
     * </p>
     *
     * @param updatePatchBaselineRequest
     * @return Result of the UpdatePatchBaseline operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource (e.g. a Maintenance Window) doesn't exist.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SSMException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SSMClient.UpdatePatchBaseline
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdatePatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdatePatchBaselineResponse updatePatchBaseline(UpdatePatchBaselineRequest updatePatchBaselineRequest)
            throws DoesNotExistException, InternalServerErrorException, SdkBaseException, SdkClientException, SSMException {

        HttpResponseHandler<UpdatePatchBaselineResponse> responseHandler = protocolFactory.createResponseHandler(
                new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false),
                new UpdatePatchBaselineResponseUnmarshaller());

        HttpResponseHandler<AmazonServiceException> errorResponseHandler = createErrorResponseHandler();

        return clientHandler.execute(new ClientExecutionParams<UpdatePatchBaselineRequest, UpdatePatchBaselineResponse>()
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                .withInput(updatePatchBaselineRequest).withMarshaller(new UpdatePatchBaselineRequestMarshaller(protocolFactory)));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata()
                .withProtocolVersion("1.1")
                .withSupportsCbor(false)
                .withSupportsIon(false)
                .withBaseServiceExceptionClass(software.amazon.awssdk.services.ssm.model.SSMException.class)
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("TooManyTagsError").withModeledClass(
                                TooManyTagsErrorException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ItemSizeLimitExceededException").withModeledClass(
                                ItemSizeLimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidParameters").withModeledClass(
                                InvalidParametersException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidKeyId").withModeledClass(InvalidKeyIdException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("UnsupportedParameterType").withModeledClass(
                                UnsupportedParameterTypeException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidFilter")
                                .withModeledClass(InvalidFilterException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidSchedule").withModeledClass(
                                InvalidScheduleException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("UnsupportedInventorySchemaVersionException")
                                .withModeledClass(UnsupportedInventorySchemaVersionException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidUpdate")
                                .withModeledClass(InvalidUpdateException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidPluginName").withModeledClass(
                                InvalidPluginNameException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("HierarchyTypeMismatchException").withModeledClass(
                                HierarchyTypeMismatchException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidNextToken").withModeledClass(
                                InvalidNextTokenException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("AssociationAlreadyExists").withModeledClass(
                                AssociationAlreadyExistsException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DuplicateDocumentContent").withModeledClass(
                                DuplicateDocumentContentException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidDocumentSchemaVersion").withModeledClass(
                                InvalidDocumentSchemaVersionException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidActivationId").withModeledClass(
                                InvalidActivationIdException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvocationDoesNotExist").withModeledClass(
                                InvocationDoesNotExistException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("AlreadyExistsException").withModeledClass(
                                AlreadyExistsException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("IdempotentParameterMismatch").withModeledClass(
                                IdempotentParameterMismatchException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidResultAttributeException").withModeledClass(
                                InvalidResultAttributeException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("AutomationDefinitionVersionNotFoundException")
                                .withModeledClass(AutomationDefinitionVersionNotFoundException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidAutomationExecutionParametersException")
                                .withModeledClass(InvalidAutomationExecutionParametersException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidResourceId").withModeledClass(
                                InvalidResourceIdException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ResourceLimitExceededException").withModeledClass(
                                ResourceLimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidAllowedPatternException").withModeledClass(
                                InvalidAllowedPatternException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidPermissionType").withModeledClass(
                                InvalidPermissionTypeException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ResourceInUseException").withModeledClass(
                                ResourceInUseException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidDocument").withModeledClass(
                                InvalidDocumentException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidDocumentVersion").withModeledClass(
                                InvalidDocumentVersionException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidOutputFolder").withModeledClass(
                                InvalidOutputFolderException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidDocumentOperation").withModeledClass(
                                InvalidDocumentOperationException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("AutomationExecutionLimitExceededException").withModeledClass(
                                AutomationExecutionLimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidResourceType").withModeledClass(
                                InvalidResourceTypeException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidNotificationConfig").withModeledClass(
                                InvalidNotificationConfigException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidCommandId").withModeledClass(
                                InvalidCommandIdException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ParameterNotFound").withModeledClass(
                                ParameterNotFoundException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DocumentPermissionLimit").withModeledClass(
                                DocumentPermissionLimitException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DocumentLimitExceeded").withModeledClass(
                                DocumentLimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("HierarchyLevelLimitExceededException").withModeledClass(
                                HierarchyLevelLimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("AutomationDefinitionNotFoundException").withModeledClass(
                                AutomationDefinitionNotFoundException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidInstanceId").withModeledClass(
                                InvalidInstanceIdException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("TotalSizeLimitExceededException").withModeledClass(
                                TotalSizeLimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ItemContentMismatchException").withModeledClass(
                                ItemContentMismatchException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidActivation").withModeledClass(
                                InvalidActivationException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DuplicateInstanceId").withModeledClass(
                                DuplicateInstanceIdException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("TooManyUpdates").withModeledClass(
                                TooManyUpdatesException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DocumentAlreadyExists").withModeledClass(
                                DocumentAlreadyExistsException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidDocumentContent").withModeledClass(
                                InvalidDocumentContentException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("AutomationExecutionNotFoundException").withModeledClass(
                                AutomationExecutionNotFoundException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidInstanceInformationFilterValue").withModeledClass(
                                InvalidInstanceInformationFilterValueException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("AssociationLimitExceeded").withModeledClass(
                                AssociationLimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("StatusUnchanged").withModeledClass(
                                StatusUnchangedException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("AssociationDoesNotExist").withModeledClass(
                                AssociationDoesNotExistException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidTarget")
                                .withModeledClass(InvalidTargetException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("UnsupportedPlatformType").withModeledClass(
                                UnsupportedPlatformTypeException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("MaxDocumentSizeExceeded").withModeledClass(
                                MaxDocumentSizeExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidRole").withModeledClass(InvalidRoleException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("AssociatedInstances").withModeledClass(
                                AssociatedInstancesException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidOutputLocation").withModeledClass(
                                InvalidOutputLocationException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ParameterLimitExceeded").withModeledClass(
                                ParameterLimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidFilterValue").withModeledClass(
                                InvalidFilterValueException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DocumentVersionLimitExceeded").withModeledClass(
                                DocumentVersionLimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidTypeNameException").withModeledClass(
                                InvalidTypeNameException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("DoesNotExistException").withModeledClass(
                                DoesNotExistException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidFilterOption").withModeledClass(
                                InvalidFilterOptionException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("CustomSchemaCountLimitExceededException").withModeledClass(
                                CustomSchemaCountLimitExceededException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ParameterPatternMismatchException").withModeledClass(
                                ParameterPatternMismatchException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("ParameterAlreadyExists").withModeledClass(
                                ParameterAlreadyExistsException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidFilterKey").withModeledClass(
                                InvalidFilterKeyException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InternalServerError").withModeledClass(
                                InternalServerErrorException.class))
                .addErrorMetadata(
                        new JsonErrorShapeMetadata().withErrorCode("InvalidItemContentException").withModeledClass(
                                InvalidItemContentException.class)));
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
