/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteParametersResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DeleteParametersResponse.Builder, DeleteParametersResponse> {
    private final List<String> deletedParameters;

    private final List<String> invalidParameters;

    private DeleteParametersResponse(BuilderImpl builder) {
        this.deletedParameters = builder.deletedParameters;
        this.invalidParameters = builder.invalidParameters;
    }

    /**
     * <p>
     * The names of the deleted parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The names of the deleted parameters.
     */
    public List<String> deletedParameters() {
        return deletedParameters;
    }

    /**
     * <p>
     * The names of parameters that weren't deleted because the parameters are not valid.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The names of parameters that weren't deleted because the parameters are not valid.
     */
    public List<String> invalidParameters() {
        return invalidParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deletedParameters() == null) ? 0 : deletedParameters().hashCode());
        hashCode = 31 * hashCode + ((invalidParameters() == null) ? 0 : invalidParameters().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteParametersResponse)) {
            return false;
        }
        DeleteParametersResponse other = (DeleteParametersResponse) obj;
        if (other.deletedParameters() == null ^ this.deletedParameters() == null) {
            return false;
        }
        if (other.deletedParameters() != null && !other.deletedParameters().equals(this.deletedParameters())) {
            return false;
        }
        if (other.invalidParameters() == null ^ this.invalidParameters() == null) {
            return false;
        }
        if (other.invalidParameters() != null && !other.invalidParameters().equals(this.invalidParameters())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deletedParameters() != null) {
            sb.append("DeletedParameters: ").append(deletedParameters()).append(",");
        }
        if (invalidParameters() != null) {
            sb.append("InvalidParameters: ").append(invalidParameters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteParametersResponse> {
        /**
         * <p>
         * The names of the deleted parameters.
         * </p>
         * 
         * @param deletedParameters
         *        The names of the deleted parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletedParameters(Collection<String> deletedParameters);

        /**
         * <p>
         * The names of the deleted parameters.
         * </p>
         * 
         * @param deletedParameters
         *        The names of the deleted parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletedParameters(String... deletedParameters);

        /**
         * <p>
         * The names of parameters that weren't deleted because the parameters are not valid.
         * </p>
         * 
         * @param invalidParameters
         *        The names of parameters that weren't deleted because the parameters are not valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidParameters(Collection<String> invalidParameters);

        /**
         * <p>
         * The names of parameters that weren't deleted because the parameters are not valid.
         * </p>
         * 
         * @param invalidParameters
         *        The names of parameters that weren't deleted because the parameters are not valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidParameters(String... invalidParameters);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> deletedParameters;

        private List<String> invalidParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteParametersResponse model) {
            setDeletedParameters(model.deletedParameters);
            setInvalidParameters(model.invalidParameters);
        }

        public final Collection<String> getDeletedParameters() {
            return deletedParameters;
        }

        @Override
        public final Builder deletedParameters(Collection<String> deletedParameters) {
            this.deletedParameters = ParameterNameListCopier.copy(deletedParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deletedParameters(String... deletedParameters) {
            deletedParameters(Arrays.asList(deletedParameters));
            return this;
        }

        public final void setDeletedParameters(Collection<String> deletedParameters) {
            this.deletedParameters = ParameterNameListCopier.copy(deletedParameters);
        }

        public final Collection<String> getInvalidParameters() {
            return invalidParameters;
        }

        @Override
        public final Builder invalidParameters(Collection<String> invalidParameters) {
            this.invalidParameters = ParameterNameListCopier.copy(invalidParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidParameters(String... invalidParameters) {
            invalidParameters(Arrays.asList(invalidParameters));
            return this;
        }

        public final void setInvalidParameters(Collection<String> invalidParameters) {
            this.invalidParameters = ParameterNameListCopier.copy(invalidParameters);
        }

        @Override
        public DeleteParametersResponse build() {
            return new DeleteParametersResponse(this);
        }
    }
}
