/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeParametersRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeParametersRequest.Builder, DescribeParametersRequest> {
    private final List<ParametersFilter> filters;

    private final List<ParameterStringFilter> parameterFilters;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeParametersRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.parameterFilters = builder.parameterFilters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * One or more filters. Use a filter to return a more specific list of results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters. Use a filter to return a more specific list of results.
     */
    public List<ParametersFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * Filters to limit the request results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Filters to limit the request results.
     */
    public List<ParameterStringFilter> parameterFilters() {
        return parameterFilters;
    }

    /**
     * <p>
     * The maximum number of items to return for this call. The call also returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     * 
     * @return The maximum number of items to return for this call. The call also returns a token that you can specify
     *         in a subsequent call to get the next set of results.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filters() == null) ? 0 : filters().hashCode());
        hashCode = 31 * hashCode + ((parameterFilters() == null) ? 0 : parameterFilters().hashCode());
        hashCode = 31 * hashCode + ((maxResults() == null) ? 0 : maxResults().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeParametersRequest)) {
            return false;
        }
        DescribeParametersRequest other = (DescribeParametersRequest) obj;
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.parameterFilters() == null ^ this.parameterFilters() == null) {
            return false;
        }
        if (other.parameterFilters() != null && !other.parameterFilters().equals(this.parameterFilters())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (parameterFilters() != null) {
            sb.append("ParameterFilters: ").append(parameterFilters()).append(",");
        }
        if (maxResults() != null) {
            sb.append("MaxResults: ").append(maxResults()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeParametersRequest> {
        /**
         * <p>
         * One or more filters. Use a filter to return a more specific list of results.
         * </p>
         * 
         * @param filters
         *        One or more filters. Use a filter to return a more specific list of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<ParametersFilter> filters);

        /**
         * <p>
         * One or more filters. Use a filter to return a more specific list of results.
         * </p>
         * 
         * @param filters
         *        One or more filters. Use a filter to return a more specific list of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ParametersFilter... filters);

        /**
         * <p>
         * Filters to limit the request results.
         * </p>
         * 
         * @param parameterFilters
         *        Filters to limit the request results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterFilters(Collection<ParameterStringFilter> parameterFilters);

        /**
         * <p>
         * Filters to limit the request results.
         * </p>
         * 
         * @param parameterFilters
         *        Filters to limit the request results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterFilters(ParameterStringFilter... parameterFilters);

        /**
         * <p>
         * The maximum number of items to return for this call. The call also returns a token that you can specify in a
         * subsequent call to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this call. The call also returns a token that you can
         *        specify in a subsequent call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<ParametersFilter> filters;

        private List<ParameterStringFilter> parameterFilters;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeParametersRequest model) {
            setFilters(model.filters);
            setParameterFilters(model.parameterFilters);
            setMaxResults(model.maxResults);
            setNextToken(model.nextToken);
        }

        public final Collection<ParametersFilter> getFilters() {
            return filters;
        }

        @Override
        public final Builder filters(Collection<ParametersFilter> filters) {
            this.filters = ParametersFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ParametersFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<ParametersFilter> filters) {
            this.filters = ParametersFilterListCopier.copy(filters);
        }

        public final Collection<ParameterStringFilter> getParameterFilters() {
            return parameterFilters;
        }

        @Override
        public final Builder parameterFilters(Collection<ParameterStringFilter> parameterFilters) {
            this.parameterFilters = ParameterStringFilterListCopier.copy(parameterFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterFilters(ParameterStringFilter... parameterFilters) {
            parameterFilters(Arrays.asList(parameterFilters));
            return this;
        }

        public final void setParameterFilters(Collection<ParameterStringFilter> parameterFilters) {
            this.parameterFilters = ParameterStringFilterListCopier.copy(parameterFilters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeParametersRequest build() {
            return new DescribeParametersRequest(this);
        }
    }
}
