/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.FailedCreateAssociationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a failed association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class FailedCreateAssociation implements StructuredPojo,
        ToCopyableBuilder<FailedCreateAssociation.Builder, FailedCreateAssociation> {
    private final CreateAssociationBatchRequestEntry entry;

    private final String message;

    private final String fault;

    private FailedCreateAssociation(BuilderImpl builder) {
        this.entry = builder.entry;
        this.message = builder.message;
        this.fault = builder.fault;
    }

    /**
     * <p>
     * The association.
     * </p>
     * 
     * @return The association.
     */
    public CreateAssociationBatchRequestEntry entry() {
        return entry;
    }

    /**
     * <p>
     * A description of the failure.
     * </p>
     * 
     * @return A description of the failure.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * The source of the failure.
     * </p>
     * 
     * @return The source of the failure.
     * @see Fault
     */
    public String fault() {
        return fault;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((entry() == null) ? 0 : entry().hashCode());
        hashCode = 31 * hashCode + ((message() == null) ? 0 : message().hashCode());
        hashCode = 31 * hashCode + ((fault() == null) ? 0 : fault().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedCreateAssociation)) {
            return false;
        }
        FailedCreateAssociation other = (FailedCreateAssociation) obj;
        if (other.entry() == null ^ this.entry() == null) {
            return false;
        }
        if (other.entry() != null && !other.entry().equals(this.entry())) {
            return false;
        }
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        if (other.fault() == null ^ this.fault() == null) {
            return false;
        }
        if (other.fault() != null && !other.fault().equals(this.fault())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (entry() != null) {
            sb.append("Entry: ").append(entry()).append(",");
        }
        if (message() != null) {
            sb.append("Message: ").append(message()).append(",");
        }
        if (fault() != null) {
            sb.append("Fault: ").append(fault()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FailedCreateAssociationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, FailedCreateAssociation> {
        /**
         * <p>
         * The association.
         * </p>
         * 
         * @param entry
         *        The association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entry(CreateAssociationBatchRequestEntry entry);

        /**
         * <p>
         * A description of the failure.
         * </p>
         * 
         * @param message
         *        A description of the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The source of the failure.
         * </p>
         * 
         * @param fault
         *        The source of the failure.
         * @see Fault
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Fault
         */
        Builder fault(String fault);

        /**
         * <p>
         * The source of the failure.
         * </p>
         * 
         * @param fault
         *        The source of the failure.
         * @see Fault
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Fault
         */
        Builder fault(Fault fault);
    }

    private static final class BuilderImpl implements Builder {
        private CreateAssociationBatchRequestEntry entry;

        private String message;

        private String fault;

        private BuilderImpl() {
        }

        private BuilderImpl(FailedCreateAssociation model) {
            setEntry(model.entry);
            setMessage(model.message);
            setFault(model.fault);
        }

        public final CreateAssociationBatchRequestEntry getEntry() {
            return entry;
        }

        @Override
        public final Builder entry(CreateAssociationBatchRequestEntry entry) {
            this.entry = entry;
            return this;
        }

        public final void setEntry(CreateAssociationBatchRequestEntry entry) {
            this.entry = entry;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getFault() {
            return fault;
        }

        @Override
        public final Builder fault(String fault) {
            this.fault = fault;
            return this;
        }

        @Override
        public final Builder fault(Fault fault) {
            this.fault(fault.toString());
            return this;
        }

        public final void setFault(String fault) {
            this.fault = fault;
        }

        @Override
        public FailedCreateAssociation build() {
            return new FailedCreateAssociation(this);
        }
    }
}
