/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetCommandInvocationResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetCommandInvocationResponse.Builder, GetCommandInvocationResponse> {
    private final String commandId;

    private final String instanceId;

    private final String comment;

    private final String documentName;

    private final String pluginName;

    private final Integer responseCode;

    private final String executionStartDateTime;

    private final String executionElapsedTime;

    private final String executionEndDateTime;

    private final String status;

    private final String statusDetails;

    private final String standardOutputContent;

    private final String standardOutputUrl;

    private final String standardErrorContent;

    private final String standardErrorUrl;

    private GetCommandInvocationResponse(BuilderImpl builder) {
        this.commandId = builder.commandId;
        this.instanceId = builder.instanceId;
        this.comment = builder.comment;
        this.documentName = builder.documentName;
        this.pluginName = builder.pluginName;
        this.responseCode = builder.responseCode;
        this.executionStartDateTime = builder.executionStartDateTime;
        this.executionElapsedTime = builder.executionElapsedTime;
        this.executionEndDateTime = builder.executionEndDateTime;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.standardOutputContent = builder.standardOutputContent;
        this.standardOutputUrl = builder.standardOutputUrl;
        this.standardErrorContent = builder.standardErrorContent;
        this.standardErrorUrl = builder.standardErrorUrl;
    }

    /**
     * <p>
     * The parent command ID of the invocation plugin.
     * </p>
     * 
     * @return The parent command ID of the invocation plugin.
     */
    public String commandId() {
        return commandId;
    }

    /**
     * <p>
     * The ID of the managed instance targeted by the command. A managed instance can be an Amazon EC2 instance or an
     * instance in your hybrid environment that is configured for Systems Manager.
     * </p>
     * 
     * @return The ID of the managed instance targeted by the command. A managed instance can be an Amazon EC2 instance
     *         or an instance in your hybrid environment that is configured for Systems Manager.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The comment text for the command.
     * </p>
     * 
     * @return The comment text for the command.
     */
    public String comment() {
        return comment;
    }

    /**
     * <p>
     * The name of the document that was executed. For example, AWS-RunShellScript.
     * </p>
     * 
     * @return The name of the document that was executed. For example, AWS-RunShellScript.
     */
    public String documentName() {
        return documentName;
    }

    /**
     * <p>
     * The name of the plugin for which you want detailed results. For example, aws:RunShellScript is a plugin.
     * </p>
     * 
     * @return The name of the plugin for which you want detailed results. For example, aws:RunShellScript is a plugin.
     */
    public String pluginName() {
        return pluginName;
    }

    /**
     * <p>
     * The error level response code for the plugin script. If the response code is -1, then the command has not started
     * executing on the instance, or it was not received by the instance.
     * </p>
     * 
     * @return The error level response code for the plugin script. If the response code is -1, then the command has not
     *         started executing on the instance, or it was not received by the instance.
     */
    public Integer responseCode() {
        return responseCode;
    }

    /**
     * <p>
     * The date and time the plugin started executing. Date and time are written in ISO 8601 format. For example, June
     * 7, 2017 is represented as 2017-06-7. The following sample AWS CLI command uses the <code>InvokedBefore</code>
     * filter.
     * </p>
     * <p>
     * <code>aws ssm list-commands --filters key=InvokedBefore,value=2017-06-07T00:00:00Z</code>
     * </p>
     * <p>
     * If the plugin has not started to execute, the string is empty.
     * </p>
     * 
     * @return The date and time the plugin started executing. Date and time are written in ISO 8601 format. For
     *         example, June 7, 2017 is represented as 2017-06-7. The following sample AWS CLI command uses the
     *         <code>InvokedBefore</code> filter.</p>
     *         <p>
     *         <code>aws ssm list-commands --filters key=InvokedBefore,value=2017-06-07T00:00:00Z</code>
     *         </p>
     *         <p>
     *         If the plugin has not started to execute, the string is empty.
     */
    public String executionStartDateTime() {
        return executionStartDateTime;
    }

    /**
     * <p>
     * Duration since ExecutionStartDateTime.
     * </p>
     * 
     * @return Duration since ExecutionStartDateTime.
     */
    public String executionElapsedTime() {
        return executionElapsedTime;
    }

    /**
     * <p>
     * The date and time the plugin was finished executing. Date and time are written in ISO 8601 format. For example,
     * June 7, 2017 is represented as 2017-06-7. The following sample AWS CLI command uses the <code>InvokedAfter</code>
     * filter.
     * </p>
     * <p>
     * <code>aws ssm list-commands --filters key=InvokedAfter,value=2017-06-07T00:00:00Z</code>
     * </p>
     * <p>
     * If the plugin has not started to execute, the string is empty.
     * </p>
     * 
     * @return The date and time the plugin was finished executing. Date and time are written in ISO 8601 format. For
     *         example, June 7, 2017 is represented as 2017-06-7. The following sample AWS CLI command uses the
     *         <code>InvokedAfter</code> filter.</p>
     *         <p>
     *         <code>aws ssm list-commands --filters key=InvokedAfter,value=2017-06-07T00:00:00Z</code>
     *         </p>
     *         <p>
     *         If the plugin has not started to execute, the string is empty.
     */
    public String executionEndDateTime() {
        return executionEndDateTime;
    }

    /**
     * <p>
     * The status of the parent command for this invocation. This status can be different than StatusDetails.
     * </p>
     * 
     * @return The status of the parent command for this invocation. This status can be different than StatusDetails.
     * @see CommandInvocationStatus
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * A detailed status of the command execution for an invocation. StatusDetails includes more information than Status
     * because it includes states resulting from error and concurrency control parameters. StatusDetails can show
     * different results than Status. For more information about these statuses, see <a
     * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-about-status.html">Run Command
     * Status</a>. StatusDetails can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Pending: The command has not been sent to the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * In Progress: The command has been sent to the instance but has not reached a terminal state.
     * </p>
     * </li>
     * <li>
     * <p>
     * Delayed: The system attempted to send the command to the target, but the target was not available. The instance
     * might not be available because of network issues, the instance was stopped, etc. The system will try to deliver
     * the command again.
     * </p>
     * </li>
     * <li>
     * <p>
     * Success: The command or plugin was executed successfully. This is a terminal state.
     * </p>
     * </li>
     * <li>
     * <p>
     * Delivery Timed Out: The command was not delivered to the instance before the delivery timeout expired. Delivery
     * timeouts do not count against the parent command's MaxErrors limit, but they do contribute to whether the parent
     * command status is Success or Incomplete. This is a terminal state.
     * </p>
     * </li>
     * <li>
     * <p>
     * Execution Timed Out: The command started to execute on the instance, but the execution was not complete before
     * the timeout expired. Execution timeouts count against the MaxErrors limit of the parent command. This is a
     * terminal state.
     * </p>
     * </li>
     * <li>
     * <p>
     * Failed: The command wasn't executed successfully on the instance. For a plugin, this indicates that the result
     * code was not zero. For a command invocation, this indicates that the result code for one or more plugins was not
     * zero. Invocation failures count against the MaxErrors limit of the parent command. This is a terminal state.
     * </p>
     * </li>
     * <li>
     * <p>
     * Canceled: The command was terminated before it was completed. This is a terminal state.
     * </p>
     * </li>
     * <li>
     * <p>
     * Undeliverable: The command can't be delivered to the instance. The instance might not exist or might not be
     * responding. Undeliverable invocations don't count against the parent command's MaxErrors limit and don't
     * contribute to whether the parent command status is Success or Incomplete. This is a terminal state.
     * </p>
     * </li>
     * <li>
     * <p>
     * Terminated: The parent command exceeded its MaxErrors limit and subsequent command invocations were canceled by
     * the system. This is a terminal state.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A detailed status of the command execution for an invocation. StatusDetails includes more information
     *         than Status because it includes states resulting from error and concurrency control parameters.
     *         StatusDetails can show different results than Status. For more information about these statuses, see <a
     *         href="http://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-about-status.html">Run Command
     *         Status</a>. StatusDetails can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Pending: The command has not been sent to the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In Progress: The command has been sent to the instance but has not reached a terminal state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Delayed: The system attempted to send the command to the target, but the target was not available. The
     *         instance might not be available because of network issues, the instance was stopped, etc. The system will
     *         try to deliver the command again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Success: The command or plugin was executed successfully. This is a terminal state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Delivery Timed Out: The command was not delivered to the instance before the delivery timeout expired.
     *         Delivery timeouts do not count against the parent command's MaxErrors limit, but they do contribute to
     *         whether the parent command status is Success or Incomplete. This is a terminal state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Execution Timed Out: The command started to execute on the instance, but the execution was not complete
     *         before the timeout expired. Execution timeouts count against the MaxErrors limit of the parent command.
     *         This is a terminal state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failed: The command wasn't executed successfully on the instance. For a plugin, this indicates that the
     *         result code was not zero. For a command invocation, this indicates that the result code for one or more
     *         plugins was not zero. Invocation failures count against the MaxErrors limit of the parent command. This
     *         is a terminal state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Canceled: The command was terminated before it was completed. This is a terminal state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Undeliverable: The command can't be delivered to the instance. The instance might not exist or might not
     *         be responding. Undeliverable invocations don't count against the parent command's MaxErrors limit and
     *         don't contribute to whether the parent command status is Success or Incomplete. This is a terminal state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Terminated: The parent command exceeded its MaxErrors limit and subsequent command invocations were
     *         canceled by the system. This is a terminal state.
     *         </p>
     *         </li>
     */
    public String statusDetails() {
        return statusDetails;
    }

    /**
     * <p>
     * The first 24,000 characters written by the plugin to stdout. If the command has not finished executing, if
     * ExecutionStatus is neither Succeeded nor Failed, then this string is empty.
     * </p>
     * 
     * @return The first 24,000 characters written by the plugin to stdout. If the command has not finished executing,
     *         if ExecutionStatus is neither Succeeded nor Failed, then this string is empty.
     */
    public String standardOutputContent() {
        return standardOutputContent;
    }

    /**
     * <p>
     * The URL for the complete text written by the plugin to stdout in Amazon S3. If an Amazon S3 bucket was not
     * specified, then this string is empty.
     * </p>
     * 
     * @return The URL for the complete text written by the plugin to stdout in Amazon S3. If an Amazon S3 bucket was
     *         not specified, then this string is empty.
     */
    public String standardOutputUrl() {
        return standardOutputUrl;
    }

    /**
     * <p>
     * The first 8,000 characters written by the plugin to stderr. If the command has not finished executing, then this
     * string is empty.
     * </p>
     * 
     * @return The first 8,000 characters written by the plugin to stderr. If the command has not finished executing,
     *         then this string is empty.
     */
    public String standardErrorContent() {
        return standardErrorContent;
    }

    /**
     * <p>
     * The URL for the complete text written by the plugin to stderr. If the command has not finished executing, then
     * this string is empty.
     * </p>
     * 
     * @return The URL for the complete text written by the plugin to stderr. If the command has not finished executing,
     *         then this string is empty.
     */
    public String standardErrorUrl() {
        return standardErrorUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((commandId() == null) ? 0 : commandId().hashCode());
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((comment() == null) ? 0 : comment().hashCode());
        hashCode = 31 * hashCode + ((documentName() == null) ? 0 : documentName().hashCode());
        hashCode = 31 * hashCode + ((pluginName() == null) ? 0 : pluginName().hashCode());
        hashCode = 31 * hashCode + ((responseCode() == null) ? 0 : responseCode().hashCode());
        hashCode = 31 * hashCode + ((executionStartDateTime() == null) ? 0 : executionStartDateTime().hashCode());
        hashCode = 31 * hashCode + ((executionElapsedTime() == null) ? 0 : executionElapsedTime().hashCode());
        hashCode = 31 * hashCode + ((executionEndDateTime() == null) ? 0 : executionEndDateTime().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((statusDetails() == null) ? 0 : statusDetails().hashCode());
        hashCode = 31 * hashCode + ((standardOutputContent() == null) ? 0 : standardOutputContent().hashCode());
        hashCode = 31 * hashCode + ((standardOutputUrl() == null) ? 0 : standardOutputUrl().hashCode());
        hashCode = 31 * hashCode + ((standardErrorContent() == null) ? 0 : standardErrorContent().hashCode());
        hashCode = 31 * hashCode + ((standardErrorUrl() == null) ? 0 : standardErrorUrl().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCommandInvocationResponse)) {
            return false;
        }
        GetCommandInvocationResponse other = (GetCommandInvocationResponse) obj;
        if (other.commandId() == null ^ this.commandId() == null) {
            return false;
        }
        if (other.commandId() != null && !other.commandId().equals(this.commandId())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.comment() == null ^ this.comment() == null) {
            return false;
        }
        if (other.comment() != null && !other.comment().equals(this.comment())) {
            return false;
        }
        if (other.documentName() == null ^ this.documentName() == null) {
            return false;
        }
        if (other.documentName() != null && !other.documentName().equals(this.documentName())) {
            return false;
        }
        if (other.pluginName() == null ^ this.pluginName() == null) {
            return false;
        }
        if (other.pluginName() != null && !other.pluginName().equals(this.pluginName())) {
            return false;
        }
        if (other.responseCode() == null ^ this.responseCode() == null) {
            return false;
        }
        if (other.responseCode() != null && !other.responseCode().equals(this.responseCode())) {
            return false;
        }
        if (other.executionStartDateTime() == null ^ this.executionStartDateTime() == null) {
            return false;
        }
        if (other.executionStartDateTime() != null && !other.executionStartDateTime().equals(this.executionStartDateTime())) {
            return false;
        }
        if (other.executionElapsedTime() == null ^ this.executionElapsedTime() == null) {
            return false;
        }
        if (other.executionElapsedTime() != null && !other.executionElapsedTime().equals(this.executionElapsedTime())) {
            return false;
        }
        if (other.executionEndDateTime() == null ^ this.executionEndDateTime() == null) {
            return false;
        }
        if (other.executionEndDateTime() != null && !other.executionEndDateTime().equals(this.executionEndDateTime())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.statusDetails() == null ^ this.statusDetails() == null) {
            return false;
        }
        if (other.statusDetails() != null && !other.statusDetails().equals(this.statusDetails())) {
            return false;
        }
        if (other.standardOutputContent() == null ^ this.standardOutputContent() == null) {
            return false;
        }
        if (other.standardOutputContent() != null && !other.standardOutputContent().equals(this.standardOutputContent())) {
            return false;
        }
        if (other.standardOutputUrl() == null ^ this.standardOutputUrl() == null) {
            return false;
        }
        if (other.standardOutputUrl() != null && !other.standardOutputUrl().equals(this.standardOutputUrl())) {
            return false;
        }
        if (other.standardErrorContent() == null ^ this.standardErrorContent() == null) {
            return false;
        }
        if (other.standardErrorContent() != null && !other.standardErrorContent().equals(this.standardErrorContent())) {
            return false;
        }
        if (other.standardErrorUrl() == null ^ this.standardErrorUrl() == null) {
            return false;
        }
        if (other.standardErrorUrl() != null && !other.standardErrorUrl().equals(this.standardErrorUrl())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (commandId() != null) {
            sb.append("CommandId: ").append(commandId()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (comment() != null) {
            sb.append("Comment: ").append(comment()).append(",");
        }
        if (documentName() != null) {
            sb.append("DocumentName: ").append(documentName()).append(",");
        }
        if (pluginName() != null) {
            sb.append("PluginName: ").append(pluginName()).append(",");
        }
        if (responseCode() != null) {
            sb.append("ResponseCode: ").append(responseCode()).append(",");
        }
        if (executionStartDateTime() != null) {
            sb.append("ExecutionStartDateTime: ").append(executionStartDateTime()).append(",");
        }
        if (executionElapsedTime() != null) {
            sb.append("ExecutionElapsedTime: ").append(executionElapsedTime()).append(",");
        }
        if (executionEndDateTime() != null) {
            sb.append("ExecutionEndDateTime: ").append(executionEndDateTime()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (statusDetails() != null) {
            sb.append("StatusDetails: ").append(statusDetails()).append(",");
        }
        if (standardOutputContent() != null) {
            sb.append("StandardOutputContent: ").append(standardOutputContent()).append(",");
        }
        if (standardOutputUrl() != null) {
            sb.append("StandardOutputUrl: ").append(standardOutputUrl()).append(",");
        }
        if (standardErrorContent() != null) {
            sb.append("StandardErrorContent: ").append(standardErrorContent()).append(",");
        }
        if (standardErrorUrl() != null) {
            sb.append("StandardErrorUrl: ").append(standardErrorUrl()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetCommandInvocationResponse> {
        /**
         * <p>
         * The parent command ID of the invocation plugin.
         * </p>
         * 
         * @param commandId
         *        The parent command ID of the invocation plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandId(String commandId);

        /**
         * <p>
         * The ID of the managed instance targeted by the command. A managed instance can be an Amazon EC2 instance or
         * an instance in your hybrid environment that is configured for Systems Manager.
         * </p>
         * 
         * @param instanceId
         *        The ID of the managed instance targeted by the command. A managed instance can be an Amazon EC2
         *        instance or an instance in your hybrid environment that is configured for Systems Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The comment text for the command.
         * </p>
         * 
         * @param comment
         *        The comment text for the command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * The name of the document that was executed. For example, AWS-RunShellScript.
         * </p>
         * 
         * @param documentName
         *        The name of the document that was executed. For example, AWS-RunShellScript.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentName(String documentName);

        /**
         * <p>
         * The name of the plugin for which you want detailed results. For example, aws:RunShellScript is a plugin.
         * </p>
         * 
         * @param pluginName
         *        The name of the plugin for which you want detailed results. For example, aws:RunShellScript is a
         *        plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pluginName(String pluginName);

        /**
         * <p>
         * The error level response code for the plugin script. If the response code is -1, then the command has not
         * started executing on the instance, or it was not received by the instance.
         * </p>
         * 
         * @param responseCode
         *        The error level response code for the plugin script. If the response code is -1, then the command has
         *        not started executing on the instance, or it was not received by the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseCode(Integer responseCode);

        /**
         * <p>
         * The date and time the plugin started executing. Date and time are written in ISO 8601 format. For example,
         * June 7, 2017 is represented as 2017-06-7. The following sample AWS CLI command uses the
         * <code>InvokedBefore</code> filter.
         * </p>
         * <p>
         * <code>aws ssm list-commands --filters key=InvokedBefore,value=2017-06-07T00:00:00Z</code>
         * </p>
         * <p>
         * If the plugin has not started to execute, the string is empty.
         * </p>
         * 
         * @param executionStartDateTime
         *        The date and time the plugin started executing. Date and time are written in ISO 8601 format. For
         *        example, June 7, 2017 is represented as 2017-06-7. The following sample AWS CLI command uses the
         *        <code>InvokedBefore</code> filter.</p>
         *        <p>
         *        <code>aws ssm list-commands --filters key=InvokedBefore,value=2017-06-07T00:00:00Z</code>
         *        </p>
         *        <p>
         *        If the plugin has not started to execute, the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStartDateTime(String executionStartDateTime);

        /**
         * <p>
         * Duration since ExecutionStartDateTime.
         * </p>
         * 
         * @param executionElapsedTime
         *        Duration since ExecutionStartDateTime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionElapsedTime(String executionElapsedTime);

        /**
         * <p>
         * The date and time the plugin was finished executing. Date and time are written in ISO 8601 format. For
         * example, June 7, 2017 is represented as 2017-06-7. The following sample AWS CLI command uses the
         * <code>InvokedAfter</code> filter.
         * </p>
         * <p>
         * <code>aws ssm list-commands --filters key=InvokedAfter,value=2017-06-07T00:00:00Z</code>
         * </p>
         * <p>
         * If the plugin has not started to execute, the string is empty.
         * </p>
         * 
         * @param executionEndDateTime
         *        The date and time the plugin was finished executing. Date and time are written in ISO 8601 format. For
         *        example, June 7, 2017 is represented as 2017-06-7. The following sample AWS CLI command uses the
         *        <code>InvokedAfter</code> filter.</p>
         *        <p>
         *        <code>aws ssm list-commands --filters key=InvokedAfter,value=2017-06-07T00:00:00Z</code>
         *        </p>
         *        <p>
         *        If the plugin has not started to execute, the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionEndDateTime(String executionEndDateTime);

        /**
         * <p>
         * The status of the parent command for this invocation. This status can be different than StatusDetails.
         * </p>
         * 
         * @param status
         *        The status of the parent command for this invocation. This status can be different than StatusDetails.
         * @see CommandInvocationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommandInvocationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the parent command for this invocation. This status can be different than StatusDetails.
         * </p>
         * 
         * @param status
         *        The status of the parent command for this invocation. This status can be different than StatusDetails.
         * @see CommandInvocationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommandInvocationStatus
         */
        Builder status(CommandInvocationStatus status);

        /**
         * <p>
         * A detailed status of the command execution for an invocation. StatusDetails includes more information than
         * Status because it includes states resulting from error and concurrency control parameters. StatusDetails can
         * show different results than Status. For more information about these statuses, see <a
         * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-about-status.html">Run Command
         * Status</a>. StatusDetails can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Pending: The command has not been sent to the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * In Progress: The command has been sent to the instance but has not reached a terminal state.
         * </p>
         * </li>
         * <li>
         * <p>
         * Delayed: The system attempted to send the command to the target, but the target was not available. The
         * instance might not be available because of network issues, the instance was stopped, etc. The system will try
         * to deliver the command again.
         * </p>
         * </li>
         * <li>
         * <p>
         * Success: The command or plugin was executed successfully. This is a terminal state.
         * </p>
         * </li>
         * <li>
         * <p>
         * Delivery Timed Out: The command was not delivered to the instance before the delivery timeout expired.
         * Delivery timeouts do not count against the parent command's MaxErrors limit, but they do contribute to
         * whether the parent command status is Success or Incomplete. This is a terminal state.
         * </p>
         * </li>
         * <li>
         * <p>
         * Execution Timed Out: The command started to execute on the instance, but the execution was not complete
         * before the timeout expired. Execution timeouts count against the MaxErrors limit of the parent command. This
         * is a terminal state.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed: The command wasn't executed successfully on the instance. For a plugin, this indicates that the
         * result code was not zero. For a command invocation, this indicates that the result code for one or more
         * plugins was not zero. Invocation failures count against the MaxErrors limit of the parent command. This is a
         * terminal state.
         * </p>
         * </li>
         * <li>
         * <p>
         * Canceled: The command was terminated before it was completed. This is a terminal state.
         * </p>
         * </li>
         * <li>
         * <p>
         * Undeliverable: The command can't be delivered to the instance. The instance might not exist or might not be
         * responding. Undeliverable invocations don't count against the parent command's MaxErrors limit and don't
         * contribute to whether the parent command status is Success or Incomplete. This is a terminal state.
         * </p>
         * </li>
         * <li>
         * <p>
         * Terminated: The parent command exceeded its MaxErrors limit and subsequent command invocations were canceled
         * by the system. This is a terminal state.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statusDetails
         *        A detailed status of the command execution for an invocation. StatusDetails includes more information
         *        than Status because it includes states resulting from error and concurrency control parameters.
         *        StatusDetails can show different results than Status. For more information about these statuses, see
         *        <a href="http://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-about-status.html">Run
         *        Command Status</a>. StatusDetails can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Pending: The command has not been sent to the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In Progress: The command has been sent to the instance but has not reached a terminal state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Delayed: The system attempted to send the command to the target, but the target was not available. The
         *        instance might not be available because of network issues, the instance was stopped, etc. The system
         *        will try to deliver the command again.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Success: The command or plugin was executed successfully. This is a terminal state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Delivery Timed Out: The command was not delivered to the instance before the delivery timeout expired.
         *        Delivery timeouts do not count against the parent command's MaxErrors limit, but they do contribute to
         *        whether the parent command status is Success or Incomplete. This is a terminal state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Execution Timed Out: The command started to execute on the instance, but the execution was not
         *        complete before the timeout expired. Execution timeouts count against the MaxErrors limit of the
         *        parent command. This is a terminal state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed: The command wasn't executed successfully on the instance. For a plugin, this indicates that
         *        the result code was not zero. For a command invocation, this indicates that the result code for one or
         *        more plugins was not zero. Invocation failures count against the MaxErrors limit of the parent
         *        command. This is a terminal state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Canceled: The command was terminated before it was completed. This is a terminal state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Undeliverable: The command can't be delivered to the instance. The instance might not exist or might
         *        not be responding. Undeliverable invocations don't count against the parent command's MaxErrors limit
         *        and don't contribute to whether the parent command status is Success or Incomplete. This is a terminal
         *        state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Terminated: The parent command exceeded its MaxErrors limit and subsequent command invocations were
         *        canceled by the system. This is a terminal state.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDetails(String statusDetails);

        /**
         * <p>
         * The first 24,000 characters written by the plugin to stdout. If the command has not finished executing, if
         * ExecutionStatus is neither Succeeded nor Failed, then this string is empty.
         * </p>
         * 
         * @param standardOutputContent
         *        The first 24,000 characters written by the plugin to stdout. If the command has not finished
         *        executing, if ExecutionStatus is neither Succeeded nor Failed, then this string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardOutputContent(String standardOutputContent);

        /**
         * <p>
         * The URL for the complete text written by the plugin to stdout in Amazon S3. If an Amazon S3 bucket was not
         * specified, then this string is empty.
         * </p>
         * 
         * @param standardOutputUrl
         *        The URL for the complete text written by the plugin to stdout in Amazon S3. If an Amazon S3 bucket was
         *        not specified, then this string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardOutputUrl(String standardOutputUrl);

        /**
         * <p>
         * The first 8,000 characters written by the plugin to stderr. If the command has not finished executing, then
         * this string is empty.
         * </p>
         * 
         * @param standardErrorContent
         *        The first 8,000 characters written by the plugin to stderr. If the command has not finished executing,
         *        then this string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardErrorContent(String standardErrorContent);

        /**
         * <p>
         * The URL for the complete text written by the plugin to stderr. If the command has not finished executing,
         * then this string is empty.
         * </p>
         * 
         * @param standardErrorUrl
         *        The URL for the complete text written by the plugin to stderr. If the command has not finished
         *        executing, then this string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardErrorUrl(String standardErrorUrl);
    }

    private static final class BuilderImpl implements Builder {
        private String commandId;

        private String instanceId;

        private String comment;

        private String documentName;

        private String pluginName;

        private Integer responseCode;

        private String executionStartDateTime;

        private String executionElapsedTime;

        private String executionEndDateTime;

        private String status;

        private String statusDetails;

        private String standardOutputContent;

        private String standardOutputUrl;

        private String standardErrorContent;

        private String standardErrorUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCommandInvocationResponse model) {
            setCommandId(model.commandId);
            setInstanceId(model.instanceId);
            setComment(model.comment);
            setDocumentName(model.documentName);
            setPluginName(model.pluginName);
            setResponseCode(model.responseCode);
            setExecutionStartDateTime(model.executionStartDateTime);
            setExecutionElapsedTime(model.executionElapsedTime);
            setExecutionEndDateTime(model.executionEndDateTime);
            setStatus(model.status);
            setStatusDetails(model.statusDetails);
            setStandardOutputContent(model.standardOutputContent);
            setStandardOutputUrl(model.standardOutputUrl);
            setStandardErrorContent(model.standardErrorContent);
            setStandardErrorUrl(model.standardErrorUrl);
        }

        public final String getCommandId() {
            return commandId;
        }

        @Override
        public final Builder commandId(String commandId) {
            this.commandId = commandId;
            return this;
        }

        public final void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final String getDocumentName() {
            return documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        public final String getPluginName() {
            return pluginName;
        }

        @Override
        public final Builder pluginName(String pluginName) {
            this.pluginName = pluginName;
            return this;
        }

        public final void setPluginName(String pluginName) {
            this.pluginName = pluginName;
        }

        public final Integer getResponseCode() {
            return responseCode;
        }

        @Override
        public final Builder responseCode(Integer responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public final void setResponseCode(Integer responseCode) {
            this.responseCode = responseCode;
        }

        public final String getExecutionStartDateTime() {
            return executionStartDateTime;
        }

        @Override
        public final Builder executionStartDateTime(String executionStartDateTime) {
            this.executionStartDateTime = executionStartDateTime;
            return this;
        }

        public final void setExecutionStartDateTime(String executionStartDateTime) {
            this.executionStartDateTime = executionStartDateTime;
        }

        public final String getExecutionElapsedTime() {
            return executionElapsedTime;
        }

        @Override
        public final Builder executionElapsedTime(String executionElapsedTime) {
            this.executionElapsedTime = executionElapsedTime;
            return this;
        }

        public final void setExecutionElapsedTime(String executionElapsedTime) {
            this.executionElapsedTime = executionElapsedTime;
        }

        public final String getExecutionEndDateTime() {
            return executionEndDateTime;
        }

        @Override
        public final Builder executionEndDateTime(String executionEndDateTime) {
            this.executionEndDateTime = executionEndDateTime;
            return this;
        }

        public final void setExecutionEndDateTime(String executionEndDateTime) {
            this.executionEndDateTime = executionEndDateTime;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CommandInvocationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDetails() {
            return statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        public final String getStandardOutputContent() {
            return standardOutputContent;
        }

        @Override
        public final Builder standardOutputContent(String standardOutputContent) {
            this.standardOutputContent = standardOutputContent;
            return this;
        }

        public final void setStandardOutputContent(String standardOutputContent) {
            this.standardOutputContent = standardOutputContent;
        }

        public final String getStandardOutputUrl() {
            return standardOutputUrl;
        }

        @Override
        public final Builder standardOutputUrl(String standardOutputUrl) {
            this.standardOutputUrl = standardOutputUrl;
            return this;
        }

        public final void setStandardOutputUrl(String standardOutputUrl) {
            this.standardOutputUrl = standardOutputUrl;
        }

        public final String getStandardErrorContent() {
            return standardErrorContent;
        }

        @Override
        public final Builder standardErrorContent(String standardErrorContent) {
            this.standardErrorContent = standardErrorContent;
            return this;
        }

        public final void setStandardErrorContent(String standardErrorContent) {
            this.standardErrorContent = standardErrorContent;
        }

        public final String getStandardErrorUrl() {
            return standardErrorUrl;
        }

        @Override
        public final Builder standardErrorUrl(String standardErrorUrl) {
            this.standardErrorUrl = standardErrorUrl;
            return this;
        }

        public final void setStandardErrorUrl(String standardErrorUrl) {
            this.standardErrorUrl = standardErrorUrl;
        }

        @Override
        public GetCommandInvocationResponse build() {
            return new GetCommandInvocationResponse(this);
        }
    }
}
