/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class SendCommandRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<SendCommandRequest.Builder, SendCommandRequest> {
    private final List<String> instanceIds;

    private final List<Target> targets;

    private final String documentName;

    private final String documentHash;

    private final String documentHashType;

    private final Integer timeoutSeconds;

    private final String comment;

    private final Map<String, List<String>> parameters;

    private final String outputS3Region;

    private final String outputS3BucketName;

    private final String outputS3KeyPrefix;

    private final String maxConcurrency;

    private final String maxErrors;

    private final String serviceRoleArn;

    private final NotificationConfig notificationConfig;

    private SendCommandRequest(BuilderImpl builder) {
        this.instanceIds = builder.instanceIds;
        this.targets = builder.targets;
        this.documentName = builder.documentName;
        this.documentHash = builder.documentHash;
        this.documentHashType = builder.documentHashType;
        this.timeoutSeconds = builder.timeoutSeconds;
        this.comment = builder.comment;
        this.parameters = builder.parameters;
        this.outputS3Region = builder.outputS3Region;
        this.outputS3BucketName = builder.outputS3BucketName;
        this.outputS3KeyPrefix = builder.outputS3KeyPrefix;
        this.maxConcurrency = builder.maxConcurrency;
        this.maxErrors = builder.maxErrors;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.notificationConfig = builder.notificationConfig;
    }

    /**
     * <p>
     * The instance IDs where the command should execute. You can specify a maximum of 50 IDs. If you prefer not to list
     * individual instance IDs, you can instead send commands to a fleet of instances using the Targets parameter, which
     * accepts EC2 tags. For more information about how to use Targets, see <a
     * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending Commands
     * to a Fleet</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The instance IDs where the command should execute. You can specify a maximum of 50 IDs. If you prefer not
     *         to list individual instance IDs, you can instead send commands to a fleet of instances using the Targets
     *         parameter, which accepts EC2 tags. For more information about how to use Targets, see <a
     *         href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending
     *         Commands to a Fleet</a>.
     */
    public List<String> instanceIds() {
        return instanceIds;
    }

    /**
     * <p>
     * (Optional) An array of search criteria that targets instances using a Key,Value combination that you specify.
     * Targets is required if you don't provide one or more instance IDs in the call. For more information about how to
     * use Targets, see <a
     * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending Commands
     * to a Fleet</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return (Optional) An array of search criteria that targets instances using a Key,Value combination that you
     *         specify. Targets is required if you don't provide one or more instance IDs in the call. For more
     *         information about how to use Targets, see <a
     *         href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending
     *         Commands to a Fleet</a>.
     */
    public List<Target> targets() {
        return targets;
    }

    /**
     * <p>
     * Required. The name of the Systems Manager document to execute. This can be a public document or a custom
     * document.
     * </p>
     * 
     * @return Required. The name of the Systems Manager document to execute. This can be a public document or a custom
     *         document.
     */
    public String documentName() {
        return documentName;
    }

    /**
     * <p>
     * The Sha256 or Sha1 hash created by the system when the document was created.
     * </p>
     * <note>
     * <p>
     * Sha1 hashes have been deprecated.
     * </p>
     * </note>
     * 
     * @return The Sha256 or Sha1 hash created by the system when the document was created. </p> <note>
     *         <p>
     *         Sha1 hashes have been deprecated.
     *         </p>
     */
    public String documentHash() {
        return documentHash;
    }

    /**
     * <p>
     * Sha256 or Sha1.
     * </p>
     * <note>
     * <p>
     * Sha1 hashes have been deprecated.
     * </p>
     * </note>
     * 
     * @return Sha256 or Sha1.</p> <note>
     *         <p>
     *         Sha1 hashes have been deprecated.
     *         </p>
     * @see DocumentHashType
     */
    public String documentHashType() {
        return documentHashType;
    }

    /**
     * <p>
     * If this time is reached and the command has not already started executing, it will not execute.
     * </p>
     * 
     * @return If this time is reached and the command has not already started executing, it will not execute.
     */
    public Integer timeoutSeconds() {
        return timeoutSeconds;
    }

    /**
     * <p>
     * User-specified information about the command, such as a brief description of what the command should do.
     * </p>
     * 
     * @return User-specified information about the command, such as a brief description of what the command should do.
     */
    public String comment() {
        return comment;
    }

    /**
     * <p>
     * The required and optional parameters specified in the document being executed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The required and optional parameters specified in the document being executed.
     */
    public Map<String, List<String>> parameters() {
        return parameters;
    }

    /**
     * <p>
     * (Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager
     * automatically determines the Amazon S3 bucket region.
     * </p>
     * 
     * @return (Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager
     *         automatically determines the Amazon S3 bucket region.
     */
    public String outputS3Region() {
        return outputS3Region;
    }

    /**
     * <p>
     * The name of the S3 bucket where command execution responses should be stored.
     * </p>
     * 
     * @return The name of the S3 bucket where command execution responses should be stored.
     */
    public String outputS3BucketName() {
        return outputS3BucketName;
    }

    /**
     * <p>
     * The directory structure within the S3 bucket where the responses should be stored.
     * </p>
     * 
     * @return The directory structure within the S3 bucket where the responses should be stored.
     */
    public String outputS3KeyPrefix() {
        return outputS3KeyPrefix;
    }

    /**
     * <p>
     * (Optional) The maximum number of instances that are allowed to execute the command at the same time. You can
     * specify a number such as 10 or a percentage such as 10%. The default value is 50. For more information about how
     * to use MaxConcurrency, see <a
     * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-velocity.html">Using Concurrency
     * Controls</a>.
     * </p>
     * 
     * @return (Optional) The maximum number of instances that are allowed to execute the command at the same time. You
     *         can specify a number such as 10 or a percentage such as 10%. The default value is 50. For more
     *         information about how to use MaxConcurrency, see <a
     *         href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-velocity.html">Using
     *         Concurrency Controls</a>.
     */
    public String maxConcurrency() {
        return maxConcurrency;
    }

    /**
     * <p>
     * The maximum number of errors allowed without the command failing. When the command fails one more time beyond the
     * value of MaxErrors, the systems stops sending the command to additional targets. You can specify a number like 10
     * or a percentage like 10%. The default value is 50. For more information about how to use MaxErrors, see <a
     * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-maxerrors.html">Using Error
     * Controls</a>.
     * </p>
     * 
     * @return The maximum number of errors allowed without the command failing. When the command fails one more time
     *         beyond the value of MaxErrors, the systems stops sending the command to additional targets. You can
     *         specify a number like 10 or a percentage like 10%. The default value is 50. For more information about
     *         how to use MaxErrors, see <a
     *         href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-maxerrors.html">Using
     *         Error Controls</a>.
     */
    public String maxErrors() {
        return maxErrors;
    }

    /**
     * <p>
     * The IAM role that Systems Manager uses to send notifications.
     * </p>
     * 
     * @return The IAM role that Systems Manager uses to send notifications.
     */
    public String serviceRoleArn() {
        return serviceRoleArn;
    }

    /**
     * <p>
     * Configurations for sending notifications.
     * </p>
     * 
     * @return Configurations for sending notifications.
     */
    public NotificationConfig notificationConfig() {
        return notificationConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceIds() == null) ? 0 : instanceIds().hashCode());
        hashCode = 31 * hashCode + ((targets() == null) ? 0 : targets().hashCode());
        hashCode = 31 * hashCode + ((documentName() == null) ? 0 : documentName().hashCode());
        hashCode = 31 * hashCode + ((documentHash() == null) ? 0 : documentHash().hashCode());
        hashCode = 31 * hashCode + ((documentHashType() == null) ? 0 : documentHashType().hashCode());
        hashCode = 31 * hashCode + ((timeoutSeconds() == null) ? 0 : timeoutSeconds().hashCode());
        hashCode = 31 * hashCode + ((comment() == null) ? 0 : comment().hashCode());
        hashCode = 31 * hashCode + ((parameters() == null) ? 0 : parameters().hashCode());
        hashCode = 31 * hashCode + ((outputS3Region() == null) ? 0 : outputS3Region().hashCode());
        hashCode = 31 * hashCode + ((outputS3BucketName() == null) ? 0 : outputS3BucketName().hashCode());
        hashCode = 31 * hashCode + ((outputS3KeyPrefix() == null) ? 0 : outputS3KeyPrefix().hashCode());
        hashCode = 31 * hashCode + ((maxConcurrency() == null) ? 0 : maxConcurrency().hashCode());
        hashCode = 31 * hashCode + ((maxErrors() == null) ? 0 : maxErrors().hashCode());
        hashCode = 31 * hashCode + ((serviceRoleArn() == null) ? 0 : serviceRoleArn().hashCode());
        hashCode = 31 * hashCode + ((notificationConfig() == null) ? 0 : notificationConfig().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendCommandRequest)) {
            return false;
        }
        SendCommandRequest other = (SendCommandRequest) obj;
        if (other.instanceIds() == null ^ this.instanceIds() == null) {
            return false;
        }
        if (other.instanceIds() != null && !other.instanceIds().equals(this.instanceIds())) {
            return false;
        }
        if (other.targets() == null ^ this.targets() == null) {
            return false;
        }
        if (other.targets() != null && !other.targets().equals(this.targets())) {
            return false;
        }
        if (other.documentName() == null ^ this.documentName() == null) {
            return false;
        }
        if (other.documentName() != null && !other.documentName().equals(this.documentName())) {
            return false;
        }
        if (other.documentHash() == null ^ this.documentHash() == null) {
            return false;
        }
        if (other.documentHash() != null && !other.documentHash().equals(this.documentHash())) {
            return false;
        }
        if (other.documentHashType() == null ^ this.documentHashType() == null) {
            return false;
        }
        if (other.documentHashType() != null && !other.documentHashType().equals(this.documentHashType())) {
            return false;
        }
        if (other.timeoutSeconds() == null ^ this.timeoutSeconds() == null) {
            return false;
        }
        if (other.timeoutSeconds() != null && !other.timeoutSeconds().equals(this.timeoutSeconds())) {
            return false;
        }
        if (other.comment() == null ^ this.comment() == null) {
            return false;
        }
        if (other.comment() != null && !other.comment().equals(this.comment())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.outputS3Region() == null ^ this.outputS3Region() == null) {
            return false;
        }
        if (other.outputS3Region() != null && !other.outputS3Region().equals(this.outputS3Region())) {
            return false;
        }
        if (other.outputS3BucketName() == null ^ this.outputS3BucketName() == null) {
            return false;
        }
        if (other.outputS3BucketName() != null && !other.outputS3BucketName().equals(this.outputS3BucketName())) {
            return false;
        }
        if (other.outputS3KeyPrefix() == null ^ this.outputS3KeyPrefix() == null) {
            return false;
        }
        if (other.outputS3KeyPrefix() != null && !other.outputS3KeyPrefix().equals(this.outputS3KeyPrefix())) {
            return false;
        }
        if (other.maxConcurrency() == null ^ this.maxConcurrency() == null) {
            return false;
        }
        if (other.maxConcurrency() != null && !other.maxConcurrency().equals(this.maxConcurrency())) {
            return false;
        }
        if (other.maxErrors() == null ^ this.maxErrors() == null) {
            return false;
        }
        if (other.maxErrors() != null && !other.maxErrors().equals(this.maxErrors())) {
            return false;
        }
        if (other.serviceRoleArn() == null ^ this.serviceRoleArn() == null) {
            return false;
        }
        if (other.serviceRoleArn() != null && !other.serviceRoleArn().equals(this.serviceRoleArn())) {
            return false;
        }
        if (other.notificationConfig() == null ^ this.notificationConfig() == null) {
            return false;
        }
        if (other.notificationConfig() != null && !other.notificationConfig().equals(this.notificationConfig())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceIds() != null) {
            sb.append("InstanceIds: ").append(instanceIds()).append(",");
        }
        if (targets() != null) {
            sb.append("Targets: ").append(targets()).append(",");
        }
        if (documentName() != null) {
            sb.append("DocumentName: ").append(documentName()).append(",");
        }
        if (documentHash() != null) {
            sb.append("DocumentHash: ").append(documentHash()).append(",");
        }
        if (documentHashType() != null) {
            sb.append("DocumentHashType: ").append(documentHashType()).append(",");
        }
        if (timeoutSeconds() != null) {
            sb.append("TimeoutSeconds: ").append(timeoutSeconds()).append(",");
        }
        if (comment() != null) {
            sb.append("Comment: ").append(comment()).append(",");
        }
        if (parameters() != null) {
            sb.append("Parameters: ").append(parameters()).append(",");
        }
        if (outputS3Region() != null) {
            sb.append("OutputS3Region: ").append(outputS3Region()).append(",");
        }
        if (outputS3BucketName() != null) {
            sb.append("OutputS3BucketName: ").append(outputS3BucketName()).append(",");
        }
        if (outputS3KeyPrefix() != null) {
            sb.append("OutputS3KeyPrefix: ").append(outputS3KeyPrefix()).append(",");
        }
        if (maxConcurrency() != null) {
            sb.append("MaxConcurrency: ").append(maxConcurrency()).append(",");
        }
        if (maxErrors() != null) {
            sb.append("MaxErrors: ").append(maxErrors()).append(",");
        }
        if (serviceRoleArn() != null) {
            sb.append("ServiceRoleArn: ").append(serviceRoleArn()).append(",");
        }
        if (notificationConfig() != null) {
            sb.append("NotificationConfig: ").append(notificationConfig()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, SendCommandRequest> {
        /**
         * <p>
         * The instance IDs where the command should execute. You can specify a maximum of 50 IDs. If you prefer not to
         * list individual instance IDs, you can instead send commands to a fleet of instances using the Targets
         * parameter, which accepts EC2 tags. For more information about how to use Targets, see <a
         * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending
         * Commands to a Fleet</a>.
         * </p>
         * 
         * @param instanceIds
         *        The instance IDs where the command should execute. You can specify a maximum of 50 IDs. If you prefer
         *        not to list individual instance IDs, you can instead send commands to a fleet of instances using the
         *        Targets parameter, which accepts EC2 tags. For more information about how to use Targets, see <a
         *        href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending
         *        Commands to a Fleet</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(Collection<String> instanceIds);

        /**
         * <p>
         * The instance IDs where the command should execute. You can specify a maximum of 50 IDs. If you prefer not to
         * list individual instance IDs, you can instead send commands to a fleet of instances using the Targets
         * parameter, which accepts EC2 tags. For more information about how to use Targets, see <a
         * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending
         * Commands to a Fleet</a>.
         * </p>
         * 
         * @param instanceIds
         *        The instance IDs where the command should execute. You can specify a maximum of 50 IDs. If you prefer
         *        not to list individual instance IDs, you can instead send commands to a fleet of instances using the
         *        Targets parameter, which accepts EC2 tags. For more information about how to use Targets, see <a
         *        href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending
         *        Commands to a Fleet</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(String... instanceIds);

        /**
         * <p>
         * (Optional) An array of search criteria that targets instances using a Key,Value combination that you specify.
         * Targets is required if you don't provide one or more instance IDs in the call. For more information about how
         * to use Targets, see <a
         * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending
         * Commands to a Fleet</a>.
         * </p>
         * 
         * @param targets
         *        (Optional) An array of search criteria that targets instances using a Key,Value combination that you
         *        specify. Targets is required if you don't provide one or more instance IDs in the call. For more
         *        information about how to use Targets, see <a
         *        href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending
         *        Commands to a Fleet</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<Target> targets);

        /**
         * <p>
         * (Optional) An array of search criteria that targets instances using a Key,Value combination that you specify.
         * Targets is required if you don't provide one or more instance IDs in the call. For more information about how
         * to use Targets, see <a
         * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending
         * Commands to a Fleet</a>.
         * </p>
         * 
         * @param targets
         *        (Optional) An array of search criteria that targets instances using a Key,Value combination that you
         *        specify. Targets is required if you don't provide one or more instance IDs in the call. For more
         *        information about how to use Targets, see <a
         *        href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html">Sending
         *        Commands to a Fleet</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Target... targets);

        /**
         * <p>
         * Required. The name of the Systems Manager document to execute. This can be a public document or a custom
         * document.
         * </p>
         * 
         * @param documentName
         *        Required. The name of the Systems Manager document to execute. This can be a public document or a
         *        custom document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentName(String documentName);

        /**
         * <p>
         * The Sha256 or Sha1 hash created by the system when the document was created.
         * </p>
         * <note>
         * <p>
         * Sha1 hashes have been deprecated.
         * </p>
         * </note>
         * 
         * @param documentHash
         *        The Sha256 or Sha1 hash created by the system when the document was created. </p> <note>
         *        <p>
         *        Sha1 hashes have been deprecated.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentHash(String documentHash);

        /**
         * <p>
         * Sha256 or Sha1.
         * </p>
         * <note>
         * <p>
         * Sha1 hashes have been deprecated.
         * </p>
         * </note>
         * 
         * @param documentHashType
         *        Sha256 or Sha1.</p> <note>
         *        <p>
         *        Sha1 hashes have been deprecated.
         *        </p>
         * @see DocumentHashType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentHashType
         */
        Builder documentHashType(String documentHashType);

        /**
         * <p>
         * Sha256 or Sha1.
         * </p>
         * <note>
         * <p>
         * Sha1 hashes have been deprecated.
         * </p>
         * </note>
         * 
         * @param documentHashType
         *        Sha256 or Sha1.</p> <note>
         *        <p>
         *        Sha1 hashes have been deprecated.
         *        </p>
         * @see DocumentHashType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentHashType
         */
        Builder documentHashType(DocumentHashType documentHashType);

        /**
         * <p>
         * If this time is reached and the command has not already started executing, it will not execute.
         * </p>
         * 
         * @param timeoutSeconds
         *        If this time is reached and the command has not already started executing, it will not execute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutSeconds(Integer timeoutSeconds);

        /**
         * <p>
         * User-specified information about the command, such as a brief description of what the command should do.
         * </p>
         * 
         * @param comment
         *        User-specified information about the command, such as a brief description of what the command should
         *        do.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * The required and optional parameters specified in the document being executed.
         * </p>
         * 
         * @param parameters
         *        The required and optional parameters specified in the document being executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, ? extends Collection<String>> parameters);

        /**
         * <p>
         * (Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager
         * automatically determines the Amazon S3 bucket region.
         * </p>
         * 
         * @param outputS3Region
         *        (Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Systems Manager
         *        automatically determines the Amazon S3 bucket region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3Region(String outputS3Region);

        /**
         * <p>
         * The name of the S3 bucket where command execution responses should be stored.
         * </p>
         * 
         * @param outputS3BucketName
         *        The name of the S3 bucket where command execution responses should be stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3BucketName(String outputS3BucketName);

        /**
         * <p>
         * The directory structure within the S3 bucket where the responses should be stored.
         * </p>
         * 
         * @param outputS3KeyPrefix
         *        The directory structure within the S3 bucket where the responses should be stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputS3KeyPrefix(String outputS3KeyPrefix);

        /**
         * <p>
         * (Optional) The maximum number of instances that are allowed to execute the command at the same time. You can
         * specify a number such as 10 or a percentage such as 10%. The default value is 50. For more information about
         * how to use MaxConcurrency, see <a
         * href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-velocity.html">Using
         * Concurrency Controls</a>.
         * </p>
         * 
         * @param maxConcurrency
         *        (Optional) The maximum number of instances that are allowed to execute the command at the same time.
         *        You can specify a number such as 10 or a percentage such as 10%. The default value is 50. For more
         *        information about how to use MaxConcurrency, see <a
         *        href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-velocity.html">Using
         *        Concurrency Controls</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrency(String maxConcurrency);

        /**
         * <p>
         * The maximum number of errors allowed without the command failing. When the command fails one more time beyond
         * the value of MaxErrors, the systems stops sending the command to additional targets. You can specify a number
         * like 10 or a percentage like 10%. The default value is 50. For more information about how to use MaxErrors,
         * see <a href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-maxerrors.html">Using
         * Error Controls</a>.
         * </p>
         * 
         * @param maxErrors
         *        The maximum number of errors allowed without the command failing. When the command fails one more time
         *        beyond the value of MaxErrors, the systems stops sending the command to additional targets. You can
         *        specify a number like 10 or a percentage like 10%. The default value is 50. For more information about
         *        how to use MaxErrors, see <a
         *        href="http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-maxerrors.html">Using
         *        Error Controls</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxErrors(String maxErrors);

        /**
         * <p>
         * The IAM role that Systems Manager uses to send notifications.
         * </p>
         * 
         * @param serviceRoleArn
         *        The IAM role that Systems Manager uses to send notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRoleArn(String serviceRoleArn);

        /**
         * <p>
         * Configurations for sending notifications.
         * </p>
         * 
         * @param notificationConfig
         *        Configurations for sending notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationConfig(NotificationConfig notificationConfig);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> instanceIds;

        private List<Target> targets;

        private String documentName;

        private String documentHash;

        private String documentHashType;

        private Integer timeoutSeconds;

        private String comment;

        private Map<String, List<String>> parameters;

        private String outputS3Region;

        private String outputS3BucketName;

        private String outputS3KeyPrefix;

        private String maxConcurrency;

        private String maxErrors;

        private String serviceRoleArn;

        private NotificationConfig notificationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(SendCommandRequest model) {
            setInstanceIds(model.instanceIds);
            setTargets(model.targets);
            setDocumentName(model.documentName);
            setDocumentHash(model.documentHash);
            setDocumentHashType(model.documentHashType);
            setTimeoutSeconds(model.timeoutSeconds);
            setComment(model.comment);
            setParameters(model.parameters);
            setOutputS3Region(model.outputS3Region);
            setOutputS3BucketName(model.outputS3BucketName);
            setOutputS3KeyPrefix(model.outputS3KeyPrefix);
            setMaxConcurrency(model.maxConcurrency);
            setMaxErrors(model.maxErrors);
            setServiceRoleArn(model.serviceRoleArn);
            setNotificationConfig(model.notificationConfig);
        }

        public final Collection<String> getInstanceIds() {
            return instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdListCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String... instanceIds) {
            instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdListCopier.copy(instanceIds);
        }

        public final Collection<Target> getTargets() {
            return targets;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        public final void setTargets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
        }

        public final String getDocumentName() {
            return documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        public final String getDocumentHash() {
            return documentHash;
        }

        @Override
        public final Builder documentHash(String documentHash) {
            this.documentHash = documentHash;
            return this;
        }

        public final void setDocumentHash(String documentHash) {
            this.documentHash = documentHash;
        }

        public final String getDocumentHashType() {
            return documentHashType;
        }

        @Override
        public final Builder documentHashType(String documentHashType) {
            this.documentHashType = documentHashType;
            return this;
        }

        @Override
        public final Builder documentHashType(DocumentHashType documentHashType) {
            this.documentHashType(documentHashType.toString());
            return this;
        }

        public final void setDocumentHashType(String documentHashType) {
            this.documentHashType = documentHashType;
        }

        public final Integer getTimeoutSeconds() {
            return timeoutSeconds;
        }

        @Override
        public final Builder timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public final void setTimeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        public final String getOutputS3Region() {
            return outputS3Region;
        }

        @Override
        public final Builder outputS3Region(String outputS3Region) {
            this.outputS3Region = outputS3Region;
            return this;
        }

        public final void setOutputS3Region(String outputS3Region) {
            this.outputS3Region = outputS3Region;
        }

        public final String getOutputS3BucketName() {
            return outputS3BucketName;
        }

        @Override
        public final Builder outputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
            return this;
        }

        public final void setOutputS3BucketName(String outputS3BucketName) {
            this.outputS3BucketName = outputS3BucketName;
        }

        public final String getOutputS3KeyPrefix() {
            return outputS3KeyPrefix;
        }

        @Override
        public final Builder outputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
            return this;
        }

        public final void setOutputS3KeyPrefix(String outputS3KeyPrefix) {
            this.outputS3KeyPrefix = outputS3KeyPrefix;
        }

        public final String getMaxConcurrency() {
            return maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        public final String getMaxErrors() {
            return maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        public final String getServiceRoleArn() {
            return serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final NotificationConfig getNotificationConfig() {
            return notificationConfig;
        }

        @Override
        public final Builder notificationConfig(NotificationConfig notificationConfig) {
            this.notificationConfig = notificationConfig;
            return this;
        }

        public final void setNotificationConfig(NotificationConfig notificationConfig) {
            this.notificationConfig = notificationConfig;
        }

        @Override
        public SendCommandRequest build() {
            return new SendCommandRequest(this);
        }
    }
}
