/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateAssociationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateAssociationRequest.Builder, UpdateAssociationRequest> {
    private final String associationId;

    private final Map<String, List<String>> parameters;

    private final String documentVersion;

    private final String scheduleExpression;

    private final InstanceAssociationOutputLocation outputLocation;

    private final String name;

    private final List<Target> targets;

    private UpdateAssociationRequest(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.parameters = builder.parameters;
        this.documentVersion = builder.documentVersion;
        this.scheduleExpression = builder.scheduleExpression;
        this.outputLocation = builder.outputLocation;
        this.name = builder.name;
        this.targets = builder.targets;
    }

    /**
     * <p>
     * The ID of the association you want to update.
     * </p>
     * 
     * @return The ID of the association you want to update.
     */
    public String associationId() {
        return associationId;
    }

    /**
     * <p>
     * The parameters you want to update for the association. If you create a parameter using Parameter Store, you can
     * reference the parameter using {{ssm:parameter-name}}
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The parameters you want to update for the association. If you create a parameter using Parameter Store,
     *         you can reference the parameter using {{ssm:parameter-name}}
     */
    public Map<String, List<String>> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The document version you want update for the association.
     * </p>
     * 
     * @return The document version you want update for the association.
     */
    public String documentVersion() {
        return documentVersion;
    }

    /**
     * <p>
     * The cron expression used to schedule the association that you want to update.
     * </p>
     * 
     * @return The cron expression used to schedule the association that you want to update.
     */
    public String scheduleExpression() {
        return scheduleExpression;
    }

    /**
     * <p>
     * An Amazon S3 bucket where you want to store the results of this request.
     * </p>
     * 
     * @return An Amazon S3 bucket where you want to store the results of this request.
     */
    public InstanceAssociationOutputLocation outputLocation() {
        return outputLocation;
    }

    /**
     * <p>
     * The name of the association document.
     * </p>
     * 
     * @return The name of the association document.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The targets of the association.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The targets of the association.
     */
    public List<Target> targets() {
        return targets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((associationId() == null) ? 0 : associationId().hashCode());
        hashCode = 31 * hashCode + ((parameters() == null) ? 0 : parameters().hashCode());
        hashCode = 31 * hashCode + ((documentVersion() == null) ? 0 : documentVersion().hashCode());
        hashCode = 31 * hashCode + ((scheduleExpression() == null) ? 0 : scheduleExpression().hashCode());
        hashCode = 31 * hashCode + ((outputLocation() == null) ? 0 : outputLocation().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((targets() == null) ? 0 : targets().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssociationRequest)) {
            return false;
        }
        UpdateAssociationRequest other = (UpdateAssociationRequest) obj;
        if (other.associationId() == null ^ this.associationId() == null) {
            return false;
        }
        if (other.associationId() != null && !other.associationId().equals(this.associationId())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.documentVersion() == null ^ this.documentVersion() == null) {
            return false;
        }
        if (other.documentVersion() != null && !other.documentVersion().equals(this.documentVersion())) {
            return false;
        }
        if (other.scheduleExpression() == null ^ this.scheduleExpression() == null) {
            return false;
        }
        if (other.scheduleExpression() != null && !other.scheduleExpression().equals(this.scheduleExpression())) {
            return false;
        }
        if (other.outputLocation() == null ^ this.outputLocation() == null) {
            return false;
        }
        if (other.outputLocation() != null && !other.outputLocation().equals(this.outputLocation())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.targets() == null ^ this.targets() == null) {
            return false;
        }
        if (other.targets() != null && !other.targets().equals(this.targets())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (associationId() != null) {
            sb.append("AssociationId: ").append(associationId()).append(",");
        }
        if (parameters() != null) {
            sb.append("Parameters: ").append(parameters()).append(",");
        }
        if (documentVersion() != null) {
            sb.append("DocumentVersion: ").append(documentVersion()).append(",");
        }
        if (scheduleExpression() != null) {
            sb.append("ScheduleExpression: ").append(scheduleExpression()).append(",");
        }
        if (outputLocation() != null) {
            sb.append("OutputLocation: ").append(outputLocation()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (targets() != null) {
            sb.append("Targets: ").append(targets()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateAssociationRequest> {
        /**
         * <p>
         * The ID of the association you want to update.
         * </p>
         * 
         * @param associationId
         *        The ID of the association you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * The parameters you want to update for the association. If you create a parameter using Parameter Store, you
         * can reference the parameter using {{ssm:parameter-name}}
         * </p>
         * 
         * @param parameters
         *        The parameters you want to update for the association. If you create a parameter using Parameter
         *        Store, you can reference the parameter using {{ssm:parameter-name}}
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, ? extends Collection<String>> parameters);

        /**
         * <p>
         * The document version you want update for the association.
         * </p>
         * 
         * @param documentVersion
         *        The document version you want update for the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);

        /**
         * <p>
         * The cron expression used to schedule the association that you want to update.
         * </p>
         * 
         * @param scheduleExpression
         *        The cron expression used to schedule the association that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpression(String scheduleExpression);

        /**
         * <p>
         * An Amazon S3 bucket where you want to store the results of this request.
         * </p>
         * 
         * @param outputLocation
         *        An Amazon S3 bucket where you want to store the results of this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputLocation(InstanceAssociationOutputLocation outputLocation);

        /**
         * <p>
         * The name of the association document.
         * </p>
         * 
         * @param name
         *        The name of the association document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The targets of the association.
         * </p>
         * 
         * @param targets
         *        The targets of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<Target> targets);

        /**
         * <p>
         * The targets of the association.
         * </p>
         * 
         * @param targets
         *        The targets of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Target... targets);
    }

    private static final class BuilderImpl implements Builder {
        private String associationId;

        private Map<String, List<String>> parameters;

        private String documentVersion;

        private String scheduleExpression;

        private InstanceAssociationOutputLocation outputLocation;

        private String name;

        private List<Target> targets;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssociationRequest model) {
            setAssociationId(model.associationId);
            setParameters(model.parameters);
            setDocumentVersion(model.documentVersion);
            setScheduleExpression(model.scheduleExpression);
            setOutputLocation(model.outputLocation);
            setName(model.name);
            setTargets(model.targets);
        }

        public final String getAssociationId() {
            return associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getScheduleExpression() {
            return scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        public final InstanceAssociationOutputLocation getOutputLocation() {
            return outputLocation;
        }

        @Override
        public final Builder outputLocation(InstanceAssociationOutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final void setOutputLocation(InstanceAssociationOutputLocation outputLocation) {
            this.outputLocation = outputLocation;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<Target> getTargets() {
            return targets;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        public final void setTargets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
        }

        @Override
        public UpdateAssociationRequest build() {
            return new UpdateAssociationRequest(this);
        }
    }
}
