/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.ssm.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * DescribePatchGroupStateResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribePatchGroupStateResponseUnmarshaller implements
        Unmarshaller<DescribePatchGroupStateResponse, JsonUnmarshallerContext> {

    public DescribePatchGroupStateResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        DescribePatchGroupStateResponse.Builder describePatchGroupStateResponseBuilder = DescribePatchGroupStateResponse
                .builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return describePatchGroupStateResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("Instances", targetDepth)) {
                    context.nextToken();
                    describePatchGroupStateResponseBuilder.instances(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("InstancesWithInstalledPatches", targetDepth)) {
                    context.nextToken();
                    describePatchGroupStateResponseBuilder.instancesWithInstalledPatches(context.getUnmarshaller(Integer.class)
                            .unmarshall(context));
                }
                if (context.testExpression("InstancesWithInstalledOtherPatches", targetDepth)) {
                    context.nextToken();
                    describePatchGroupStateResponseBuilder.instancesWithInstalledOtherPatches(context.getUnmarshaller(
                            Integer.class).unmarshall(context));
                }
                if (context.testExpression("InstancesWithMissingPatches", targetDepth)) {
                    context.nextToken();
                    describePatchGroupStateResponseBuilder.instancesWithMissingPatches(context.getUnmarshaller(Integer.class)
                            .unmarshall(context));
                }
                if (context.testExpression("InstancesWithFailedPatches", targetDepth)) {
                    context.nextToken();
                    describePatchGroupStateResponseBuilder.instancesWithFailedPatches(context.getUnmarshaller(Integer.class)
                            .unmarshall(context));
                }
                if (context.testExpression("InstancesWithNotApplicablePatches", targetDepth)) {
                    context.nextToken();
                    describePatchGroupStateResponseBuilder.instancesWithNotApplicablePatches(context.getUnmarshaller(
                            Integer.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return describePatchGroupStateResponseBuilder.build();
    }

    private static final DescribePatchGroupStateResponseUnmarshaller INSTANCE = new DescribePatchGroupStateResponseUnmarshaller();

    public static DescribePatchGroupStateResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
