/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.ActivationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Activation
implements StructuredPojo,
ToCopyableBuilder<Builder, Activation> {
    private final String activationId;
    private final String description;
    private final String defaultInstanceName;
    private final String iamRole;
    private final Integer registrationLimit;
    private final Integer registrationsCount;
    private final Instant expirationDate;
    private final Boolean expired;
    private final Instant createdDate;

    private Activation(BuilderImpl builder) {
        this.activationId = builder.activationId;
        this.description = builder.description;
        this.defaultInstanceName = builder.defaultInstanceName;
        this.iamRole = builder.iamRole;
        this.registrationLimit = builder.registrationLimit;
        this.registrationsCount = builder.registrationsCount;
        this.expirationDate = builder.expirationDate;
        this.expired = builder.expired;
        this.createdDate = builder.createdDate;
    }

    public String activationId() {
        return this.activationId;
    }

    public String description() {
        return this.description;
    }

    public String defaultInstanceName() {
        return this.defaultInstanceName;
    }

    public String iamRole() {
        return this.iamRole;
    }

    public Integer registrationLimit() {
        return this.registrationLimit;
    }

    public Integer registrationsCount() {
        return this.registrationsCount;
    }

    public Instant expirationDate() {
        return this.expirationDate;
    }

    public Boolean expired() {
        return this.expired;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.activationId() == null ? 0 : this.activationId().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.defaultInstanceName() == null ? 0 : this.defaultInstanceName().hashCode());
        hashCode = 31 * hashCode + (this.iamRole() == null ? 0 : this.iamRole().hashCode());
        hashCode = 31 * hashCode + (this.registrationLimit() == null ? 0 : this.registrationLimit().hashCode());
        hashCode = 31 * hashCode + (this.registrationsCount() == null ? 0 : this.registrationsCount().hashCode());
        hashCode = 31 * hashCode + (this.expirationDate() == null ? 0 : this.expirationDate().hashCode());
        hashCode = 31 * hashCode + (this.expired() == null ? 0 : this.expired().hashCode());
        hashCode = 31 * hashCode + (this.createdDate() == null ? 0 : this.createdDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Activation)) {
            return false;
        }
        Activation other = (Activation)obj;
        if (other.activationId() == null ^ this.activationId() == null) {
            return false;
        }
        if (other.activationId() != null && !other.activationId().equals(this.activationId())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.defaultInstanceName() == null ^ this.defaultInstanceName() == null) {
            return false;
        }
        if (other.defaultInstanceName() != null && !other.defaultInstanceName().equals(this.defaultInstanceName())) {
            return false;
        }
        if (other.iamRole() == null ^ this.iamRole() == null) {
            return false;
        }
        if (other.iamRole() != null && !other.iamRole().equals(this.iamRole())) {
            return false;
        }
        if (other.registrationLimit() == null ^ this.registrationLimit() == null) {
            return false;
        }
        if (other.registrationLimit() != null && !other.registrationLimit().equals(this.registrationLimit())) {
            return false;
        }
        if (other.registrationsCount() == null ^ this.registrationsCount() == null) {
            return false;
        }
        if (other.registrationsCount() != null && !other.registrationsCount().equals(this.registrationsCount())) {
            return false;
        }
        if (other.expirationDate() == null ^ this.expirationDate() == null) {
            return false;
        }
        if (other.expirationDate() != null && !other.expirationDate().equals(this.expirationDate())) {
            return false;
        }
        if (other.expired() == null ^ this.expired() == null) {
            return false;
        }
        if (other.expired() != null && !other.expired().equals(this.expired())) {
            return false;
        }
        if (other.createdDate() == null ^ this.createdDate() == null) {
            return false;
        }
        return other.createdDate() == null || other.createdDate().equals(this.createdDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.activationId() != null) {
            sb.append("ActivationId: ").append(this.activationId()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.defaultInstanceName() != null) {
            sb.append("DefaultInstanceName: ").append(this.defaultInstanceName()).append(",");
        }
        if (this.iamRole() != null) {
            sb.append("IamRole: ").append(this.iamRole()).append(",");
        }
        if (this.registrationLimit() != null) {
            sb.append("RegistrationLimit: ").append(this.registrationLimit()).append(",");
        }
        if (this.registrationsCount() != null) {
            sb.append("RegistrationsCount: ").append(this.registrationsCount()).append(",");
        }
        if (this.expirationDate() != null) {
            sb.append("ExpirationDate: ").append(this.expirationDate()).append(",");
        }
        if (this.expired() != null) {
            sb.append("Expired: ").append(this.expired()).append(",");
        }
        if (this.createdDate() != null) {
            sb.append("CreatedDate: ").append(this.createdDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActivationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String activationId;
        private String description;
        private String defaultInstanceName;
        private String iamRole;
        private Integer registrationLimit;
        private Integer registrationsCount;
        private Instant expirationDate;
        private Boolean expired;
        private Instant createdDate;

        private BuilderImpl() {
        }

        private BuilderImpl(Activation model) {
            this.setActivationId(model.activationId);
            this.setDescription(model.description);
            this.setDefaultInstanceName(model.defaultInstanceName);
            this.setIamRole(model.iamRole);
            this.setRegistrationLimit(model.registrationLimit);
            this.setRegistrationsCount(model.registrationsCount);
            this.setExpirationDate(model.expirationDate);
            this.setExpired(model.expired);
            this.setCreatedDate(model.createdDate);
        }

        public final String getActivationId() {
            return this.activationId;
        }

        @Override
        public final Builder activationId(String activationId) {
            this.activationId = activationId;
            return this;
        }

        public final void setActivationId(String activationId) {
            this.activationId = activationId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDefaultInstanceName() {
            return this.defaultInstanceName;
        }

        @Override
        public final Builder defaultInstanceName(String defaultInstanceName) {
            this.defaultInstanceName = defaultInstanceName;
            return this;
        }

        public final void setDefaultInstanceName(String defaultInstanceName) {
            this.defaultInstanceName = defaultInstanceName;
        }

        public final String getIamRole() {
            return this.iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        public final Integer getRegistrationLimit() {
            return this.registrationLimit;
        }

        @Override
        public final Builder registrationLimit(Integer registrationLimit) {
            this.registrationLimit = registrationLimit;
            return this;
        }

        public final void setRegistrationLimit(Integer registrationLimit) {
            this.registrationLimit = registrationLimit;
        }

        public final Integer getRegistrationsCount() {
            return this.registrationsCount;
        }

        @Override
        public final Builder registrationsCount(Integer registrationsCount) {
            this.registrationsCount = registrationsCount;
            return this;
        }

        public final void setRegistrationsCount(Integer registrationsCount) {
            this.registrationsCount = registrationsCount;
        }

        public final Instant getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        public final Boolean getExpired() {
            return this.expired;
        }

        @Override
        public final Builder expired(Boolean expired) {
            this.expired = expired;
            return this;
        }

        public final void setExpired(Boolean expired) {
            this.expired = expired;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public Activation build() {
            return new Activation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Activation> {
        public Builder activationId(String var1);

        public Builder description(String var1);

        public Builder defaultInstanceName(String var1);

        public Builder iamRole(String var1);

        public Builder registrationLimit(Integer var1);

        public Builder registrationsCount(Integer var1);

        public Builder expirationDate(Instant var1);

        public Builder expired(Boolean var1);

        public Builder createdDate(Instant var1);
    }
}

