/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ssm.model.DocumentType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateDocumentRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateDocumentRequest> {
    private final String content;
    private final String name;
    private final String documentType;

    private CreateDocumentRequest(BuilderImpl builder) {
        this.content = builder.content;
        this.name = builder.name;
        this.documentType = builder.documentType;
    }

    public String content() {
        return this.content;
    }

    public String name() {
        return this.name;
    }

    public String documentType() {
        return this.documentType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.content() == null ? 0 : this.content().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.documentType() == null ? 0 : this.documentType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDocumentRequest)) {
            return false;
        }
        CreateDocumentRequest other = (CreateDocumentRequest)((Object)obj);
        if (other.content() == null ^ this.content() == null) {
            return false;
        }
        if (other.content() != null && !other.content().equals(this.content())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.documentType() == null ^ this.documentType() == null) {
            return false;
        }
        return other.documentType() == null || other.documentType().equals(this.documentType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.content() != null) {
            sb.append("Content: ").append(this.content()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.documentType() != null) {
            sb.append("DocumentType: ").append(this.documentType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String content;
        private String name;
        private String documentType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDocumentRequest model) {
            this.setContent(model.content);
            this.setName(model.name);
            this.setDocumentType(model.documentType);
        }

        public final String getContent() {
            return this.content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDocumentType() {
            return this.documentType;
        }

        @Override
        public final Builder documentType(String documentType) {
            this.documentType = documentType;
            return this;
        }

        @Override
        public final Builder documentType(DocumentType documentType) {
            this.documentType(documentType.toString());
            return this;
        }

        public final void setDocumentType(String documentType) {
            this.documentType = documentType;
        }

        public CreateDocumentRequest build() {
            return new CreateDocumentRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateDocumentRequest> {
        public Builder content(String var1);

        public Builder name(String var1);

        public Builder documentType(String var1);

        public Builder documentType(DocumentType var1);
    }
}

