/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.DocumentParameterType;
import software.amazon.awssdk.services.ssm.transform.DocumentParameterMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DocumentParameter
implements StructuredPojo,
ToCopyableBuilder<Builder, DocumentParameter> {
    private final String name;
    private final String type;
    private final String description;
    private final String defaultValue;

    private DocumentParameter(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.description = builder.description;
        this.defaultValue = builder.defaultValue;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String description() {
        return this.description;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.defaultValue() == null ? 0 : this.defaultValue().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentParameter)) {
            return false;
        }
        DocumentParameter other = (DocumentParameter)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.defaultValue() == null ^ this.defaultValue() == null) {
            return false;
        }
        return other.defaultValue() == null || other.defaultValue().equals(this.defaultValue());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.defaultValue() != null) {
            sb.append("DefaultValue: ").append(this.defaultValue()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentParameterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private String description;
        private String defaultValue;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentParameter model) {
            this.setName(model.name);
            this.setType(model.type);
            this.setDescription(model.description);
            this.setDefaultValue(model.defaultValue);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DocumentParameterType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public DocumentParameter build() {
            return new DocumentParameter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DocumentParameter> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(DocumentParameterType var1);

        public Builder description(String var1);

        public Builder defaultValue(String var1);
    }
}

