/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.AutomationParameterMapCopier;
import software.amazon.awssdk.services.ssm.transform.FailureDetailsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FailureDetails
implements StructuredPojo,
ToCopyableBuilder<Builder, FailureDetails> {
    private final String failureStage;
    private final String failureType;
    private final Map<String, List<String>> details;

    private FailureDetails(BuilderImpl builder) {
        this.failureStage = builder.failureStage;
        this.failureType = builder.failureType;
        this.details = builder.details;
    }

    public String failureStage() {
        return this.failureStage;
    }

    public String failureType() {
        return this.failureType;
    }

    public Map<String, List<String>> details() {
        return this.details;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.failureStage() == null ? 0 : this.failureStage().hashCode());
        hashCode = 31 * hashCode + (this.failureType() == null ? 0 : this.failureType().hashCode());
        hashCode = 31 * hashCode + (this.details() == null ? 0 : this.details().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailureDetails)) {
            return false;
        }
        FailureDetails other = (FailureDetails)obj;
        if (other.failureStage() == null ^ this.failureStage() == null) {
            return false;
        }
        if (other.failureStage() != null && !other.failureStage().equals(this.failureStage())) {
            return false;
        }
        if (other.failureType() == null ^ this.failureType() == null) {
            return false;
        }
        if (other.failureType() != null && !other.failureType().equals(this.failureType())) {
            return false;
        }
        if (other.details() == null ^ this.details() == null) {
            return false;
        }
        return other.details() == null || other.details().equals(this.details());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.failureStage() != null) {
            sb.append("FailureStage: ").append(this.failureStage()).append(",");
        }
        if (this.failureType() != null) {
            sb.append("FailureType: ").append(this.failureType()).append(",");
        }
        if (this.details() != null) {
            sb.append("Details: ").append(this.details()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FailureDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String failureStage;
        private String failureType;
        private Map<String, List<String>> details;

        private BuilderImpl() {
        }

        private BuilderImpl(FailureDetails model) {
            this.setFailureStage(model.failureStage);
            this.setFailureType(model.failureType);
            this.setDetails(model.details);
        }

        public final String getFailureStage() {
            return this.failureStage;
        }

        @Override
        public final Builder failureStage(String failureStage) {
            this.failureStage = failureStage;
            return this;
        }

        public final void setFailureStage(String failureStage) {
            this.failureStage = failureStage;
        }

        public final String getFailureType() {
            return this.failureType;
        }

        @Override
        public final Builder failureType(String failureType) {
            this.failureType = failureType;
            return this;
        }

        public final void setFailureType(String failureType) {
            this.failureType = failureType;
        }

        public final Map<String, ? extends Collection<String>> getDetails() {
            return this.details;
        }

        @Override
        public final Builder details(Map<String, ? extends Collection<String>> details) {
            this.details = AutomationParameterMapCopier.copy(details);
            return this;
        }

        public final void setDetails(Map<String, ? extends Collection<String>> details) {
            this.details = AutomationParameterMapCopier.copy(details);
        }

        public FailureDetails build() {
            return new FailureDetails(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FailureDetails> {
        public Builder failureStage(String var1);

        public Builder failureType(String var1);

        public Builder details(Map<String, ? extends Collection<String>> var1);
    }
}

