/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateAssociationBatchRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateAssociationBatchRequest.Builder, CreateAssociationBatchRequest> {
    private final List<CreateAssociationBatchRequestEntry> entries;

    private CreateAssociationBatchRequest(BuilderImpl builder) {
        this.entries = builder.entries;
    }

    /**
     * <p>
     * One or more associations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more associations.
     */
    public List<CreateAssociationBatchRequestEntry> entries() {
        return entries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((entries() == null) ? 0 : entries().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssociationBatchRequest)) {
            return false;
        }
        CreateAssociationBatchRequest other = (CreateAssociationBatchRequest) obj;
        if (other.entries() == null ^ this.entries() == null) {
            return false;
        }
        if (other.entries() != null && !other.entries().equals(this.entries())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (entries() != null) {
            sb.append("Entries: ").append(entries()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Entries":
            return Optional.of(clazz.cast(entries()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateAssociationBatchRequest> {
        /**
         * <p>
         * One or more associations.
         * </p>
         * 
         * @param entries
         *        One or more associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Collection<CreateAssociationBatchRequestEntry> entries);

        /**
         * <p>
         * One or more associations.
         * </p>
         * 
         * @param entries
         *        One or more associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(CreateAssociationBatchRequestEntry... entries);
    }

    static final class BuilderImpl implements Builder {
        private List<CreateAssociationBatchRequestEntry> entries;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssociationBatchRequest model) {
            entries(model.entries);
        }

        public final Collection<CreateAssociationBatchRequestEntry.Builder> getEntries() {
            return entries != null ? entries.stream().map(CreateAssociationBatchRequestEntry::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entries(Collection<CreateAssociationBatchRequestEntry> entries) {
            this.entries = CreateAssociationBatchRequestEntriesCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(CreateAssociationBatchRequestEntry... entries) {
            entries(Arrays.asList(entries));
            return this;
        }

        public final void setEntries(Collection<CreateAssociationBatchRequestEntry.BuilderImpl> entries) {
            this.entries = CreateAssociationBatchRequestEntriesCopier.copyFromBuilder(entries);
        }

        @Override
        public CreateAssociationBatchRequest build() {
            return new CreateAssociationBatchRequest(this);
        }
    }
}
