/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateAssociationBatchResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateAssociationBatchResponse.Builder, CreateAssociationBatchResponse> {
    private final List<AssociationDescription> successful;

    private final List<FailedCreateAssociation> failed;

    private CreateAssociationBatchResponse(BuilderImpl builder) {
        this.successful = builder.successful;
        this.failed = builder.failed;
    }

    /**
     * <p>
     * Information about the associations that succeeded.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the associations that succeeded.
     */
    public List<AssociationDescription> successful() {
        return successful;
    }

    /**
     * <p>
     * Information about the associations that failed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the associations that failed.
     */
    public List<FailedCreateAssociation> failed() {
        return failed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((successful() == null) ? 0 : successful().hashCode());
        hashCode = 31 * hashCode + ((failed() == null) ? 0 : failed().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssociationBatchResponse)) {
            return false;
        }
        CreateAssociationBatchResponse other = (CreateAssociationBatchResponse) obj;
        if (other.successful() == null ^ this.successful() == null) {
            return false;
        }
        if (other.successful() != null && !other.successful().equals(this.successful())) {
            return false;
        }
        if (other.failed() == null ^ this.failed() == null) {
            return false;
        }
        if (other.failed() != null && !other.failed().equals(this.failed())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (successful() != null) {
            sb.append("Successful: ").append(successful()).append(",");
        }
        if (failed() != null) {
            sb.append("Failed: ").append(failed()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Successful":
            return Optional.of(clazz.cast(successful()));
        case "Failed":
            return Optional.of(clazz.cast(failed()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateAssociationBatchResponse> {
        /**
         * <p>
         * Information about the associations that succeeded.
         * </p>
         * 
         * @param successful
         *        Information about the associations that succeeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(Collection<AssociationDescription> successful);

        /**
         * <p>
         * Information about the associations that succeeded.
         * </p>
         * 
         * @param successful
         *        Information about the associations that succeeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(AssociationDescription... successful);

        /**
         * <p>
         * Information about the associations that failed.
         * </p>
         * 
         * @param failed
         *        Information about the associations that failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(Collection<FailedCreateAssociation> failed);

        /**
         * <p>
         * Information about the associations that failed.
         * </p>
         * 
         * @param failed
         *        Information about the associations that failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(FailedCreateAssociation... failed);
    }

    static final class BuilderImpl implements Builder {
        private List<AssociationDescription> successful;

        private List<FailedCreateAssociation> failed;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssociationBatchResponse model) {
            successful(model.successful);
            failed(model.failed);
        }

        public final Collection<AssociationDescription.Builder> getSuccessful() {
            return successful != null ? successful.stream().map(AssociationDescription::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder successful(Collection<AssociationDescription> successful) {
            this.successful = AssociationDescriptionListCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(AssociationDescription... successful) {
            successful(Arrays.asList(successful));
            return this;
        }

        public final void setSuccessful(Collection<AssociationDescription.BuilderImpl> successful) {
            this.successful = AssociationDescriptionListCopier.copyFromBuilder(successful);
        }

        public final Collection<FailedCreateAssociation.Builder> getFailed() {
            return failed != null ? failed.stream().map(FailedCreateAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failed(Collection<FailedCreateAssociation> failed) {
            this.failed = FailedCreateAssociationListCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(FailedCreateAssociation... failed) {
            failed(Arrays.asList(failed));
            return this;
        }

        public final void setFailed(Collection<FailedCreateAssociation.BuilderImpl> failed) {
            this.failed = FailedCreateAssociationListCopier.copyFromBuilder(failed);
        }

        @Override
        public CreateAssociationBatchResponse build() {
            return new CreateAssociationBatchResponse(this);
        }
    }
}
