/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateAssociationResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateAssociationResponse.Builder, CreateAssociationResponse> {
    private final AssociationDescription associationDescription;

    private CreateAssociationResponse(BuilderImpl builder) {
        this.associationDescription = builder.associationDescription;
    }

    /**
     * <p>
     * Information about the association.
     * </p>
     * 
     * @return Information about the association.
     */
    public AssociationDescription associationDescription() {
        return associationDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((associationDescription() == null) ? 0 : associationDescription().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssociationResponse)) {
            return false;
        }
        CreateAssociationResponse other = (CreateAssociationResponse) obj;
        if (other.associationDescription() == null ^ this.associationDescription() == null) {
            return false;
        }
        if (other.associationDescription() != null && !other.associationDescription().equals(this.associationDescription())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (associationDescription() != null) {
            sb.append("AssociationDescription: ").append(associationDescription()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationDescription":
            return Optional.of(clazz.cast(associationDescription()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateAssociationResponse> {
        /**
         * <p>
         * Information about the association.
         * </p>
         * 
         * @param associationDescription
         *        Information about the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationDescription(AssociationDescription associationDescription);
    }

    static final class BuilderImpl implements Builder {
        private AssociationDescription associationDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssociationResponse model) {
            associationDescription(model.associationDescription);
        }

        public final AssociationDescription.Builder getAssociationDescription() {
            return associationDescription != null ? associationDescription.toBuilder() : null;
        }

        @Override
        public final Builder associationDescription(AssociationDescription associationDescription) {
            this.associationDescription = associationDescription;
            return this;
        }

        public final void setAssociationDescription(AssociationDescription.BuilderImpl associationDescription) {
            this.associationDescription = associationDescription != null ? associationDescription.build() : null;
        }

        @Override
        public CreateAssociationResponse build() {
            return new CreateAssociationResponse(this);
        }
    }
}
