/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateDocumentResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateDocumentResponse.Builder, CreateDocumentResponse> {
    private final DocumentDescription documentDescription;

    private CreateDocumentResponse(BuilderImpl builder) {
        this.documentDescription = builder.documentDescription;
    }

    /**
     * <p>
     * Information about the Systems Manager document.
     * </p>
     * 
     * @return Information about the Systems Manager document.
     */
    public DocumentDescription documentDescription() {
        return documentDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((documentDescription() == null) ? 0 : documentDescription().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDocumentResponse)) {
            return false;
        }
        CreateDocumentResponse other = (CreateDocumentResponse) obj;
        if (other.documentDescription() == null ^ this.documentDescription() == null) {
            return false;
        }
        if (other.documentDescription() != null && !other.documentDescription().equals(this.documentDescription())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (documentDescription() != null) {
            sb.append("DocumentDescription: ").append(documentDescription()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentDescription":
            return Optional.of(clazz.cast(documentDescription()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateDocumentResponse> {
        /**
         * <p>
         * Information about the Systems Manager document.
         * </p>
         * 
         * @param documentDescription
         *        Information about the Systems Manager document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentDescription(DocumentDescription documentDescription);
    }

    static final class BuilderImpl implements Builder {
        private DocumentDescription documentDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDocumentResponse model) {
            documentDescription(model.documentDescription);
        }

        public final DocumentDescription.Builder getDocumentDescription() {
            return documentDescription != null ? documentDescription.toBuilder() : null;
        }

        @Override
        public final Builder documentDescription(DocumentDescription documentDescription) {
            this.documentDescription = documentDescription;
            return this;
        }

        public final void setDocumentDescription(DocumentDescription.BuilderImpl documentDescription) {
            this.documentDescription = documentDescription != null ? documentDescription.build() : null;
        }

        @Override
        public CreateDocumentResponse build() {
            return new CreateDocumentResponse(this);
        }
    }
}
