/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateMaintenanceWindowRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateMaintenanceWindowRequest.Builder, CreateMaintenanceWindowRequest> {
    private final String name;

    private final String schedule;

    private final Integer duration;

    private final Integer cutoff;

    private final Boolean allowUnassociatedTargets;

    private final String clientToken;

    private CreateMaintenanceWindowRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.schedule = builder.schedule;
        this.duration = builder.duration;
        this.cutoff = builder.cutoff;
        this.allowUnassociatedTargets = builder.allowUnassociatedTargets;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name of the Maintenance Window.
     * </p>
     * 
     * @return The name of the Maintenance Window.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The schedule of the Maintenance Window in the form of a cron or rate expression.
     * </p>
     * 
     * @return The schedule of the Maintenance Window in the form of a cron or rate expression.
     */
    public String schedule() {
        return schedule;
    }

    /**
     * <p>
     * The duration of the Maintenance Window in hours.
     * </p>
     * 
     * @return The duration of the Maintenance Window in hours.
     */
    public Integer duration() {
        return duration;
    }

    /**
     * <p>
     * The number of hours before the end of the Maintenance Window that Systems Manager stops scheduling new tasks for
     * execution.
     * </p>
     * 
     * @return The number of hours before the end of the Maintenance Window that Systems Manager stops scheduling new
     *         tasks for execution.
     */
    public Integer cutoff() {
        return cutoff;
    }

    /**
     * <p>
     * Whether targets must be registered with the Maintenance Window before tasks can be defined for those targets.
     * </p>
     * 
     * @return Whether targets must be registered with the Maintenance Window before tasks can be defined for those
     *         targets.
     */
    public Boolean allowUnassociatedTargets() {
        return allowUnassociatedTargets;
    }

    /**
     * <p>
     * User-provided idempotency token.
     * </p>
     * 
     * @return User-provided idempotency token.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((schedule() == null) ? 0 : schedule().hashCode());
        hashCode = 31 * hashCode + ((duration() == null) ? 0 : duration().hashCode());
        hashCode = 31 * hashCode + ((cutoff() == null) ? 0 : cutoff().hashCode());
        hashCode = 31 * hashCode + ((allowUnassociatedTargets() == null) ? 0 : allowUnassociatedTargets().hashCode());
        hashCode = 31 * hashCode + ((clientToken() == null) ? 0 : clientToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMaintenanceWindowRequest)) {
            return false;
        }
        CreateMaintenanceWindowRequest other = (CreateMaintenanceWindowRequest) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.schedule() == null ^ this.schedule() == null) {
            return false;
        }
        if (other.schedule() != null && !other.schedule().equals(this.schedule())) {
            return false;
        }
        if (other.duration() == null ^ this.duration() == null) {
            return false;
        }
        if (other.duration() != null && !other.duration().equals(this.duration())) {
            return false;
        }
        if (other.cutoff() == null ^ this.cutoff() == null) {
            return false;
        }
        if (other.cutoff() != null && !other.cutoff().equals(this.cutoff())) {
            return false;
        }
        if (other.allowUnassociatedTargets() == null ^ this.allowUnassociatedTargets() == null) {
            return false;
        }
        if (other.allowUnassociatedTargets() != null && !other.allowUnassociatedTargets().equals(this.allowUnassociatedTargets())) {
            return false;
        }
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (schedule() != null) {
            sb.append("Schedule: ").append(schedule()).append(",");
        }
        if (duration() != null) {
            sb.append("Duration: ").append(duration()).append(",");
        }
        if (cutoff() != null) {
            sb.append("Cutoff: ").append(cutoff()).append(",");
        }
        if (allowUnassociatedTargets() != null) {
            sb.append("AllowUnassociatedTargets: ").append(allowUnassociatedTargets()).append(",");
        }
        if (clientToken() != null) {
            sb.append("ClientToken: ").append(clientToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "Schedule":
            return Optional.of(clazz.cast(schedule()));
        case "Duration":
            return Optional.of(clazz.cast(duration()));
        case "Cutoff":
            return Optional.of(clazz.cast(cutoff()));
        case "AllowUnassociatedTargets":
            return Optional.of(clazz.cast(allowUnassociatedTargets()));
        case "ClientToken":
            return Optional.of(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateMaintenanceWindowRequest> {
        /**
         * <p>
         * The name of the Maintenance Window.
         * </p>
         * 
         * @param name
         *        The name of the Maintenance Window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The schedule of the Maintenance Window in the form of a cron or rate expression.
         * </p>
         * 
         * @param schedule
         *        The schedule of the Maintenance Window in the form of a cron or rate expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(String schedule);

        /**
         * <p>
         * The duration of the Maintenance Window in hours.
         * </p>
         * 
         * @param duration
         *        The duration of the Maintenance Window in hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * <p>
         * The number of hours before the end of the Maintenance Window that Systems Manager stops scheduling new tasks
         * for execution.
         * </p>
         * 
         * @param cutoff
         *        The number of hours before the end of the Maintenance Window that Systems Manager stops scheduling new
         *        tasks for execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cutoff(Integer cutoff);

        /**
         * <p>
         * Whether targets must be registered with the Maintenance Window before tasks can be defined for those targets.
         * </p>
         * 
         * @param allowUnassociatedTargets
         *        Whether targets must be registered with the Maintenance Window before tasks can be defined for those
         *        targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowUnassociatedTargets(Boolean allowUnassociatedTargets);

        /**
         * <p>
         * User-provided idempotency token.
         * </p>
         * 
         * @param clientToken
         *        User-provided idempotency token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String schedule;

        private Integer duration;

        private Integer cutoff;

        private Boolean allowUnassociatedTargets;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMaintenanceWindowRequest model) {
            name(model.name);
            schedule(model.schedule);
            duration(model.duration);
            cutoff(model.cutoff);
            allowUnassociatedTargets(model.allowUnassociatedTargets);
            clientToken(model.clientToken);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSchedule() {
            return schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        public final Integer getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Integer getCutoff() {
            return cutoff;
        }

        @Override
        public final Builder cutoff(Integer cutoff) {
            this.cutoff = cutoff;
            return this;
        }

        public final void setCutoff(Integer cutoff) {
            this.cutoff = cutoff;
        }

        public final Boolean getAllowUnassociatedTargets() {
            return allowUnassociatedTargets;
        }

        @Override
        public final Builder allowUnassociatedTargets(Boolean allowUnassociatedTargets) {
            this.allowUnassociatedTargets = allowUnassociatedTargets;
            return this;
        }

        public final void setAllowUnassociatedTargets(Boolean allowUnassociatedTargets) {
            this.allowUnassociatedTargets = allowUnassociatedTargets;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public CreateMaintenanceWindowRequest build() {
            return new CreateMaintenanceWindowRequest(this);
        }
    }
}
