/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteMaintenanceWindowRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteMaintenanceWindowRequest.Builder, DeleteMaintenanceWindowRequest> {
    private final String windowId;

    private DeleteMaintenanceWindowRequest(BuilderImpl builder) {
        this.windowId = builder.windowId;
    }

    /**
     * <p>
     * The ID of the Maintenance Window to delete.
     * </p>
     * 
     * @return The ID of the Maintenance Window to delete.
     */
    public String windowId() {
        return windowId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((windowId() == null) ? 0 : windowId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMaintenanceWindowRequest)) {
            return false;
        }
        DeleteMaintenanceWindowRequest other = (DeleteMaintenanceWindowRequest) obj;
        if (other.windowId() == null ^ this.windowId() == null) {
            return false;
        }
        if (other.windowId() != null && !other.windowId().equals(this.windowId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (windowId() != null) {
            sb.append("WindowId: ").append(windowId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowId":
            return Optional.of(clazz.cast(windowId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteMaintenanceWindowRequest> {
        /**
         * <p>
         * The ID of the Maintenance Window to delete.
         * </p>
         * 
         * @param windowId
         *        The ID of the Maintenance Window to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowId(String windowId);
    }

    static final class BuilderImpl implements Builder {
        private String windowId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMaintenanceWindowRequest model) {
            windowId(model.windowId);
        }

        public final String getWindowId() {
            return windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        @Override
        public DeleteMaintenanceWindowRequest build() {
            return new DeleteMaintenanceWindowRequest(this);
        }
    }
}
