/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeregisterTargetFromMaintenanceWindowRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeregisterTargetFromMaintenanceWindowRequest.Builder, DeregisterTargetFromMaintenanceWindowRequest> {
    private final String windowId;

    private final String windowTargetId;

    private DeregisterTargetFromMaintenanceWindowRequest(BuilderImpl builder) {
        this.windowId = builder.windowId;
        this.windowTargetId = builder.windowTargetId;
    }

    /**
     * <p>
     * The ID of the Maintenance Window the target should be removed from.
     * </p>
     * 
     * @return The ID of the Maintenance Window the target should be removed from.
     */
    public String windowId() {
        return windowId;
    }

    /**
     * <p>
     * The ID of the target definition to remove.
     * </p>
     * 
     * @return The ID of the target definition to remove.
     */
    public String windowTargetId() {
        return windowTargetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((windowId() == null) ? 0 : windowId().hashCode());
        hashCode = 31 * hashCode + ((windowTargetId() == null) ? 0 : windowTargetId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterTargetFromMaintenanceWindowRequest)) {
            return false;
        }
        DeregisterTargetFromMaintenanceWindowRequest other = (DeregisterTargetFromMaintenanceWindowRequest) obj;
        if (other.windowId() == null ^ this.windowId() == null) {
            return false;
        }
        if (other.windowId() != null && !other.windowId().equals(this.windowId())) {
            return false;
        }
        if (other.windowTargetId() == null ^ this.windowTargetId() == null) {
            return false;
        }
        if (other.windowTargetId() != null && !other.windowTargetId().equals(this.windowTargetId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (windowId() != null) {
            sb.append("WindowId: ").append(windowId()).append(",");
        }
        if (windowTargetId() != null) {
            sb.append("WindowTargetId: ").append(windowTargetId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowId":
            return Optional.of(clazz.cast(windowId()));
        case "WindowTargetId":
            return Optional.of(clazz.cast(windowTargetId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeregisterTargetFromMaintenanceWindowRequest> {
        /**
         * <p>
         * The ID of the Maintenance Window the target should be removed from.
         * </p>
         * 
         * @param windowId
         *        The ID of the Maintenance Window the target should be removed from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowId(String windowId);

        /**
         * <p>
         * The ID of the target definition to remove.
         * </p>
         * 
         * @param windowTargetId
         *        The ID of the target definition to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowTargetId(String windowTargetId);
    }

    static final class BuilderImpl implements Builder {
        private String windowId;

        private String windowTargetId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterTargetFromMaintenanceWindowRequest model) {
            windowId(model.windowId);
            windowTargetId(model.windowTargetId);
        }

        public final String getWindowId() {
            return windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getWindowTargetId() {
            return windowTargetId;
        }

        @Override
        public final Builder windowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
            return this;
        }

        public final void setWindowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
        }

        @Override
        public DeregisterTargetFromMaintenanceWindowRequest build() {
            return new DeregisterTargetFromMaintenanceWindowRequest(this);
        }
    }
}
