/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeregisterTaskFromMaintenanceWindowResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DeregisterTaskFromMaintenanceWindowResponse.Builder, DeregisterTaskFromMaintenanceWindowResponse> {
    private final String windowId;

    private final String windowTaskId;

    private DeregisterTaskFromMaintenanceWindowResponse(BuilderImpl builder) {
        this.windowId = builder.windowId;
        this.windowTaskId = builder.windowTaskId;
    }

    /**
     * <p>
     * The ID of the Maintenance Window the task was removed from.
     * </p>
     * 
     * @return The ID of the Maintenance Window the task was removed from.
     */
    public String windowId() {
        return windowId;
    }

    /**
     * <p>
     * The ID of the task removed from the Maintenance Window.
     * </p>
     * 
     * @return The ID of the task removed from the Maintenance Window.
     */
    public String windowTaskId() {
        return windowTaskId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((windowId() == null) ? 0 : windowId().hashCode());
        hashCode = 31 * hashCode + ((windowTaskId() == null) ? 0 : windowTaskId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterTaskFromMaintenanceWindowResponse)) {
            return false;
        }
        DeregisterTaskFromMaintenanceWindowResponse other = (DeregisterTaskFromMaintenanceWindowResponse) obj;
        if (other.windowId() == null ^ this.windowId() == null) {
            return false;
        }
        if (other.windowId() != null && !other.windowId().equals(this.windowId())) {
            return false;
        }
        if (other.windowTaskId() == null ^ this.windowTaskId() == null) {
            return false;
        }
        if (other.windowTaskId() != null && !other.windowTaskId().equals(this.windowTaskId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (windowId() != null) {
            sb.append("WindowId: ").append(windowId()).append(",");
        }
        if (windowTaskId() != null) {
            sb.append("WindowTaskId: ").append(windowTaskId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowId":
            return Optional.of(clazz.cast(windowId()));
        case "WindowTaskId":
            return Optional.of(clazz.cast(windowTaskId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeregisterTaskFromMaintenanceWindowResponse> {
        /**
         * <p>
         * The ID of the Maintenance Window the task was removed from.
         * </p>
         * 
         * @param windowId
         *        The ID of the Maintenance Window the task was removed from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowId(String windowId);

        /**
         * <p>
         * The ID of the task removed from the Maintenance Window.
         * </p>
         * 
         * @param windowTaskId
         *        The ID of the task removed from the Maintenance Window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowTaskId(String windowTaskId);
    }

    static final class BuilderImpl implements Builder {
        private String windowId;

        private String windowTaskId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterTaskFromMaintenanceWindowResponse model) {
            windowId(model.windowId);
            windowTaskId(model.windowTaskId);
        }

        public final String getWindowId() {
            return windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getWindowTaskId() {
            return windowTaskId;
        }

        @Override
        public final Builder windowTaskId(String windowTaskId) {
            this.windowTaskId = windowTaskId;
            return this;
        }

        public final void setWindowTaskId(String windowTaskId) {
            this.windowTaskId = windowTaskId;
        }

        @Override
        public DeregisterTaskFromMaintenanceWindowResponse build() {
            return new DeregisterTaskFromMaintenanceWindowResponse(this);
        }
    }
}
