/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeDocumentResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeDocumentResponse.Builder, DescribeDocumentResponse> {
    private final DocumentDescription document;

    private DescribeDocumentResponse(BuilderImpl builder) {
        this.document = builder.document;
    }

    /**
     * <p>
     * Information about the SSM document.
     * </p>
     * 
     * @return Information about the SSM document.
     */
    public DocumentDescription document() {
        return document;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((document() == null) ? 0 : document().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDocumentResponse)) {
            return false;
        }
        DescribeDocumentResponse other = (DescribeDocumentResponse) obj;
        if (other.document() == null ^ this.document() == null) {
            return false;
        }
        if (other.document() != null && !other.document().equals(this.document())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (document() != null) {
            sb.append("Document: ").append(document()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Document":
            return Optional.of(clazz.cast(document()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeDocumentResponse> {
        /**
         * <p>
         * Information about the SSM document.
         * </p>
         * 
         * @param document
         *        Information about the SSM document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder document(DocumentDescription document);
    }

    static final class BuilderImpl implements Builder {
        private DocumentDescription document;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDocumentResponse model) {
            document(model.document);
        }

        public final DocumentDescription.Builder getDocument() {
            return document != null ? document.toBuilder() : null;
        }

        @Override
        public final Builder document(DocumentDescription document) {
            this.document = document;
            return this;
        }

        public final void setDocument(DocumentDescription.BuilderImpl document) {
            this.document = document != null ? document.build() : null;
        }

        @Override
        public DescribeDocumentResponse build() {
            return new DescribeDocumentResponse(this);
        }
    }
}
