/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeInstanceInformationResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeInstanceInformationResponse.Builder, DescribeInstanceInformationResponse> {
    private final List<InstanceInformation> instanceInformationList;

    private final String nextToken;

    private DescribeInstanceInformationResponse(BuilderImpl builder) {
        this.instanceInformationList = builder.instanceInformationList;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The instance information list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The instance information list.
     */
    public List<InstanceInformation> instanceInformationList() {
        return instanceInformationList;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceInformationList() == null) ? 0 : instanceInformationList().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceInformationResponse)) {
            return false;
        }
        DescribeInstanceInformationResponse other = (DescribeInstanceInformationResponse) obj;
        if (other.instanceInformationList() == null ^ this.instanceInformationList() == null) {
            return false;
        }
        if (other.instanceInformationList() != null && !other.instanceInformationList().equals(this.instanceInformationList())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (instanceInformationList() != null) {
            sb.append("InstanceInformationList: ").append(instanceInformationList()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceInformationList":
            return Optional.of(clazz.cast(instanceInformationList()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeInstanceInformationResponse> {
        /**
         * <p>
         * The instance information list.
         * </p>
         * 
         * @param instanceInformationList
         *        The instance information list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceInformationList(Collection<InstanceInformation> instanceInformationList);

        /**
         * <p>
         * The instance information list.
         * </p>
         * 
         * @param instanceInformationList
         *        The instance information list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceInformationList(InstanceInformation... instanceInformationList);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<InstanceInformation> instanceInformationList;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceInformationResponse model) {
            instanceInformationList(model.instanceInformationList);
            nextToken(model.nextToken);
        }

        public final Collection<InstanceInformation.Builder> getInstanceInformationList() {
            return instanceInformationList != null ? instanceInformationList.stream().map(InstanceInformation::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceInformationList(Collection<InstanceInformation> instanceInformationList) {
            this.instanceInformationList = InstanceInformationListCopier.copy(instanceInformationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInformationList(InstanceInformation... instanceInformationList) {
            instanceInformationList(Arrays.asList(instanceInformationList));
            return this;
        }

        public final void setInstanceInformationList(Collection<InstanceInformation.BuilderImpl> instanceInformationList) {
            this.instanceInformationList = InstanceInformationListCopier.copyFromBuilder(instanceInformationList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeInstanceInformationResponse build() {
            return new DescribeInstanceInformationResponse(this);
        }
    }
}
